/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.security.layer;

import java.security.AccessController;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RAInstanceManager;
import weblogic.kernel.Kernel;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

class SecureBaseImpl {
    protected Object myObj;
    protected RAInstanceManager raIM;

    SecureBaseImpl(Object object, RAInstanceManager rAInstanceManager, String string, AuthenticatedSubject authenticatedSubject) {
        if (!SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject)) {
            throw new SecurityException("KernelId is required to instantiate SecureBaseImpl class, Subject '" + (authenticatedSubject == null ? "<null>" : authenticatedSubject.toString()) + "' is not the kernel identity");
        }
        if (object == null) {
            Debug.throwAssertionError(string + " == null");
        }
        this.myObj = object;
        this.raIM = rAInstanceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        this.raIM.getAdapterLayer().pushSubject(authenticatedSubject);
        try {
            boolean bl = this.myObj.equals(object);
            Object var5_4 = null;
            this.raIM.getAdapterLayer().popSubject(authenticatedSubject);
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.raIM.getAdapterLayer().popSubject(authenticatedSubject);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        this.raIM.getAdapterLayer().pushSubject(authenticatedSubject);
        try {
            int n = this.myObj.hashCode();
            Object var4_3 = null;
            this.raIM.getAdapterLayer().popSubject(authenticatedSubject);
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.raIM.getAdapterLayer().popSubject(authenticatedSubject);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (Kernel.isServer()) {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            this.raIM.getAdapterLayer().pushSubject(authenticatedSubject);
            try {
                String string = this.myObj.toString();
                Object var4_3 = null;
                this.raIM.getAdapterLayer().popSubject(authenticatedSubject);
                return string;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.raIM.getAdapterLayer().popSubject(authenticatedSubject);
                throw throwable;
            }
        }
        return this.myObj.toString();
    }

    public Object getSourceObj() {
        return this.myObj;
    }
}

