/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.security.layer;

import java.security.AccessController;
import javax.resource.spi.work.Work;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.security.layer.AdapterLayer;
import weblogic.connector.security.layer.SecureBaseImpl;
import weblogic.kernel.Kernel;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class WorkImpl
extends SecureBaseImpl
implements Work {
    private ClassLoader rarClassLoader;
    private ClassLoader origClassLoader;

    public WorkImpl(Work work, RAInstanceManager rAInstanceManager, AuthenticatedSubject authenticatedSubject) {
        super(work, rAInstanceManager, "Work", authenticatedSubject);
        if (rAInstanceManager == null) {
            throw new AssertionError((Object)"Attempt to create Work outside the context of the Connector container");
        }
        this.rarClassLoader = rAInstanceManager.getClassloader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        if (Kernel.isServer()) {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            AdapterLayer adapterLayer = this.raIM != null ? this.raIM.getAdapterLayer() : null;
            try {
                if (adapterLayer == null) {
                    throw new AssertionError((Object)"Attempt to run Work outside the context of the Connector container");
                }
                adapterLayer.pushWorkSubject(authenticatedSubject);
                this.runIt();
                Object var4_3 = null;
                if (adapterLayer == null) return;
                adapterLayer.popSubject(authenticatedSubject);
                return;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (adapterLayer == null) throw throwable;
                adapterLayer.popSubject(authenticatedSubject);
                throw throwable;
            }
        } else {
            this.runIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void release() {
        if (Kernel.isServer()) {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            AdapterLayer adapterLayer = this.raIM != null ? this.raIM.getAdapterLayer() : null;
            try {
                if (adapterLayer == null) {
                    throw new AssertionError((Object)"Attempt to release Work outside the context of the Connector container");
                }
                adapterLayer.pushWorkSubject(authenticatedSubject);
                this.releaseIt();
                Object var4_3 = null;
                if (adapterLayer == null) return;
                adapterLayer.popSubject(authenticatedSubject);
                return;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (adapterLayer == null) throw throwable;
                adapterLayer.popSubject(authenticatedSubject);
                throw throwable;
            }
        } else {
            this.releaseIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runIt() {
        try {
            this.setClassLoader();
            ((Work)this.myObj).run();
            Object var2_1 = null;
            this.resetClassLoader();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.resetClassLoader();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseIt() {
        try {
            this.setClassLoader();
            ((Work)this.myObj).release();
            Object var2_1 = null;
            this.resetClassLoader();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.resetClassLoader();
            throw throwable;
        }
    }

    private void setClassLoader() {
        if (this.rarClassLoader != null) {
            this.origClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.rarClassLoader);
        }
    }

    private void resetClassLoader() {
        if (this.rarClassLoader != null) {
            Thread.currentThread().setContextClassLoader(this.origClassLoader);
        }
    }
}

