/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.security.outbound;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.GenericCredential;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.connector.ConnectorLogger;
import weblogic.connector.common.Debug;
import weblogic.connector.extensions.Unshareable;
import weblogic.connector.external.AuthMechInfo;
import weblogic.connector.external.OutboundInfo;
import weblogic.connector.external.RAInfo;
import weblogic.connector.security.outbound.ResourcePrincipal;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.AuthorizationManager;
import weblogic.security.service.CredentialManager;
import weblogic.security.service.EISResource;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.Resource;

public final class SecurityContext {
    public static final String SHARED_APPNAME = "WEBLOGIC_SHAREDAPP";
    private static final String ipAnonymousConnectionsName = "weblogic_ra_anonymous";
    private static final String ipInitialConnectionsName = "weblogic_ra_initial";
    private static final String ipDefaultConnectionsName = "weblogic_ra_default";
    private AuthenticatedSubject currentSubject = null;
    private AuthorizationManager am = null;
    private ConnectionRequestInfo clientInfo;
    private boolean isContainerManaged;
    private boolean shareable;
    private boolean alwaysUnshareable;
    private String poolName;
    private Subject rpSubject;
    private OutboundInfo outboundInfo;
    private EISResource globalEISRes;
    private EISResource poolEISRes;
    private static Context initialContext;

    public SecurityContext(OutboundInfo outboundInfo, String string, String string2, String string3, ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo, boolean bl, AuthenticatedSubject authenticatedSubject) throws SecurityException {
        this.initialize(outboundInfo, string, string2, string3, managedConnectionFactory, connectionRequestInfo, bl, authenticatedSubject);
    }

    private void initialize(OutboundInfo outboundInfo, String string, String string2, String string3, ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo, boolean bl, AuthenticatedSubject authenticatedSubject) throws SecurityException {
        this.am = (AuthorizationManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)authenticatedSubject, (String)SecurityServiceManager.getDefaultRealmName(), (SecurityService.ServiceType)SecurityService.ServiceType.AUTHORIZE);
        this.currentSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)authenticatedSubject);
        this.outboundInfo = outboundInfo;
        this.poolName = string3;
        this.clientInfo = connectionRequestInfo;
        this.isContainerManaged = true;
        if (SecurityContext.isUnshareableMCF(managedConnectionFactory.getClass())) {
            this.alwaysUnshareable = true;
            this.setShareable(false);
            if (Debug.isSecurityCtxEnabled()) {
                this.debug("The MCF has @Unshareable annotation on it, so it doesn't support share.");
            }
        } else {
            this.setShareable(true);
        }
        this.rpSubject = null;
        this.globalEISRes = SecurityContext.getGlobalEISResource(string, string2, outboundInfo.getRAInfo());
        this.poolEISRes = SecurityContext.getPoolEISResource(string, string2, outboundInfo);
        if (Debug.isSecurityCtxEnabled()) {
            Debug.securityCtx("For pool '" + string3 + "' initializing SecurityContext with AppName = " + ApplicationVersionUtils.getDisplayName(this.globalEISRes.getApplicationName()) + ", ModuleName = " + this.globalEISRes.getModuleName() + ", EIS Type = " + this.globalEISRes.getType() + ", DestinationId = " + this.poolEISRes.getDestinationId() + ", Global ResourceId = " + this.globalEISRes.toString() + ", Pool ResourceId = " + this.poolEISRes.toString());
        }
        this.initSubject(managedConnectionFactory, bl, authenticatedSubject);
    }

    public static boolean isUnshareableMCF(Class clazz) {
        boolean bl = clazz.isAnnotationPresent(Unshareable.class);
        if (bl && Debug.isSecurityCtxEnabled()) {
            Debug.securityCtx("Find Unshareable annotation on MCF class: " + clazz);
        }
        return bl;
    }

    private void initSubject(ManagedConnectionFactory managedConnectionFactory, boolean bl, AuthenticatedSubject authenticatedSubject) throws SecurityException {
        Vector vector = this.getCredentials(bl, authenticatedSubject);
        if (vector != null && vector.size() > 0) {
            this.rpSubject = new Subject();
            Object object = null;
            for (int i = 0; i < vector.size(); ++i) {
                Object object2;
                Object object3;
                object = vector.get(i);
                if (object instanceof PasswordCredential) {
                    object3 = (PasswordCredential)object;
                    object3.setManagedConnectionFactory(managedConnectionFactory);
                    object2 = new ResourcePrincipal(object3.getUserName(), new String(object3.getPassword()));
                    if (Debug.isSecurityCtxEnabled()) {
                        this.debug("Adding resource principal Username: " + object3.getUserName());
                    }
                    AccessController.doPrivileged(new PrivilegedAction((ResourcePrincipal)object2, (PasswordCredential)object3){
                        final /* synthetic */ ResourcePrincipal val$rp;
                        final /* synthetic */ PasswordCredential val$pc;
                        {
                            this.val$rp = resourcePrincipal;
                            this.val$pc = passwordCredential;
                        }

                        public Object run() {
                            SecurityContext.this.rpSubject.getPrincipals().add(this.val$rp);
                            SecurityContext.this.rpSubject.getPrivateCredentials().add(this.val$pc);
                            return null;
                        }
                    });
                    continue;
                }
                if (object instanceof GenericCredential) {
                    object3 = (GenericCredential)object;
                    object2 = new ResourcePrincipal(object3.getName(), "");
                    if (Debug.isSecurityCtxEnabled()) {
                        this.debug("Adding resource principal Username: " + object3.getName());
                    }
                    AccessController.doPrivileged(new PrivilegedAction((ResourcePrincipal)object2, (GenericCredential)object3){
                        final /* synthetic */ ResourcePrincipal val$rp;
                        final /* synthetic */ GenericCredential val$gc;
                        {
                            this.val$rp = resourcePrincipal;
                            this.val$gc = genericCredential;
                        }

                        public Object run() {
                            SecurityContext.this.rpSubject.getPrincipals().add(this.val$rp);
                            SecurityContext.this.rpSubject.getPrivateCredentials().add(this.val$gc);
                            return null;
                        }
                    });
                    continue;
                }
                if (object instanceof GSSCredential) {
                    object3 = (GSSCredential)object;
                    try {
                        object2 = ((Object)object3.getName()).toString();
                    }
                    catch (GSSException gSSException) {
                        throw new SecurityException((Throwable)gSSException);
                    }
                    final ResourcePrincipal resourcePrincipal = new ResourcePrincipal((String)object2, "");
                    if (Debug.isSecurityCtxEnabled()) {
                        this.debug("Adding resource principal Username: " + (String)object2);
                    }
                    AccessController.doPrivileged(new PrivilegedAction((GSSCredential)object3){
                        final /* synthetic */ GSSCredential val$gc;
                        {
                            this.val$gc = gSSCredential;
                        }

                        public Object run() {
                            SecurityContext.this.rpSubject.getPrincipals().add(resourcePrincipal);
                            SecurityContext.this.rpSubject.getPrivateCredentials().add(this.val$gc);
                            return null;
                        }
                    });
                    continue;
                }
                if (!Debug.isSecurityCtxEnabled()) continue;
                this.debug("An unsupported credential type was encountered and will be ignored:  " + object.getClass().getName());
            }
            this.setSubjectReadOnly(this.rpSubject);
        } else if (this.isContainerManaged && Debug.isSecurityCtxEnabled()) {
            Debug.logNoResourcePrincipalFound();
        }
    }

    private void logUsingAppManagedSecurity() {
        if (Debug.isSecurityCtxEnabled()) {
            Debug.securityCtx(" For pool '" + this.poolName + " ': establishing Security Context for Application Managed client");
            if (this.clientInfo == null) {
                Debug.logNoConnectionRequestInfo();
            }
        }
    }

    private void checkResourceReference() throws NamingException {
        Object object = null;
        String string = "java:/comp/env/wls-connector-resref";
        Context context = SecurityContext.getInitialContext();
        try {
            object = context.lookup(string);
        }
        catch (NameNotFoundException nameNotFoundException) {
            if (Debug.isSecurityCtxEnabled()) {
                Debug.securityCtx("For pool '" + this.poolName + "' SecurityContext.checkResourceReference() couldn't find " + string + " for calling component");
            }
            return;
        }
        if (object == null && Debug.isSecurityCtxEnabled()) {
            Debug.securityCtx("For pool '" + this.poolName + "' SecurityContext.checkResourceReference() returned null entry for " + string + " of calling component");
        } else if (object != null) {
            this.processResourceReference((Context)object);
        }
    }

    private boolean processResourceReference(Context context) throws NamingException {
        boolean bl = false;
        NamingEnumeration<NameClassPair> namingEnumeration = context.list("");
        while (namingEnumeration.hasMore() && !bl) {
            NameClassPair nameClassPair = namingEnumeration.next();
            NameClassPair nameClassPair2 = nameClassPair;
            if (nameClassPair2.getClassName().endsWith("NamingNode")) {
                bl = this.processResourceReference((Context)context.lookup(nameClassPair2.getName()));
                if (!bl) continue;
                break;
            }
            if (nameClassPair2.getName().endsWith("JNDI")) {
                String string = nameClassPair2.getName();
                if (Debug.isSecurityCtxEnabled()) {
                    this.debug("Found JNDI entry \"" + string + "\" in wls-connector-resref context -- looking it up...");
                }
                Object object = context.lookup(string);
                String string2 = object.toString();
                if (Debug.isSecurityCtxEnabled()) {
                    this.debug("Lookup of \"" + string + "\" yields: \"" + string2 + "\", comparing with \"" + this.outboundInfo.getJndiName() + "\"");
                }
                if (string2 != null && string2.equalsIgnoreCase(this.outboundInfo.getJndiName())) {
                    String string3;
                    String string4;
                    if (Debug.isSecurityCtxEnabled()) {
                        this.debug("Found matching entry with jndiName: " + string2);
                    }
                    if ((string4 = this.lookupResAttr(string, context, "Auth")) != null) {
                        boolean bl2 = this.isContainerManaged = !string4.equalsIgnoreCase("Application");
                        if (Debug.isSecurityCtxEnabled()) {
                            Debug.logRequestedSecurityType(string2, string4);
                        }
                    }
                    if ((string3 = this.lookupResAttr(string, context, "SharingScope")) != null) {
                        boolean bl3 = string3.equalsIgnoreCase("Shareable");
                        if (bl3 && this.alwaysUnshareable) {
                            String string5 = context.getNameInNamespace() + "/" + string;
                            String string6 = SecurityContext.getResRefName(string5) == null ? "UNKNOWN" : SecurityContext.getResRefName(string5);
                            String string7 = SecurityContext.getCallerName(string5) == null ? "UNKNOWN" : SecurityContext.getCallerName(string5);
                            ConnectorLogger.logShareableRefToUnshareableMCF((String)string2, (String)string6, (String)string7);
                            bl3 = false;
                            string3 = "Unshareable";
                        }
                        this.setShareable(bl3);
                        if (Debug.isSecurityCtxEnabled()) {
                            Debug.logRequestedSharingScope(string2, string3);
                        }
                    } else if (this.alwaysUnshareable) {
                        String string8 = context.getNameInNamespace() + "/" + string;
                        String string9 = SecurityContext.getResRefName(string8) == null ? "UNKNOWN" : SecurityContext.getResRefName(string8);
                        String string10 = SecurityContext.getCallerName(string8) == null ? "UNKNOWN" : SecurityContext.getCallerName(string8);
                        ConnectorLogger.logUnknownShareableRefToUnshareableMCF((String)string2, (String)string9, (String)string10);
                        this.setShareable(false);
                    } else {
                        this.setShareable(true);
                    }
                    bl = true;
                    break;
                }
                if (!Debug.isSecurityCtxEnabled()) continue;
                this.debug("Skipping non-matching JNDIName");
                continue;
            }
            if (!Debug.isSecurityCtxEnabled()) continue;
            this.debug("Skipping non-JNDI Entry in context");
        }
        return bl;
    }

    public static String getCallerName(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("/webapp/") >= 0) {
            String string2 = string.substring(string.indexOf("/webapp/") + 8);
            int n = string2.indexOf("/");
            if (n > 0) {
                return string2.substring(0, n);
            }
            return null;
        }
        if (string.indexOf("/ejb/") >= 0) {
            String string3 = string.substring(string.indexOf("/ejb/") + 5);
            int n = string3.indexOf("/");
            if (n > 0) {
                return string3.substring(0, n);
            }
            return null;
        }
        return null;
    }

    public static String getResRefName(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("/wls-connector-resref/") >= 0) {
            String string2 = string.substring(string.indexOf("/wls-connector-resref/") + "/wls-connector-resref/".length());
            if (string2.endsWith("JNDI")) {
                return string2.substring(0, string2.lastIndexOf("JNDI"));
            }
            return string2;
        }
        return null;
    }

    private String lookupResAttr(String string, Context context, String string2) {
        Object object = null;
        String string3 = null;
        String string4 = string.substring(0, string.length() - 4) + string2;
        if (Debug.isSecurityCtxEnabled()) {
            this.debug("Now looking up: \"" + string4 + "\" ...");
        }
        try {
            object = context.lookup(string4);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (object != null) {
            string3 = object.toString();
        }
        return string3;
    }

    private void debug(String string) {
        Debug.securityCtx("For pool '" + this.poolName + "' " + string);
    }

    private void setShareable(boolean bl) {
        if (Debug.isSecurityCtxEnabled()) {
            Debug.println(this, ".setShareable() setting shareable to " + bl);
        }
        this.shareable = bl;
    }

    private void setSubjectReadOnly(final Subject subject) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    subject.setReadOnly();
                }
                catch (java.lang.SecurityException securityException) {
                    SecurityContext.this.debug("WARNING:  Failed to modify Subject to be read-only:  " + securityException);
                }
                return null;
            }
        });
    }

    public static EISResource getGlobalEISResource(String string, String string2, RAInfo rAInfo) {
        String string3 = "";
        if (string == null || string.length() == 0) {
            string = SHARED_APPNAME;
        }
        if (rAInfo != null && rAInfo.getEisType() != null) {
            string3 = rAInfo.getEisType();
        }
        return new EISResource(string, string2, string3);
    }

    public static EISResource getPoolEISResource(String string, String string2, OutboundInfo outboundInfo) {
        String string3 = "";
        String string4 = "";
        if (string == null || string.length() == 0) {
            string = SHARED_APPNAME;
        }
        if (outboundInfo != null && outboundInfo.getEisType() != null) {
            string3 = outboundInfo.getEisType();
        }
        if (outboundInfo != null && outboundInfo.getKey() != null) {
            string4 = outboundInfo.getKey();
        }
        return new EISResource(string, string2, string3, string4);
    }

    public boolean isAccessAllowed() {
        boolean bl = this.am.isAccessAllowed(this.currentSubject, (Resource)this.globalEISRes, null);
        if (!bl) {
            Debug.logAccessDeniedWarning(this.poolName, ApplicationVersionUtils.getDisplayName(this.globalEISRes.getApplicationName()), this.globalEISRes.getModuleName(), this.globalEISRes.getEISName());
        }
        return bl;
    }

    public boolean isContainerManaged() {
        return this.isContainerManaged;
    }

    public boolean isEmptyContext() {
        return this.rpSubject == null && this.clientInfo == null;
    }

    public ConnectionRequestInfo getClientInfo() {
        return this.clientInfo;
    }

    public Subject getSubject() {
        return this.rpSubject;
    }

    public boolean isShareable() {
        if (Debug.isSecurityCtxEnabled()) {
            Debug.println(this, ".isShareable() = " + this.shareable);
        }
        return this.shareable;
    }

    private Vector getInitialCredentials(AuthenticatedSubject authenticatedSubject) {
        Vector vector;
        if (Debug.isSecurityCtxEnabled()) {
            this.debug("Looking up credentials for initial connections");
        }
        if ((vector = this.getCredentials(ipInitialConnectionsName, authenticatedSubject)) == null || vector.size() == 0) {
            if (Debug.isSecurityCtxEnabled()) {
                this.debug("No credentials explicitly provided for initial connections.  Will attempt to find default credentials.");
            }
            vector = this.getDefaultCredentials(authenticatedSubject);
        } else if (Debug.isSecurityCtxEnabled()) {
            this.debug("Using provided credentials for initial connections.");
        }
        return vector;
    }

    private Vector getAnonymousCredentials(AuthenticatedSubject authenticatedSubject) {
        Vector vector;
        if (Debug.isSecurityCtxEnabled()) {
            this.debug("No authenticated user, so looking up anonymous credentials");
        }
        if ((vector = this.getCredentials(ipAnonymousConnectionsName, authenticatedSubject)) == null || vector.size() == 0) {
            if (Debug.isSecurityCtxEnabled()) {
                this.debug("No credentials provided for anonymous users.  Will try to find default credentials.");
            }
        } else if (Debug.isSecurityCtxEnabled()) {
            this.debug("Using provided credentials for anonymous users");
        }
        return vector;
    }

    private Vector getDefaultCredentials(AuthenticatedSubject authenticatedSubject) {
        if (Debug.isSecurityCtxEnabled()) {
            this.debug("Looking up default credentials");
        }
        Vector vector = this.getCredentials(ipDefaultConnectionsName, authenticatedSubject);
        if (Debug.isSecurityCtxEnabled()) {
            if (vector == null || vector.size() == 0) {
                this.debug("No default credentials are provided");
            } else {
                this.debug("Using provided default credentials");
            }
        }
        return vector;
    }

    private Vector getNonInitialCredentials(AuthenticatedSubject authenticatedSubject) {
        Vector vector = null;
        try {
            this.checkResourceReference();
        }
        catch (NamingException namingException) {
            Debug.logContextProcessingError(namingException);
        }
        if (this.outboundInfo.getResAuth() != null) {
            this.isContainerManaged = this.outboundInfo.getResAuth().equalsIgnoreCase("Container");
        }
        if (this.isContainerManaged) {
            vector = this.currentSubject == null || this.currentSubject.getPrincipals() == null || this.currentSubject.getPrincipals().size() == 0 ? this.getAnonymousCredentials(authenticatedSubject) : this.getCredentials(this.currentSubject, authenticatedSubject);
            if (vector == null || vector.size() == 0) {
                vector = this.getDefaultCredentials(authenticatedSubject);
            }
        } else {
            vector = null;
            this.logUsingAppManagedSecurity();
        }
        return vector;
    }

    private Vector getCredentials(boolean bl, AuthenticatedSubject authenticatedSubject) {
        Vector vector = bl ? this.getInitialCredentials(authenticatedSubject) : this.getNonInitialCredentials(authenticatedSubject);
        return vector;
    }

    private Vector getCredentials(String string, AuthenticatedSubject authenticatedSubject) {
        return this.getTheCredentials(string, authenticatedSubject);
    }

    private Vector getCredentials(AuthenticatedSubject authenticatedSubject, AuthenticatedSubject authenticatedSubject2) {
        return this.getTheCredentials(authenticatedSubject, authenticatedSubject2);
    }

    private Vector getTheCredentials(Object object, AuthenticatedSubject authenticatedSubject) {
        Vector vector = null;
        if (object == null) {
            return null;
        }
        if (this.getCredentialTypes() == null) {
            if (Debug.isSecurityCtxEnabled()) {
                this.debug("No credential types have been specified. Therefore no credentials can be attempted to be found.");
            }
            return null;
        }
        CredentialManager credentialManager = (CredentialManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)authenticatedSubject, (String)SecurityServiceManager.getDefaultRealmName(), (SecurityService.ServiceType)SecurityService.ServiceType.CREDENTIALMANAGER);
        if (credentialManager != null) {
            if (Debug.isSecurityCtxEnabled()) {
                this.debug("Looking up credentials for initiating principal:  " + this.getUserName(object));
            }
            if (object instanceof String) {
                vector = credentialManager.getCredentials(authenticatedSubject, (String)object, (Resource)this.poolEISRes, this.getCredentialTypes());
                if (vector == null || vector.size() == 0) {
                    if (Debug.isSecurityCtxEnabled()) {
                        this.debug("Matching credentials not found for the pool, checking global mappings");
                    }
                    vector = credentialManager.getCredentials(authenticatedSubject, (String)object, (Resource)this.globalEISRes, this.getCredentialTypes());
                }
            } else if (object instanceof AuthenticatedSubject && ((vector = credentialManager.getCredentials(authenticatedSubject, (AuthenticatedSubject)object, (Resource)this.poolEISRes, this.getCredentialTypes())) == null || vector.size() == 0)) {
                if (Debug.isSecurityCtxEnabled()) {
                    this.debug("Matching credentials not found for the pool, checking global mappings");
                }
                vector = credentialManager.getCredentials(authenticatedSubject, (AuthenticatedSubject)object, (Resource)this.globalEISRes, this.getCredentialTypes());
            }
            if (Debug.isSecurityCtxEnabled()) {
                if (vector == null || vector.size() == 0) {
                    this.debug("No credentials explicitly provided for initiating principal: " + this.getUserName(object) + ".  Will attempt to find default.");
                } else {
                    this.debug("Using provided credentials for initiating principal:  " + this.getUserName(object));
                }
            }
        } else if (Debug.isSecurityCtxEnabled()) {
            this.debug("No Credential Manager configured.  Server will not be able to provide any credentials.");
        }
        return vector;
    }

    private String getUserName(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof AuthenticatedSubject) {
            return SubjectUtils.getUsername((AuthenticatedSubject)((AuthenticatedSubject)object));
        }
        return object.toString();
    }

    private String[] getCredentialTypes() {
        List list = this.outboundInfo.getAuthenticationMechanisms();
        if (list == null || list.size() == 0) {
            if (Debug.isSecurityCtxEnabled()) {
                this.debug("No authentication mechanisms were specified. Therefore no credential types can be attempted to be found.");
            }
            return null;
        }
        String[] stringArray = new String[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            AuthMechInfo authMechInfo = (AuthMechInfo)iterator.next();
            stringArray[n] = authMechInfo.getType();
            if (stringArray[n].equalsIgnoreCase("BasicPassword")) {
                stringArray[n] = "weblogic.UserPassword";
            }
            ++n;
        }
        return stringArray;
    }

    private static Context getInitialContext() throws NamingException {
        if (initialContext == null) {
            initialContext = new InitialContext();
        }
        return initialContext;
    }
}

