/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.transaction.inbound;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Hashtable;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.common.Utils;
import weblogic.connector.exception.RAInboundException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.internal.IgnoreXAResource;

public class InboundRecoveryManager {
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private HashMap<ActivationSpec, String> activationSpec2ResName = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void onActivateEndpoint(RAInstanceManager rAInstanceManager, ActivationSpec activationSpec, String string) throws SystemException {
        Hashtable<String, String> hashtable;
        XAResource[] xAResourceArray;
        block6: {
            xAResourceArray = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Thread.currentThread().setContextClassLoader(rAInstanceManager.getClassloader());
                    Debug.xaIn("set context classloader to adapter's CL: " + rAInstanceManager.getClassloader());
                    xAResourceArray = rAInstanceManager.getAdapterLayer().getXAResources(rAInstanceManager.getResourceAdapter(), new ActivationSpec[]{activationSpec}, kernelId);
                }
                catch (ResourceException resourceException) {
                    Debug.xaIn("Unable to get XAResource from adapter due to exception " + (Object)((Object)resourceException) + "; recovery is disabled for endpoint " + string);
                    hashtable = null;
                    Debug.xaIn("restore context classloader to original CL: " + classLoader);
                    Thread.currentThread().setContextClassLoader(classLoader);
                    break block6;
                }
                hashtable = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                Debug.xaIn("restore context classloader to original CL: " + classLoader);
                Thread.currentThread().setContextClassLoader(classLoader);
                throw throwable;
            }
            Debug.xaIn("restore context classloader to original CL: " + classLoader);
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        if (xAResourceArray != null && xAResourceArray.length == 1 && xAResourceArray[0] != null) {
            XAResource xAResource = xAResourceArray[0];
            if (xAResource instanceof IgnoreXAResource) {
                Debug.xaIn("Adatper returns an IgnoreXAResource; skip recovery for endpoint " + string);
                return;
            }
            String string2 = rAInstanceManager.getJndiName() + "_" + string;
            Debug.xaIn("Register for recovery: resource name: " + string2 + "; XAResource: " + xAResource + "; activationSpec: " + activationSpec);
            hashtable = new Hashtable<String, String>();
            hashtable.put("weblogic.transaction.registration.type", "dynamic");
            hashtable.put("weblogic.transaction.registration.settransactiontimeout", "true");
            ((TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager()).registerResource(string2, xAResource, hashtable);
            this.activationSpec2ResName.put(activationSpec, string2);
            return;
        }
        Debug.xaIn("Adatper doesn't support recovery for endpoint " + string);
    }

    public synchronized void onDeActivateEndpoint(ActivationSpec activationSpec) throws SystemException {
        String string = this.activationSpec2ResName.remove(activationSpec);
        this.unregister(activationSpec, string);
    }

    public synchronized void onRAStop(RAInboundException rAInboundException) {
        for (ActivationSpec activationSpec : this.activationSpec2ResName.keySet()) {
            try {
                String string = this.activationSpec2ResName.get(activationSpec);
                this.unregister(activationSpec, string);
            }
            catch (Exception exception) {
                Utils.consolidateException(rAInboundException, exception);
            }
        }
        this.activationSpec2ResName.clear();
    }

    private void unregister(ActivationSpec activationSpec, String string) throws SystemException {
        if (string != null) {
            Debug.xaIn("Unregister: resource name: " + string + "; activationSpec: " + activationSpec);
            ((TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager()).unregisterResource(string);
        }
    }
}

