/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.transaction.outbound;

import java.security.AccessController;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import weblogic.connector.common.Debug;
import weblogic.connector.common.Utils;
import weblogic.connector.outbound.ConnectionInfo;
import weblogic.connector.outbound.ConnectionPool;
import weblogic.connector.security.outbound.SecurityContext;
import weblogic.connector.transaction.outbound.NonXAWrapper;
import weblogic.connector.transaction.outbound.TxCompletionNotification;
import weblogic.connector.transaction.outbound.TxConnectionEventListener;
import weblogic.connector.transaction.outbound.TxConnectionHandler;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.transaction.TxHelper;
import weblogic.transaction.nonxa.NonXAResource;
import weblogic.utils.StackTraceUtils;

public class LocalTxConnectionHandler
extends TxConnectionHandler {
    private NonXAWrapper localTransactionWrapper;

    public LocalTxConnectionHandler(ManagedConnection managedConnection, ConnectionPool connectionPool, SecurityContext securityContext, ConnectionInfo connectionInfo) throws ResourceException {
        super(managedConnection, connectionPool, securityContext, connectionInfo, "LocalTransaction");
        this.initializeNonXAResource();
        this.addConnectionRuntimeMBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enListResource() throws ResourceException {
        weblogic.transaction.Transaction transaction;
        if (this.transaction == null && (transaction = TxHelper.getTransaction()) != null) {
            block15: {
                Throwable throwable = null;
                boolean bl = false;
                TxCompletionNotification txCompletionNotification = null;
                boolean bl2 = false;
                AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                try {
                    try {
                        this.connPool.getResourceRegistrationManager().enlistResource(this, (Transaction)transaction);
                        bl = true;
                        txCompletionNotification = TxCompletionNotification.register((Transaction)transaction, this);
                        this.connPool.getRAInstanceManager().getAdapterLayer().begin(this.getLocalTransactionWrapper().localTransaction, authenticatedSubject);
                        bl2 = true;
                        this.connPool.getConnectionSharingManager().addSharedConnection(super.getConnectionInfo());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        if (txCompletionNotification != null) {
                            txCompletionNotification.deregister();
                        }
                        if (bl2) {
                            this.getLocalTransactionWrapper().localTransaction.rollback();
                        }
                        if (bl) {
                            this.localTransactionWrapper.disable();
                            this.destroy();
                        }
                        try {
                            String string = Debug.getExceptionEnlistmentFailed(this.connPool.getKey(), throwable2.toString());
                            transaction.setRollbackOnly(string, throwable2);
                        }
                        catch (Throwable throwable3) {
                            Debug.localOut(this.connPool, "Failed to setRollbackOnly after enlistment failure:  " + throwable3 + StackTraceUtils.throwable2StackTrace((Throwable)throwable3));
                        }
                        Object var10_8 = null;
                        if (throwable != null) {
                            if (Debug.isLocalOutEnabled()) {
                                Debug.localOut(this.connPool, "Failed to setup the connection for transaction enlistment:\n" + this.connPool.getRAInstanceManager().getAdapterLayer().throwable2StackTrace(throwable, authenticatedSubject));
                            }
                            String string = Debug.getExceptionEnlistmentFailed(this.connPool.getKey(), throwable.toString());
                            throw new ResourceException(string, throwable);
                        }
                        break block15;
                    }
                    Object var10_7 = null;
                    if (throwable == null) break block15;
                }
                catch (Throwable throwable4) {
                    Object var10_9 = null;
                    if (throwable == null) {
                        throw throwable4;
                    }
                    if (Debug.isLocalOutEnabled()) {
                        Debug.localOut(this.connPool, "Failed to setup the connection for transaction enlistment:\n" + this.connPool.getRAInstanceManager().getAdapterLayer().throwable2StackTrace(throwable, authenticatedSubject));
                    }
                    String string = Debug.getExceptionEnlistmentFailed(this.connPool.getKey(), throwable.toString());
                    throw new ResourceException(string, throwable);
                }
                if (Debug.isLocalOutEnabled()) {
                    Debug.localOut(this.connPool, "Failed to setup the connection for transaction enlistment:\n" + this.connPool.getRAInstanceManager().getAdapterLayer().throwable2StackTrace(throwable, authenticatedSubject));
                }
                String string = Debug.getExceptionEnlistmentFailed(this.connPool.getKey(), throwable.toString());
                throw new ResourceException(string, throwable);
            }
            this.transaction = transaction;
            this.setGlobalTransactionInProgress(true);
        }
    }

    private void initializeNonXAResource() throws ResourceException {
        String string;
        String string2;
        String string3;
        String string4;
        LocalTransaction localTransaction = null;
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        try {
            localTransaction = this.connPool.getRAInstanceManager().getAdapterLayer().getLocalTransaction(this.managedConnection, authenticatedSubject);
        }
        catch (ResourceException resourceException) {
            if (Debug.isLocalOutEnabled()) {
                Debug.localOut(this.connPool, "LocalTxConnectionHandler:  Resource Adapter with key = " + this.connPool.getKey() + " threw ResourceException from its implementation of ManagedConnection.getLocalTransaction(), " + this.connPool.getRAInstanceManager().getAdapterLayer().toString((Object)resourceException, authenticatedSubject) + "\n" + this.connPool.getRAInstanceManager().getAdapterLayer().throwable2StackTrace(resourceException, authenticatedSubject));
            }
            String string5 = this.connPool.getRAInstanceManager().getAdapterLayer().toString((Object)resourceException, authenticatedSubject);
            Debug.logGetLocalTransactionError(string5, this.connPool.getKey());
            Throwable throwable = this.connPool.getRAInstanceManager().getAdapterLayer().getCause(resourceException, authenticatedSubject);
            if (throwable != null && Debug.isLocalOutEnabled()) {
                Debug.localOut(this.connPool, "LocalTxConnectionHandler:  ResourceException has LinkedException:\n" + throwable + "\n" + this.connPool.getRAInstanceManager().getAdapterLayer().throwable2StackTrace(throwable, authenticatedSubject));
            }
            throw resourceException;
        }
        catch (Throwable throwable) {
            string4 = this.connPool.getRAInstanceManager().getAdapterLayer().toString(throwable, authenticatedSubject);
            string3 = this.connPool.getRAInstanceManager().getAdapterLayer().throwable2StackTrace(throwable, authenticatedSubject);
            string2 = Debug.getExceptionMCGetLocalTransactionThrewNonResourceException(this.connPool.getKey(), string4);
            string = Debug.logGetLocalTransactionError(string4, this.connPool.getKey());
            Debug.logStackTraceString(string, string3);
            Utils.throwAsResourceException(string2, throwable);
        }
        if (localTransaction == null) {
            String string6 = Debug.getExceptionMCGetLocalTransactionReturnedNull(this.connPool.getKey());
            Debug.logGetLocalTransactionError(string6, this.connPool.getKey());
            throw new ResourceException(string6);
        }
        try {
            this.localTransactionWrapper = new NonXAWrapper(localTransaction, this);
            this.connPool.getResourceRegistrationManager().addResource(this);
        }
        catch (SystemException systemException) {
            string4 = this.connPool.getRAInstanceManager().getAdapterLayer().toString((Object)systemException, authenticatedSubject);
            string3 = this.connPool.getRAInstanceManager().getAdapterLayer().throwable2StackTrace(systemException, authenticatedSubject);
            string2 = Debug.logRegisterNonXAResourceError(this.getPoolName(), string4);
            Debug.logStackTraceString(string2, string3);
            string = Debug.getExceptionRegisterNonXAFailed(systemException.toString());
            Utils.throwAsResourceException(string, systemException);
        }
    }

    void setLocalTransactionWrapper(NonXAWrapper nonXAWrapper) {
        this.localTransactionWrapper = nonXAWrapper;
    }

    NonXAResource getNonXAResource() {
        return this.localTransactionWrapper;
    }

    NonXAWrapper getLocalTransactionWrapper() {
        return this.localTransactionWrapper;
    }

    public LocalTransaction getLocalTransaction() {
        return this.localTransactionWrapper.localTransaction;
    }

    protected void initializeConnectionEventListener() {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        this.connPool.getRAInstanceManager().getAdapterLayer().addConnectionEventListener(this.managedConnection, new TxConnectionEventListener(this, "LocalTransConnEventListener"), authenticatedSubject);
    }
}

