/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.transaction.outbound;

import java.security.AccessController;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.transaction.xa.Xid;
import weblogic.connector.common.Debug;
import weblogic.connector.transaction.outbound.LocalTxConnectionHandler;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.transaction.nonxa.NonXAException;
import weblogic.transaction.nonxa.NonXAResource;

public final class NonXAWrapper
implements NonXAResource {
    LocalTransaction localTransaction;
    LocalTxConnectionHandler connectionHandler;
    static final long serialVersionUID = -2969897281728638615L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Around_Tx;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Outbound_Transaction_Rollback_Low;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Before_Tx;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_After_Tx;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Outbound_Transaction_Commmit_Medium;
    public static final JoinPoint _WLDF$INST_JPFLD_0;
    public static final JoinPoint _WLDF$INST_JPFLD_1;

    NonXAWrapper(LocalTransaction localTransaction, LocalTxConnectionHandler localTxConnectionHandler) {
        this.localTransaction = localTransaction;
        this.connectionHandler = localTxConnectionHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit(Xid xid, boolean bl) throws NonXAException {
        DynamicJoinPoint dynamicJoinPoint;
        Object[] objectArray;
        boolean bl2 = _WLDF$INST_FLD_Connector_Around_Tx.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var14_6 = null;
        if (bl2) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Around_Tx.isArgumentsCaptureNeeded()) {
                objectArray = InstrumentationSupport.toSensitive((int)3);
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Tx;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (_WLDF$INST_FLD_Connector_Outbound_Transaction_Commmit_Medium.isEnabledAndNotDyeFiltered()) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Outbound_Transaction_Commmit_Medium.isArgumentsCaptureNeeded()) {
                objectArray = InstrumentationSupport.toSensitive((int)3);
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Outbound_Transaction_Commmit_Medium;
            InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        if (_WLDF$INST_FLD_Connector_Before_Tx.isEnabledAndNotDyeFiltered()) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Before_Tx.isArgumentsCaptureNeeded()) {
                objectArray = InstrumentationSupport.toSensitive((int)3);
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Tx;
            InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        try {
            this.debug(" - commit request for xid: " + xid);
            if (this.connectionHandler.isConnectionErrorOccurred()) {
                this.debug(" - connectionHandler.isConnectionErrorOccurred is true; not issuing commit");
                throw new NonXAException("The underlying ManagedConnection met error and is unusable; cannot commit");
            }
            if (this.localTransaction == null) {
                this.debug(" - localTransaction is null; not issuing commit");
                throw new NonXAException("The localTransaction is null; cannot commit");
            }
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            try {
                this.debug(" - issuing commit");
                this.connectionHandler.getPool().getRAInstanceManager().getAdapterLayer().commit(this.localTransaction, authenticatedSubject);
            }
            catch (ResourceException resourceException) {
                String string;
                String string2 = this.connectionHandler.getPool().getRAInstanceManager().getAdapterLayer().toString((Object)resourceException, authenticatedSubject);
                this.debug(" ResourceException during commit request: " + string2);
                Throwable throwable = this.connectionHandler.getPool().getRAInstanceManager().getAdapterLayer().getCause(resourceException, authenticatedSubject);
                if (null != throwable) {
                    string = this.connectionHandler.getPool().getRAInstanceManager().getAdapterLayer().toString(throwable, authenticatedSubject);
                    this.debug("ResourceException has Linked Exception : " + string);
                }
                string = Debug.getExceptionCommitFailed(string2, this.connectionHandler.getPool().getRAInstanceManager().getAdapterLayer().throwable2StackTrace(resourceException, authenticatedSubject));
                NonXAException nonXAException = new NonXAException(string);
                nonXAException.initCause((Throwable)resourceException);
                throw nonXAException;
            }
            Object var12_16 = null;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (_WLDF$INST_FLD_Connector_After_Tx.isEnabledAndNotDyeFiltered()) {
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Tx;
                InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            if (!bl2) throw throwable;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Tx, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            throw throwable;
        }
        if (_WLDF$INST_FLD_Connector_After_Tx.isEnabledAndNotDyeFiltered()) {
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Tx;
            InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        if (!bl2) return;
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Tx, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback(Xid xid) throws NonXAException {
        DiagnosticActionState[] diagnosticActionStateArray;
        DiagnosticAction[] diagnosticActionArray;
        boolean bl;
        block19: {
            block18: {
                block17: {
                    DynamicJoinPoint dynamicJoinPoint;
                    Object[] objectArray;
                    bl = _WLDF$INST_FLD_Connector_Around_Tx.isEnabledAndNotDyeFiltered();
                    diagnosticActionArray = null;
                    diagnosticActionStateArray = null;
                    Object var13_5 = null;
                    if (bl) {
                        objectArray = null;
                        if (_WLDF$INST_FLD_Connector_Around_Tx.isArgumentsCaptureNeeded()) {
                            objectArray = InstrumentationSupport.toSensitive((int)2);
                        }
                        dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
                        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Tx;
                        diagnosticActionArray = delegatingMonitor.getActions();
                        diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                        InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                    }
                    if (_WLDF$INST_FLD_Connector_Outbound_Transaction_Rollback_Low.isEnabledAndNotDyeFiltered()) {
                        objectArray = null;
                        if (_WLDF$INST_FLD_Connector_Outbound_Transaction_Rollback_Low.isArgumentsCaptureNeeded()) {
                            objectArray = InstrumentationSupport.toSensitive((int)2);
                        }
                        dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
                        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Outbound_Transaction_Rollback_Low;
                        InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                    }
                    if (_WLDF$INST_FLD_Connector_Before_Tx.isEnabledAndNotDyeFiltered()) {
                        objectArray = null;
                        if (_WLDF$INST_FLD_Connector_Before_Tx.isArgumentsCaptureNeeded()) {
                            objectArray = InstrumentationSupport.toSensitive((int)2);
                        }
                        dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
                        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Tx;
                        InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                    }
                    try {
                        this.debug(" - rollback request for xid: " + xid);
                        if (this.connectionHandler.isConnectionErrorOccurred()) {
                            this.debug(" - isConnectionErrorOccurred is true; not issuing rollback");
                            Object var11_9 = null;
                            break block17;
                        }
                        if (this.localTransaction == null) {
                            this.debug(" - localTransaction is null; not issuing rollback");
                            break block18;
                        }
                        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                        try {
                            this.debug(" - issuing rollback");
                            this.connectionHandler.getPool().getRAInstanceManager().getAdapterLayer().rollback(this.localTransaction, authenticatedSubject);
                            break block19;
                        }
                        catch (ResourceException resourceException) {
                            String string = this.connectionHandler.getPool().getRAInstanceManager().getAdapterLayer().toString((Object)resourceException, authenticatedSubject);
                            this.debug(" - rollback for xid: " + xid + " ResourceException : " + string);
                            Throwable throwable = this.connectionHandler.getPool().getRAInstanceManager().getAdapterLayer().getCause(resourceException, authenticatedSubject);
                            if (null != throwable) {
                                this.debug(" - rollback for xid: " + xid + " ResourceException has Linked Exception : " + this.connectionHandler.getPool().getRAInstanceManager().getAdapterLayer().toString(throwable, authenticatedSubject));
                            }
                            String string2 = Debug.getExceptionRollbackFailed(string, this.connectionHandler.getPool().getRAInstanceManager().getAdapterLayer().throwable2StackTrace(resourceException, authenticatedSubject));
                            NonXAException nonXAException = new NonXAException(string2);
                            nonXAException.initCause((Throwable)resourceException);
                            throw nonXAException;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_12 = null;
                        if (_WLDF$INST_FLD_Connector_After_Tx.isEnabledAndNotDyeFiltered()) {
                            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Tx;
                            InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                        }
                        if (!bl) throw throwable;
                        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Tx, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                        throw throwable;
                    }
                }
                if (_WLDF$INST_FLD_Connector_After_Tx.isEnabledAndNotDyeFiltered()) {
                    DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Tx;
                    InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                }
                if (!bl) return;
                InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Tx, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                return;
            }
            Object var11_10 = null;
            if (_WLDF$INST_FLD_Connector_After_Tx.isEnabledAndNotDyeFiltered()) {
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Tx;
                InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            if (!bl) return;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Tx, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            return;
        }
        Object var11_11 = null;
        if (_WLDF$INST_FLD_Connector_After_Tx.isEnabledAndNotDyeFiltered()) {
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Tx;
            InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        if (!bl) return;
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Tx, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
    }

    void disable() {
        this.localTransaction = null;
    }

    private void debug(String string) {
        if (Debug.isLocalOutEnabled()) {
            Debug.localOut(this.connectionHandler.getPool(), "NonXAWrapper: " + this + string);
        }
    }

    public boolean isSameRM(NonXAResource nonXAResource) throws NonXAException {
        if (!(nonXAResource instanceof NonXAWrapper)) {
            return false;
        }
        return this.connectionHandler.getManagedConnection() == ((NonXAWrapper)nonXAResource).connectionHandler.getManagedConnection();
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.connector.transaction.outbound.NonXAWrapper");
        _WLDF$INST_FLD_Connector_Around_Tx = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Around_Tx");
        _WLDF$INST_FLD_Connector_Outbound_Transaction_Rollback_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Outbound_Transaction_Rollback_Low");
        _WLDF$INST_FLD_Connector_Before_Tx = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Before_Tx");
        _WLDF$INST_FLD_Connector_After_Tx = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_After_Tx");
        _WLDF$INST_FLD_Connector_Outbound_Transaction_Commmit_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Outbound_Transaction_Commmit_Medium");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"NonXAWrapper.java", (String)"weblogic.connector.transaction.outbound.NonXAWrapper", (String)"commit", (String)"(Ljavax/transaction/xa/Xid;Z)V", (int)62, null, (boolean)false);
        _WLDF$INST_JPFLD_1 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"NonXAWrapper.java", (String)"weblogic.connector.transaction.outbound.NonXAWrapper", (String)"rollback", (String)"(Ljavax/transaction/xa/Xid;)V", (int)124, null, (boolean)false);
    }
}

