/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.transaction.outbound;

import java.security.AccessController;
import java.util.Hashtable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import weblogic.connector.common.Debug;
import weblogic.connector.common.Utils;
import weblogic.connector.exception.NoEnlistXAResourceException;
import weblogic.connector.outbound.ConnectionPool;
import weblogic.connector.security.outbound.SecurityContext;
import weblogic.connector.transaction.outbound.XATxConnectionHandler;
import weblogic.connector.transaction.outbound.XAWrapper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.TransactionManager;

public final class RecoveryOnlyXAWrapper
extends XAWrapper
implements ConnectionEventListener {
    private ManagedConnection mc = null;

    public static RecoveryOnlyXAWrapper initializeRecoveryOnlyXAWrapper(ConnectionPool connectionPool) throws SystemException {
        RecoveryOnlyXAWrapper recoveryOnlyXAWrapper = new RecoveryOnlyXAWrapper(connectionPool);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("weblogic.transaction.registration.type", "standard");
        hashtable.put("weblogic.transaction.registration.settransactiontimeout", "true");
        ((TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager()).registerResource(connectionPool.getName(), (XAResource)recoveryOnlyXAWrapper, hashtable);
        return recoveryOnlyXAWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupRecoveryOnlyXAWrapper() throws SystemException {
        try {
            ((TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager()).unregisterResource(this.pool.getName(), true);
            Object var2_1 = null;
            this.destroy();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.destroy();
            throw throwable;
        }
    }

    private RecoveryOnlyXAWrapper(ConnectionPool connectionPool) {
        super(null, null, connectionPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSameRM(XAResource xAResource) throws XAException {
        boolean bl;
        Utils.startManagement();
        try {
            this.debug(" - isSameRM request");
            boolean bl2 = this == xAResource;
            boolean bl3 = xAResource instanceof XAWrapper && ((XAWrapper)xAResource).getConnectionPool().getName().equals(this.pool.getName());
            boolean bl4 = bl2 || bl3;
            this.debug(" - isSameRM returning " + bl4);
            bl = bl4;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Utils.stopManagement();
            throw throwable;
        }
        Utils.stopManagement();
        return bl;
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        this.debug(" - connectionClosed event on RecoveryOnlyXAWrapper");
        Debug.logInvalidRecoveryEvent("connectionClosed");
        if (this.mc != null) {
            try {
                this.mc.cleanup();
            }
            catch (Throwable throwable) {
                this.debug(" - exception while trying to call cleanup on  ManagedConnection for RecoveryOnlyXAWrapper, " + throwable);
                String string = Debug.logCleanupFailure(throwable.toString());
                Debug.logStackTrace(string, throwable);
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        this.debug(" - connectionErrorOccurred event on RecoveryOnlyXAWrapper", connectionEvent.getException());
        String string = connectionEvent.getException() != null ? connectionEvent.getException().toString() : "";
        String string2 = Debug.logConnectionError(string);
        if (connectionEvent.getException() != null) {
            Debug.logStackTrace(string2, connectionEvent.getException());
        }
        this.destroy();
    }

    public void localTransactionStarted(ConnectionEvent connectionEvent) {
        this.debug(" - localTransactionStarted");
        Debug.logInvalidRecoveryEvent("localTransactionStarted");
    }

    public void localTransactionRolledback(ConnectionEvent connectionEvent) {
        this.debug(" - localTransactionRolledback");
        Debug.logInvalidRecoveryEvent("localTransactionRolledback");
    }

    public void localTransactionCommitted(ConnectionEvent connectionEvent) {
        this.debug(" - localTransactionCommitted");
        Debug.logInvalidRecoveryEvent("localTransactionCommitted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        this.debug(" - destroy called on RecoveryOnlyXAWrapper");
        if (this.mc != null) {
            try {
                try {
                    if (Debug.isXAoutEnabled()) {
                        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                        this.debug(" - destroying ManagedConnection for RecoveryOnlyXAWrapper:  " + this.getRAiM().getAdapterLayer().toString(this.mc, authenticatedSubject));
                    }
                    this.mc.destroy();
                }
                catch (Throwable throwable) {
                    this.debug(" - exception while trying to call destroy on  ManagedConnection for RecoveryOnlyXAWrapper, " + throwable);
                    String string = Debug.logDestroyFailed(throwable.toString());
                    Debug.logStackTrace(string, throwable);
                    Object var4_4 = null;
                    this.xares = null;
                    this.mc = null;
                }
                Object var4_3 = null;
                this.xares = null;
                this.mc = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.xares = null;
                this.mc = null;
                throw throwable;
            }
        }
    }

    private XAResource getRecoveryXAResource() throws ResourceException {
        XAResource xAResource;
        AuthenticatedSubject authenticatedSubject;
        if (this.mc == null) {
            this.mc = this.getRecoveryManagedConnection();
            if (Debug.isXAoutEnabled()) {
                authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                this.debug(" - ManagedConnection for recovery:  " + this.getRAiM().getAdapterLayer().toString(this.mc, authenticatedSubject));
            }
        }
        try {
            authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            xAResource = this.getRAiM().getAdapterLayer().getXAResource(this.mc, authenticatedSubject);
            if (xAResource == null) {
                Debug.logNullXAResource();
                String string = Debug.getExceptionMCGetXAResourceReturnedNull();
                throw new ResourceException(string);
            }
        }
        catch (NoEnlistXAResourceException noEnlistXAResourceException) {
            this.debug(" - ManagedConnection.getXAResource() threw NoEnlistXAResourceException, recovery resource will not be created or enlisted for this connection pool");
            xAResource = null;
            this.enlistableXARes = false;
        }
        catch (ResourceException resourceException) {
            throw resourceException;
        }
        catch (Throwable throwable) {
            String string = Debug.getExceptionMCGetXAResourceThrewNonResourceException(throwable.toString());
            throw new ResourceException(string, throwable);
        }
        this.debug(" - XAResource for recovery:  " + xAResource);
        return xAResource;
    }

    private ManagedConnection getRecoveryManagedConnection() throws ResourceException {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        try {
            SecurityContext securityContext = this.pool.createSecurityContext(null, true, authenticatedSubject);
            Subject subject = securityContext.getSubject();
            ManagedConnectionFactory managedConnectionFactory = this.pool.getManagedConnectionFactory();
            ManagedConnection managedConnection = managedConnectionFactory.createManagedConnection(subject, null);
            if (managedConnection == null) {
                String string = Debug.getExceptionMCFCreateManagedConnectionReturnedNull();
                throw new ResourceException(string);
            }
            managedConnection.addConnectionEventListener((ConnectionEventListener)this);
            return managedConnection;
        }
        catch (ResourceException resourceException) {
            throw resourceException;
        }
        catch (Throwable throwable) {
            String string = Debug.getExceptionInitializeForRecoveryFailed(throwable.toString());
            throw new ResourceException(string, throwable);
        }
    }

    protected void validate(String string) throws XAException {
        block3: {
            if (this.xares == null && this.enlistableXARes) {
                try {
                    this.xares = this.getRecoveryXAResource();
                }
                catch (ResourceException resourceException) {
                    this.debug("Failed to get an XAResource for recovery purposes during call " + string + " :  " + (Object)((Object)resourceException) + ", will attempt to use one from the pool if available");
                    this.useXAResourceFromPool();
                    if (this.xares != null || !this.enlistableXARes) break block3;
                    this.debug("Failed to obtain XAResource from the pool during " + string + ", throwing XAException with XAER_RMERR");
                    XAException xAException = new XAException(-3);
                    xAException.initCause(resourceException);
                    throw xAException;
                }
            }
        }
    }

    protected XAResource getUsableXAResource(String string) throws XAException {
        this.validate(string);
        return this.xares;
    }

    private void useXAResourceFromPool() {
        XATxConnectionHandler xATxConnectionHandler = this.pool.findXATxConnectionHandler();
        xATxConnectionHandler.setXARecoveryWrapper(this);
        this.xares = xATxConnectionHandler.getXAResource();
        this.enlistableXARes = xATxConnectionHandler.isEnlistableXARes();
    }
}

