/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.transaction.outbound;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import weblogic.connector.common.Debug;
import weblogic.connector.transaction.outbound.LocalTxConnectionHandler;
import weblogic.connector.transaction.outbound.TxConnectionHandler;
import weblogic.connector.transaction.outbound.XATxConnectionHandler;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.TransactionManager;

public final class ResourceRegistrationManager {
    private TxConnectionHandler registeredHandler = null;
    private HashSet hashRegistrations = new HashSet();
    static final long serialVersionUID = -4902494837820608521L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Around_Tx;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Before_Tx;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_After_Tx;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Enlist_Resource_Low;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Unregister_Resource_Low;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Register_Resource_Low;
    public static final JoinPoint _WLDF$INST_JPFLD_0;
    public static final JoinPoint _WLDF$INST_JPFLD_1;
    public static final JoinPoint _WLDF$INST_JPFLD_2;

    public synchronized void addResource(TxConnectionHandler txConnectionHandler) throws SystemException {
        if (this.registeredHandler == null) {
            this.registerResource(txConnectionHandler);
            this.registeredHandler = txConnectionHandler;
        }
        this.hashRegistrations.add(txConnectionHandler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void enlistResource(TxConnectionHandler txConnectionHandler, Transaction transaction) throws RollbackException, IllegalStateException, SystemException {
        DynamicJoinPoint dynamicJoinPoint;
        Object[] objectArray;
        boolean bl = _WLDF$INST_FLD_Connector_Around_Tx.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var9_6 = null;
        if (bl) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Around_Tx.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, txConnectionHandler, transaction};
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Tx;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (_WLDF$INST_FLD_Connector_Before_Tx.isEnabledAndNotDyeFiltered()) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Before_Tx.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, txConnectionHandler, transaction};
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Tx;
            InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        if (_WLDF$INST_FLD_Connector_Enlist_Resource_Low.isEnabledAndNotDyeFiltered()) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Enlist_Resource_Low.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, txConnectionHandler, transaction};
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Enlist_Resource_Low;
            InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        try {
            if (this.registeredHandler == null) {
                this.registerResource(txConnectionHandler);
                this.registeredHandler = txConnectionHandler;
            }
            if (txConnectionHandler instanceof XATxConnectionHandler) {
                transaction.enlistResource(((XATxConnectionHandler)txConnectionHandler).getXAResource());
            } else if (txConnectionHandler instanceof LocalTxConnectionHandler) {
                ((weblogic.transaction.Transaction)transaction).enlistResource(((LocalTxConnectionHandler)txConnectionHandler).getNonXAResource());
            } else {
                String string = Debug.getExceptionEnlistResourceIllegalType();
                throw new SystemException(string);
            }
            Object var7_11 = null;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (_WLDF$INST_FLD_Connector_After_Tx.isEnabledAndNotDyeFiltered()) {
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Tx;
                InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            if (!bl) throw throwable;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Tx, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            throw throwable;
        }
        if (_WLDF$INST_FLD_Connector_After_Tx.isEnabledAndNotDyeFiltered()) {
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Tx;
            InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        if (!bl) return;
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Tx, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
    }

    public synchronized void removeResource(TxConnectionHandler txConnectionHandler) {
        this.hashRegistrations.remove(txConnectionHandler);
        if (this.registeredHandler == txConnectionHandler) {
            this.unregisterResource(txConnectionHandler);
            if (this.hashRegistrations.isEmpty()) {
                this.registeredHandler = null;
            } else {
                Iterator iterator = this.hashRegistrations.iterator();
                TxConnectionHandler txConnectionHandler2 = (TxConnectionHandler)iterator.next();
                try {
                    this.registerResource(txConnectionHandler2);
                    this.registeredHandler = txConnectionHandler2;
                }
                catch (SystemException systemException) {
                    if (Debug.isXAoutEnabled()) {
                        Debug.xaOut(txConnectionHandler2.getPool(), "WARNING:  Failed to switch registration to other available resource:  " + (Object)((Object)systemException));
                    }
                    this.registeredHandler = null;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerResource(TxConnectionHandler txConnectionHandler) throws SystemException {
        DynamicJoinPoint dynamicJoinPoint;
        Object[] objectArray;
        boolean bl = _WLDF$INST_FLD_Connector_Around_Tx.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var8_5 = null;
        if (bl) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Around_Tx.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, txConnectionHandler};
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Tx;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (_WLDF$INST_FLD_Connector_Before_Tx.isEnabledAndNotDyeFiltered()) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Before_Tx.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, txConnectionHandler};
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Tx;
            InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        if (_WLDF$INST_FLD_Connector_Register_Resource_Low.isEnabledAndNotDyeFiltered()) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Register_Resource_Low.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, txConnectionHandler};
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Register_Resource_Low;
            InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        try {
            if (txConnectionHandler instanceof XATxConnectionHandler) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("weblogic.transaction.registration.type", "standard");
                hashtable.put("weblogic.transaction.registration.settransactiontimeout", "true");
                ((TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager()).registerResource(txConnectionHandler.getPoolName(), ((XATxConnectionHandler)txConnectionHandler).getXAResource(), hashtable);
            } else if (txConnectionHandler instanceof LocalTxConnectionHandler) {
                ((TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager()).registerDynamicResource(txConnectionHandler.getPoolName(), ((LocalTxConnectionHandler)txConnectionHandler).getNonXAResource());
            } else {
                String string = Debug.getExceptionRegisterResourceIllegalType(txConnectionHandler.getClass().getName());
                throw new SystemException(string);
            }
            Object var6_11 = null;
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            if (_WLDF$INST_FLD_Connector_After_Tx.isEnabledAndNotDyeFiltered()) {
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Tx;
                InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            if (!bl) throw throwable;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Tx, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            throw throwable;
        }
        if (_WLDF$INST_FLD_Connector_After_Tx.isEnabledAndNotDyeFiltered()) {
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Tx;
            InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        if (!bl) return;
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Tx, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unregisterResource(TxConnectionHandler txConnectionHandler) {
        DynamicJoinPoint dynamicJoinPoint;
        Object[] objectArray;
        boolean bl = _WLDF$INST_FLD_Connector_Around_Tx.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var8_5 = null;
        if (bl) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Around_Tx.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, txConnectionHandler};
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_2, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Tx;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (_WLDF$INST_FLD_Connector_Before_Tx.isEnabledAndNotDyeFiltered()) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Before_Tx.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, txConnectionHandler};
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_2, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Tx;
            InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        if (_WLDF$INST_FLD_Connector_Unregister_Resource_Low.isEnabledAndNotDyeFiltered()) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Unregister_Resource_Low.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, txConnectionHandler};
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_2, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Unregister_Resource_Low;
            InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        try {
            block12: {
                try {
                    ((TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager()).unregisterResource(txConnectionHandler.getPoolName());
                }
                catch (SystemException systemException) {
                    if (!Debug.isXAoutEnabled()) break block12;
                    Debug.xaOut(txConnectionHandler.getPool(), "WARNING:  Failed to unregister resource for destroyed connection:  " + (Object)((Object)systemException));
                }
            }
            Object var6_10 = null;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            if (_WLDF$INST_FLD_Connector_After_Tx.isEnabledAndNotDyeFiltered()) {
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Tx;
                InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            if (!bl) throw throwable;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Tx, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            throw throwable;
        }
        if (_WLDF$INST_FLD_Connector_After_Tx.isEnabledAndNotDyeFiltered()) {
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Tx;
            InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        if (!bl) return;
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Tx, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.connector.transaction.outbound.ResourceRegistrationManager");
        _WLDF$INST_FLD_Connector_Around_Tx = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Around_Tx");
        _WLDF$INST_FLD_Connector_Before_Tx = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Before_Tx");
        _WLDF$INST_FLD_Connector_After_Tx = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_After_Tx");
        _WLDF$INST_FLD_Connector_Enlist_Resource_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Enlist_Resource_Low");
        _WLDF$INST_FLD_Connector_Unregister_Resource_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Unregister_Resource_Low");
        _WLDF$INST_FLD_Connector_Register_Resource_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Register_Resource_Low");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"ResourceRegistrationManager.java", (String)"weblogic.connector.transaction.outbound.ResourceRegistrationManager", (String)"enlistResource", (String)"(Lweblogic/connector/transaction/outbound/TxConnectionHandler;Ljavax/transaction/Transaction;)V", (int)85, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Connector_Around_Tx", "Connector_Before_Tx", "Connector_After_Tx", "Connector_Enlist_Resource_Low"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{null, null, null, InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"pool", (String)"weblogic.diagnostics.instrumentation.gathering.JCAConnectionHandlerPoolRenderer", (boolean)false, (boolean)true), null})}), (boolean)false);
        _WLDF$INST_JPFLD_1 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"ResourceRegistrationManager.java", (String)"weblogic.connector.transaction.outbound.ResourceRegistrationManager", (String)"registerResource", (String)"(Lweblogic/connector/transaction/outbound/TxConnectionHandler;)V", (int)170, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Connector_Around_Tx", "Connector_Before_Tx", "Connector_Register_Resource_Low", "Connector_After_Tx"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{null, null, InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"pool", (String)"weblogic.diagnostics.instrumentation.gathering.JCAConnectionHandlerPoolRenderer", (boolean)false, (boolean)true)}), null}), (boolean)false);
        _WLDF$INST_JPFLD_2 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"ResourceRegistrationManager.java", (String)"weblogic.connector.transaction.outbound.ResourceRegistrationManager", (String)"unregisterResource", (String)"(Lweblogic/connector/transaction/outbound/TxConnectionHandler;)V", (int)207, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Connector_Around_Tx", "Connector_Before_Tx", "Connector_After_Tx", "Connector_Unregister_Resource_Low"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{null, null, null, InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"pool", (String)"weblogic.diagnostics.instrumentation.gathering.JCAConnectionHandlerPoolRenderer", (boolean)false, (boolean)true)})}), (boolean)false);
    }
}

