/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.transaction.outbound;

import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import weblogic.connector.common.Debug;
import weblogic.connector.outbound.ConnectionHandler;
import weblogic.connector.transaction.outbound.TxConnectionHandler;

final class TxCompletionNotification
implements Synchronization {
    private ConnectionHandler connHandler;
    private boolean deregistered;

    private TxCompletionNotification(ConnectionHandler connectionHandler) {
        this.connHandler = connectionHandler;
        this.deregistered = false;
        this.debug("Registered object for transaction completion notification");
    }

    public static TxCompletionNotification register(Transaction transaction, ConnectionHandler connectionHandler) throws SystemException, RollbackException {
        TxCompletionNotification txCompletionNotification = new TxCompletionNotification(connectionHandler);
        transaction.registerSynchronization((Synchronization)txCompletionNotification);
        return txCompletionNotification;
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int n) {
        this.debug("Received afterCompletion notification, deregistered = " + this.deregistered);
        if (!this.deregistered) {
            ((TxConnectionHandler)this.connHandler).notifyConnPoolOfTransCompletion();
        }
    }

    public void deregister() {
        this.deregistered = true;
    }

    private void debug(String string) {
        if (Debug.isXAoutEnabled()) {
            Debug.xaOut(this.connHandler.getPool(), "TransCompletionNotification ( " + this.toString() + " ) - " + string);
        }
    }
}

