/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.transaction.outbound;

import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.transaction.Transaction;
import weblogic.connector.ConnectorLogger;
import weblogic.connector.outbound.ConnectionHandlerBaseImpl;
import weblogic.connector.outbound.ConnectionInfo;
import weblogic.connector.outbound.ConnectionPool;
import weblogic.connector.security.outbound.SecurityContext;
import weblogic.connector.transaction.outbound.XANotificationListener;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;

public abstract class TxConnectionHandler
extends ConnectionHandlerBaseImpl {
    protected Transaction transaction;
    private boolean globalTransactionInProgress = false;
    private boolean localTransactionInProgress = false;
    static final long serialVersionUID = 5380606416383877290L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_After_Outbound;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Around_Outbound;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Destroy_Connection_Low;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Before_Outbound;
    public static final JoinPoint _WLDF$INST_JPFLD_0;

    TxConnectionHandler(ManagedConnection managedConnection, ConnectionPool connectionPool, SecurityContext securityContext, ConnectionInfo connectionInfo, String string) {
        super(managedConnection, connectionPool, securityContext, connectionInfo, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void destroy() {
        block9: {
            DynamicJoinPoint dynamicJoinPoint;
            Object[] objectArray;
            boolean bl = _WLDF$INST_FLD_Connector_Around_Outbound.isEnabledAndNotDyeFiltered();
            DiagnosticAction[] diagnosticActionArray = null;
            DiagnosticActionState[] diagnosticActionStateArray = null;
            Object var6_4 = null;
            if (bl) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Around_Outbound.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{this};
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Outbound;
                diagnosticActionArray = delegatingMonitor.getActions();
                diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            if (_WLDF$INST_FLD_Connector_Destroy_Connection_Low.isEnabledAndNotDyeFiltered()) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Destroy_Connection_Low.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{this};
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Destroy_Connection_Low;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            if (_WLDF$INST_FLD_Connector_Before_Outbound.isEnabledAndNotDyeFiltered()) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Before_Outbound.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{this};
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Outbound;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            try {
                this.connPool.getResourceRegistrationManager().removeResource(this);
                super.destroy();
                Object var4_8 = null;
                if (!bl) break block9;
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                if (bl) {
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Outbound, (DiagnosticAction[])diagnosticActionArray, diagnosticActionStateArray);
                }
                if (!_WLDF$INST_FLD_Connector_After_Outbound.isEnabledAndNotDyeFiltered()) throw throwable;
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Outbound;
                InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                throw throwable;
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Outbound, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (!_WLDF$INST_FLD_Connector_After_Outbound.isEnabledAndNotDyeFiltered()) return;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Outbound;
        InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
    }

    void notifyConnPoolOfTransCompletion() {
        this.setGlobalTransactionInProgress(false);
        this.transaction = null;
        if (!this.isDestroyed) {
            this.connPool.releaseOnTransactionCompleted(this.getConnectionInfo());
            this.dissociateHandles();
        } else {
            this.destroyConnection();
        }
    }

    public void setLocalTransactionInProgress(boolean bl, String string) {
        if (this.isGlobalTransactionInProgress()) {
            String string2 = ConnectorLogger.logAdapterShouldnotSendLocalTxEvent((String)string);
            throw new IllegalStateException(string2);
        }
        this.setLocalTransactionInProgress(bl);
    }

    public void setLocalTransactionInProgress(boolean bl) {
        if (!this.localTransactionInProgress && bl) {
            XANotificationListener.getInstance().registerNotification(this);
        } else if (this.localTransactionInProgress && !bl) {
            XANotificationListener.getInstance().deregisterNotification(this);
        }
        this.localTransactionInProgress = bl;
    }

    public synchronized void setGlobalTransactionInProgress(boolean bl) {
        this.globalTransactionInProgress = bl;
    }

    public synchronized boolean isGlobalTransactionInProgress() {
        return this.globalTransactionInProgress;
    }

    public boolean isLocalTransactionInProgress() {
        return this.localTransactionInProgress;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void cleanup() throws ResourceException {
        this.globalTransactionInProgress = false;
        this.localTransactionInProgress = false;
        super.cleanup();
    }

    public synchronized boolean isInTransaction() {
        return this.isLocalTransactionInProgress() || this.isGlobalTransactionInProgress();
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.connector.transaction.outbound.TxConnectionHandler");
        _WLDF$INST_FLD_Connector_After_Outbound = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_After_Outbound");
        _WLDF$INST_FLD_Connector_Around_Outbound = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Around_Outbound");
        _WLDF$INST_FLD_Connector_Destroy_Connection_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Destroy_Connection_Low");
        _WLDF$INST_FLD_Connector_Before_Outbound = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Before_Outbound");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"TxConnectionHandler.java", (String)"weblogic.connector.transaction.outbound.TxConnectionHandler", (String)"destroy", (String)"()V", (int)62, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Connector_After_Outbound", "Connector_Destroy_Connection_Low", "Connector_Around_Outbound", "Connector_Before_Outbound"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{null, InstrumentationSupport.createPointcutHandlingInfo((ValueHandlingInfo)InstrumentationSupport.createValueHandlingInfo((String)"pool", (String)"weblogic.diagnostics.instrumentation.gathering.JCAConnectionHandlerPoolRenderer", (boolean)false, (boolean)true), null, null), null, null}), (boolean)false);
    }
}

