/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.transaction.outbound;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import weblogic.connector.common.Debug;
import weblogic.connector.outbound.ConnectionHandler;
import weblogic.kernel.AuditableThreadLocal;
import weblogic.kernel.AuditableThreadLocalFactory;
import weblogic.kernel.ThreadLocalInitialValue;
import weblogic.transaction.BeginNotificationListener;
import weblogic.transaction.ServerTransactionManager;
import weblogic.transaction.TransactionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XANotificationListener
implements BeginNotificationListener {
    private static XANotificationListener xaNotifListenerSingleton = new XANotificationListener();
    private boolean jtaRegistered = false;
    private int registedCount = 0;
    private AuditableThreadLocal xaThreadLocal = AuditableThreadLocalFactory.createThreadLocal((ThreadLocalInitialValue)new XANotificationThreadLocal());

    static final XANotificationListener getInstance() {
        return xaNotifListenerSingleton;
    }

    public void beginNotification(Object object) throws NotSupportedException, SystemException {
        if (!this.getRegistedHandlers().isEmpty()) {
            String string = Debug.getExceptionXAStartInLocalTxIllegal();
            throw new NotSupportedException(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerNotification(ConnectionHandler connectionHandler) {
        XANotificationListener xANotificationListener = xaNotifListenerSingleton;
        synchronized (xANotificationListener) {
            if (!this.jtaRegistered) {
                ((ServerTransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager()).registerBeginNotificationListener((BeginNotificationListener)xaNotifListenerSingleton, null);
                this.jtaRegistered = true;
            }
            ++this.registedCount;
        }
        this.getRegistedHandlers().add(connectionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregisterNotification(ConnectionHandler connectionHandler) {
        List<ConnectionHandler> list = this.getRegistedHandlers();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != connectionHandler) continue;
            list.remove(i);
            XANotificationListener xANotificationListener = xaNotifListenerSingleton;
            synchronized (xANotificationListener) {
                --this.registedCount;
                this.unregisterFromJTAIfNeeded();
                break;
            }
        }
    }

    private void unregisterFromJTAIfNeeded() {
        if (this.jtaRegistered && this.registedCount <= 0) {
            ((ServerTransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager()).unregisterBeginNotificationListener((BeginNotificationListener)xaNotifListenerSingleton);
            this.jtaRegistered = false;
            this.registedCount = 0;
        }
    }

    private List<ConnectionHandler> getRegistedHandlers() {
        return (List)this.xaThreadLocal.get();
    }

    private class XANotificationThreadLocal
    extends ThreadLocalInitialValue {
        private XANotificationThreadLocal() {
        }

        protected final Object initialValue() {
            return new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final Object resetValue(Object object) {
            ArrayList arrayList = (ArrayList)object;
            if (!arrayList.isEmpty()) {
                XANotificationListener xANotificationListener = xaNotifListenerSingleton;
                synchronized (xANotificationListener) {
                    XANotificationListener.this.registedCount -= arrayList.size();
                    XANotificationListener.this.unregisterFromJTAIfNeeded();
                }
                arrayList.clear();
            }
            return arrayList;
        }
    }
}

