/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.transaction.outbound;

import java.security.AccessController;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import weblogic.connector.common.Debug;
import weblogic.connector.common.Utils;
import weblogic.connector.exception.NoEnlistXAResourceException;
import weblogic.connector.outbound.ConnectionInfo;
import weblogic.connector.outbound.ConnectionPool;
import weblogic.connector.security.outbound.SecurityContext;
import weblogic.connector.transaction.outbound.RecoveryOnlyXAWrapper;
import weblogic.connector.transaction.outbound.TxCompletionNotification;
import weblogic.connector.transaction.outbound.TxConnectionEventListener;
import weblogic.connector.transaction.outbound.TxConnectionHandler;
import weblogic.connector.transaction.outbound.XAWrapper;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.transaction.TxHelper;
import weblogic.utils.StackTraceUtils;

public final class XATxConnectionHandler
extends TxConnectionHandler {
    boolean enlistableXARes;
    XAResource xaRes;
    RecoveryOnlyXAWrapper recoveryWrapper = null;
    static final long serialVersionUID = 3242721431232342780L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_After_Outbound;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Around_Outbound;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Destroy_Connection_Low;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Before_Outbound;
    public static final JoinPoint _WLDF$INST_JPFLD_0;

    public XATxConnectionHandler(ManagedConnection managedConnection, ConnectionPool connectionPool, SecurityContext securityContext, ConnectionInfo connectionInfo) throws ResourceException {
        super(managedConnection, connectionPool, securityContext, connectionInfo, "XATransaction");
        this.setGlobalTransactionInProgress(false);
        this.enlistableXARes = true;
        this.initializeXAResource();
        this.addConnectionRuntimeMBean();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void destroy() {
        block10: {
            DynamicJoinPoint dynamicJoinPoint;
            Object[] objectArray;
            boolean bl = _WLDF$INST_FLD_Connector_Around_Outbound.isEnabledAndNotDyeFiltered();
            DiagnosticAction[] diagnosticActionArray = null;
            DiagnosticActionState[] diagnosticActionStateArray = null;
            Object var6_4 = null;
            if (bl) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Around_Outbound.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{this};
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Outbound;
                diagnosticActionArray = delegatingMonitor.getActions();
                diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            if (_WLDF$INST_FLD_Connector_Destroy_Connection_Low.isEnabledAndNotDyeFiltered()) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Destroy_Connection_Low.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{this};
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Destroy_Connection_Low;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            if (_WLDF$INST_FLD_Connector_Before_Outbound.isEnabledAndNotDyeFiltered()) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Before_Outbound.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{this};
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Outbound;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            try {
                if (this.recoveryWrapper != null) {
                    this.recoveryWrapper.destroy();
                    this.recoveryWrapper = null;
                }
                super.destroy();
                Object var4_8 = null;
                if (!bl) break block10;
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                if (bl) {
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Outbound, (DiagnosticAction[])diagnosticActionArray, diagnosticActionStateArray);
                }
                if (!_WLDF$INST_FLD_Connector_After_Outbound.isEnabledAndNotDyeFiltered()) throw throwable;
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Outbound;
                InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                throw throwable;
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Outbound, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (!_WLDF$INST_FLD_Connector_After_Outbound.isEnabledAndNotDyeFiltered()) return;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Outbound;
        InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enListResource() throws ResourceException {
        weblogic.transaction.Transaction transaction;
        if (this.transaction == null && (transaction = TxHelper.getTransaction()) != null && this.enlistableXARes) {
            block20: {
                Exception exception = null;
                boolean bl = false;
                TxCompletionNotification txCompletionNotification = null;
                try {
                    try {
                        ConnectionInfo connectionInfo = this.connPool.getConnectionSharingManager().getSharedConnection();
                        if (connectionInfo != null && connectionInfo != this.connectionInfo) {
                            int n = this.connPool.getAlternateCount();
                            transaction.enlistResource(this.xaRes, this.connPool.getName() + "_branchalias_" + n);
                        } else {
                            transaction.enlistResource(this.xaRes);
                        }
                        bl = true;
                        txCompletionNotification = TxCompletionNotification.register((Transaction)transaction, this);
                        this.connPool.getConnectionSharingManager().addSharedConnection(super.getConnectionInfo());
                    }
                    catch (Exception exception2) {
                        block19: {
                            block18: {
                                exception = exception2;
                                if (txCompletionNotification != null) {
                                    txCompletionNotification.deregister();
                                }
                                if (bl) {
                                    try {
                                        transaction.delistResource(this.xaRes, 0x20000000);
                                    }
                                    catch (Exception exception3) {
                                        this.destroyConnection();
                                        if (!Debug.isXAoutEnabled()) break block18;
                                        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                                        this.debug("Failed to delistResource, the connection will be destroyed:  " + exception3 + "\n" + this.getRAiM().getAdapterLayer().throwable2StackTrace(exception3, authenticatedSubject));
                                    }
                                }
                            }
                            try {
                                String string = Debug.getExceptionEnlistmentFailed(this.connPool.getKey(), exception2.toString());
                                transaction.setRollbackOnly(string, (Throwable)exception2);
                            }
                            catch (Exception exception4) {
                                if (!Debug.isXAoutEnabled()) break block19;
                                this.debug("Failed to setRollbackOnly after enlistment failure:  " + exception4 + StackTraceUtils.throwable2StackTrace((Throwable)exception4));
                            }
                        }
                        Object var9_12 = null;
                        if (exception != null) {
                            if (Debug.isXAoutEnabled()) {
                                AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                                this.debug("Failed to setup the connection for transaction enlistment:\n" + this.getRAiM().getAdapterLayer().throwable2StackTrace(exception, authenticatedSubject));
                            }
                            String string = Debug.getExceptionEnlistmentFailed(this.connPool.getKey(), exception.toString());
                            throw new ResourceException(string, (Throwable)exception);
                        }
                        break block20;
                    }
                    Object var9_11 = null;
                    if (exception == null) break block20;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    if (exception == null) {
                        throw throwable;
                    }
                    if (Debug.isXAoutEnabled()) {
                        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                        this.debug("Failed to setup the connection for transaction enlistment:\n" + this.getRAiM().getAdapterLayer().throwable2StackTrace(exception, authenticatedSubject));
                    }
                    String string = Debug.getExceptionEnlistmentFailed(this.connPool.getKey(), exception.toString());
                    throw new ResourceException(string, (Throwable)exception);
                }
                if (Debug.isXAoutEnabled()) {
                    AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                    this.debug("Failed to setup the connection for transaction enlistment:\n" + this.getRAiM().getAdapterLayer().throwable2StackTrace(exception, authenticatedSubject));
                }
                String string = Debug.getExceptionEnlistmentFailed(this.connPool.getKey(), exception.toString());
                throw new ResourceException(string, (Throwable)exception);
            }
            this.transaction = transaction;
            this.setGlobalTransactionInProgress(true);
        }
    }

    public void initializeXAResource() throws ResourceException {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        try {
            this.xaRes = this.getRAiM().getAdapterLayer().getXAResource(this.managedConnection, authenticatedSubject);
        }
        catch (NoEnlistXAResourceException noEnlistXAResourceException) {
            this.enlistableXARes = false;
            this.debug("Using Unenlistable XA Resource");
        }
        catch (ResourceException resourceException) {
            if (Debug.isXAoutEnabled()) {
                this.debug("XATxConnectionHandler:  Resource Adapter with Key = " + this.connPool.getKey() + " threw ResourceException from its implementation of ManagedConnection.getXAResource(), " + this.getRAiM().getAdapterLayer().toString((Object)resourceException, authenticatedSubject) + "\n" + this.getRAiM().getAdapterLayer().throwable2StackTrace(resourceException, authenticatedSubject));
            }
            String string = this.getRAiM().getAdapterLayer().toString((Object)resourceException, authenticatedSubject);
            Throwable throwable = this.getRAiM().getAdapterLayer().getCause(resourceException, authenticatedSubject);
            if (throwable != null) {
                String string2 = this.getRAiM().getAdapterLayer().toString(throwable, authenticatedSubject);
                String string3 = Debug.logGetXAResourceError(string2, this.connPool.getKey());
                Debug.logStackTrace(string3, throwable);
                if (Debug.isXAoutEnabled()) {
                    this.debug("XATxConnectionHandler:  ResourceException has Linked Exception:\n" + string2 + "\n" + this.getRAiM().getAdapterLayer().throwable2StackTrace(throwable, authenticatedSubject));
                }
            } else {
                String string4 = Debug.logGetXAResourceError(string, this.connPool.getKey());
                Debug.logStackTrace(string4, resourceException);
            }
            throw resourceException;
        }
        catch (Throwable throwable) {
            String string = this.getRAiM().getAdapterLayer().toString(throwable, authenticatedSubject);
            String string5 = this.getRAiM().getAdapterLayer().throwable2StackTrace(throwable, authenticatedSubject);
            String string6 = Debug.getExceptionMCGetXAResourceThrewNonResourceException(throwable.toString());
            String string7 = Debug.logGetXAResourceError(string, this.connPool.getKey());
            Debug.logStackTraceString(string7, string5);
            Utils.throwAsResourceException(string6, throwable);
        }
        if (!this.enlistableXARes) {
            return;
        }
        if (this.xaRes == null) {
            String string = Debug.getExceptionMCGetXAResourceReturnedNull();
            Debug.logGetXAResourceError(string, this.connPool.getKey());
            throw new ResourceException(string);
        }
        this.xaRes = new XAWrapper(this.xaRes, this, this.connPool);
    }

    private void debug(String string) {
        if (Debug.isXAoutEnabled()) {
            Debug.xaOut(this.connPool, "XATxConnectionHandler: " + string);
        }
    }

    public XAResource getXAResource() {
        return this.xaRes;
    }

    boolean isEnlistableXARes() {
        return this.enlistableXARes;
    }

    public void setXARecoveryWrapper(RecoveryOnlyXAWrapper recoveryOnlyXAWrapper) {
        this.recoveryWrapper = recoveryOnlyXAWrapper;
    }

    protected void initializeConnectionEventListener() {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        this.getRAiM().getAdapterLayer().addConnectionEventListener(this.managedConnection, new TxConnectionEventListener(this, "XATxConnEventListener"), authenticatedSubject);
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.connector.transaction.outbound.XATxConnectionHandler");
        _WLDF$INST_FLD_Connector_After_Outbound = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_After_Outbound");
        _WLDF$INST_FLD_Connector_Around_Outbound = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Around_Outbound");
        _WLDF$INST_FLD_Connector_Destroy_Connection_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Destroy_Connection_Low");
        _WLDF$INST_FLD_Connector_Before_Outbound = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Before_Outbound");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"XATxConnectionHandler.java", (String)"weblogic.connector.transaction.outbound.XATxConnectionHandler", (String)"destroy", (String)"()V", (int)76, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Connector_After_Outbound", "Connector_Destroy_Connection_Low", "Connector_Around_Outbound", "Connector_Before_Outbound"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{null, InstrumentationSupport.createPointcutHandlingInfo((ValueHandlingInfo)InstrumentationSupport.createValueHandlingInfo((String)"pool", (String)"weblogic.diagnostics.instrumentation.gathering.JCAConnectionHandlerPoolRenderer", (boolean)false, (boolean)true), null, null), null, null}), (boolean)false);
    }
}

