/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.transaction.outbound;

import java.security.AccessController;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import weblogic.common.ResourceException;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.common.Utils;
import weblogic.connector.outbound.ConnectionPool;
import weblogic.connector.transaction.outbound.XATxConnectionHandler;
import weblogic.connector.transaction.outbound.XidImpl;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

class XAWrapper
implements XAResource {
    boolean enlistableXARes = true;
    private Xid xidCached = null;
    private static String ORACLE_THIN_DRIVER_XARESOURCE_CLASSNAME = "oracle.jdbc.xa.client.OracleXAResource";
    private static String ORACLE_THIN_DRIVER_90_XARESOURCE_CLASSNAME = "oracle.jdbc.driver.T4CXAResource";
    protected boolean ended = true;
    protected XAResource xares;
    private XATxConnectionHandler connectionHandler;
    private XATxConnectionHandler connectionHandlerForRetry;
    protected ConnectionPool pool;
    private RAInstanceManager raIM;

    XAWrapper(XAResource xAResource, XATxConnectionHandler xATxConnectionHandler, ConnectionPool connectionPool) {
        this.xares = xAResource;
        this.connectionHandler = xATxConnectionHandler;
        this.pool = connectionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean bl) throws XAException {
        Utils.startManagement();
        try {
            this.debug(" - commit request for xid: " + xid);
            XAResource xAResource = this.getUsableXAResource("commit");
            this.debug(" - issuing commit");
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            this.getRAiM().getAdapterLayer().commit(xAResource, this.getXid(xid), bl, authenticatedSubject);
            this.clearXid(xid);
            Object var6_5 = null;
            this.releaseResourceForRetryIfNecessary();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseResourceForRetryIfNecessary();
            Utils.stopManagement();
            throw throwable;
        }
        Utils.stopManagement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int n) throws XAException {
        Utils.startManagement();
        try {
            this.debug(" - end request for xid: " + xid + ", flags = " + n);
            this.validate("end");
            if (!this.isUsingOracleThinDriver() || !this.ended) {
                this.debug(" - issuing end");
                this.ended = true;
                AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                this.getRAiM().getAdapterLayer().end(this.xares, this.getXid(xid), n, authenticatedSubject);
            } else {
                this.debug(" - not issuing repeated call to end because of issue with Oracle Thin Driver (CR100269)");
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Utils.stopManagement();
            throw throwable;
        }
        Utils.stopManagement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        Utils.startManagement();
        try {
            this.debug(" - forget request for xid: " + xid);
            XAResource xAResource = this.getUsableXAResource("forget");
            this.debug(" - issuing forget");
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            this.getRAiM().getAdapterLayer().forget(xAResource, this.getXid(xid), authenticatedSubject);
            this.clearXid(xid);
            Object var5_4 = null;
            this.releaseResourceForRetryIfNecessary();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseResourceForRetryIfNecessary();
            Utils.stopManagement();
            throw throwable;
        }
        Utils.stopManagement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransactionTimeout() throws XAException {
        int n;
        Utils.startManagement();
        try {
            this.debug(" - getTransactionTimeout request");
            this.validate("getTransactionTimeout");
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            n = this.getRAiM().getAdapterLayer().getTransactionTimeout(this.xares, authenticatedSubject);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Utils.stopManagement();
            throw throwable;
        }
        Utils.stopManagement();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSameRM(XAResource xAResource) throws XAException {
        boolean bl;
        Utils.startManagement();
        try {
            this.debug(" - isSameRM request, xares2 = " + xAResource);
            boolean bl2 = this == xAResource;
            boolean bl3 = xAResource instanceof XAWrapper && ((XAWrapper)xAResource).getConnectionPool().getName().equals(this.getConnectionPool().getName());
            boolean bl4 = bl2 || bl3;
            this.debug(" - isSameRM request, returning:  " + bl4);
            bl = bl4;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Utils.stopManagement();
            throw throwable;
        }
        Utils.stopManagement();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        int n;
        Utils.startManagement();
        try {
            this.debug(" - prepare request for xid: " + xid);
            XAResource xAResource = this.getUsableXAResource("prepare");
            this.debug(" - issuing prepare");
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            n = this.getRAiM().getAdapterLayer().prepare(xAResource, this.getXid(xid), authenticatedSubject);
            Object var6_5 = null;
            this.releaseResourceForRetryIfNecessary();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseResourceForRetryIfNecessary();
            Utils.stopManagement();
            throw throwable;
        }
        Utils.stopManagement();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid[] recover(int n) throws XAException {
        Xid[] xidArray;
        Utils.startManagement();
        try {
            this.debug(" - recover request, flag: " + n);
            XAResource xAResource = this.getUsableXAResource("recover");
            this.debug(" - issuing recover");
            Xid[] xidArray2 = null;
            AuthenticatedSubject authenticatedSubject = null;
            if (!this.enlistableXARes) {
                xidArray2 = new Xid[]{};
            } else {
                authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                if (this.callRecoverOnlyOnce() && (n & 0x1000000) == 0x1000000) {
                    xidArray2 = this.getRAiM().getAdapterLayer().recover(xAResource, 0x1800000, authenticatedSubject);
                } else if (!this.callRecoverOnlyOnce()) {
                    xidArray2 = this.getRAiM().getAdapterLayer().recover(xAResource, n, authenticatedSubject);
                }
            }
            if (Debug.isXAoutEnabled()) {
                if (xidArray2 == null || xidArray2.length <= 0) {
                    this.debug(" - recover request, returning no Xids");
                } else {
                    this.debug(" - recover request, returning Xids:  count = " + xidArray2.length);
                    for (int i = 0; i < xidArray2.length; ++i) {
                        this.debug("   #" + i + ":  xid = " + this.getRAiM().getAdapterLayer().toString(xidArray2[i], authenticatedSubject));
                    }
                }
            }
            xidArray = xidArray2;
            Object var7_7 = null;
            this.releaseResourceForRetryIfNecessary();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseResourceForRetryIfNecessary();
            Utils.stopManagement();
            throw throwable;
        }
        Utils.stopManagement();
        return xidArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        Utils.startManagement();
        try {
            this.debug(" - rollback request for xid: " + xid);
            XAResource xAResource = this.getUsableXAResource("rollback");
            this.debug(" - issuing rollback");
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            this.getRAiM().getAdapterLayer().rollback(xAResource, this.getXid(xid), authenticatedSubject);
            this.clearXid(xid);
            Object var5_4 = null;
            this.releaseResourceForRetryIfNecessary();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseResourceForRetryIfNecessary();
            Utils.stopManagement();
            throw throwable;
        }
        Utils.stopManagement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTransactionTimeout(int n) throws XAException {
        boolean bl;
        Utils.startManagement();
        try {
            this.debug(" - setTransactionTimeout request:  seconds = " + n);
            this.validate("setTransactionTimeout");
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            bl = this.getRAiM().getAdapterLayer().setTransactionTimeout(this.xares, n, authenticatedSubject);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Utils.stopManagement();
            throw throwable;
        }
        Utils.stopManagement();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int n) throws XAException {
        Utils.startManagement();
        try {
            this.debug(" - start request for xid: " + xid + ", flags: " + n);
            this.validate("start");
            this.debug(" - issuing start");
            this.xidCached = this.getXid(xid);
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            this.getRAiM().getAdapterLayer().start(this.xares, this.xidCached, n, authenticatedSubject);
            this.ended = false;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Utils.stopManagement();
            throw throwable;
        }
        Utils.stopManagement();
    }

    protected void debug(String string) {
        if (Debug.isXAoutEnabled()) {
            Debug.xaOut(this.getConnectionPool(), this.getClass().getName() + ":  " + this + ", " + string);
        }
    }

    protected void debug(String string, Throwable throwable) {
        if (Debug.isXAoutEnabled()) {
            this.debug(string + ", Exception:  " + throwable);
        }
    }

    protected ConnectionPool getConnectionPool() {
        return this.pool;
    }

    protected boolean isUsingOracleThinDriver() {
        return this.xares != null && this.xares.getClass().getName().equalsIgnoreCase(ORACLE_THIN_DRIVER_XARESOURCE_CLASSNAME);
    }

    protected boolean callRecoverOnlyOnce() {
        return this.xares != null && (this.xares.getClass().getName().equalsIgnoreCase(ORACLE_THIN_DRIVER_90_XARESOURCE_CLASSNAME) || this.xares.getClass().getName().equalsIgnoreCase(ORACLE_THIN_DRIVER_XARESOURCE_CLASSNAME));
    }

    protected void validate(String string) throws XAException {
        if (this.connectionHandler.isConnectionErrorOccurred()) {
            this.debug(" - connectionHandler.isConnectionErrorOccurred is true; not issuing " + string);
            throw new XAException(-3);
        }
        if (this.xares == null) {
            this.debug(" - XAResource is null; not issuing " + string);
            throw new XAException(-3);
        }
    }

    protected XAResource getUsableXAResource(String string) throws XAException {
        if (this.connectionHandler.isConnectionErrorOccurred()) {
            this.debug(" - connectionHandler.isConnectionErrorOccurred is true; try reserve another connection from pool. operation:" + string);
            try {
                this.connectionHandlerForRetry = this.pool.reserveInternal();
            }
            catch (ResourceException resourceException) {
                XAException xAException = new XAException("Connection error occured on original connection, and failed to get new connection from pool.");
                xAException.errorCode = -3;
                xAException.initCause((Throwable)((Object)resourceException));
                throw xAException;
            }
            if (this.connectionHandlerForRetry == null) {
                XAException xAException = new XAException("Connection error occured on original connection, and cannot get new connection from pool.");
                xAException.errorCode = -3;
                throw xAException;
            }
            XAResource xAResource = this.connectionHandlerForRetry.getXAResource();
            XAResource xAResource2 = ((XAWrapper)xAResource).xares;
            this.debug(" get new connection from pool: " + this.connectionHandlerForRetry + "; XAWrapper: " + xAResource + "; phisical XAResoruce" + xAResource2);
            return xAResource2;
        }
        if (this.xares == null) {
            this.debug(" - XAResource is null; not issuing " + string);
            XAException xAException = new XAException("XAResource is null.");
            xAException.errorCode = -3;
            throw xAException;
        }
        return this.xares;
    }

    protected void releaseResourceForRetryIfNecessary() {
        if (this.connectionHandlerForRetry != null) {
            block3: {
                try {
                    this.debug("release the retry resource " + this.connectionHandlerForRetry + "; XAWrapper: " + this.connectionHandlerForRetry.getXAResource());
                    this.pool.releaseResource(this.connectionHandlerForRetry.getConnectionInfo());
                }
                catch (Throwable throwable) {
                    if (!Debug.isXAoutEnabled()) break block3;
                    this.debug("Error occured during release the retry connection/resource. ignore it", throwable);
                }
            }
            this.connectionHandlerForRetry = null;
        }
    }

    protected RAInstanceManager getRAiM() {
        if (this.raIM == null) {
            this.raIM = this.getConnectionPool().getRAInstanceManager();
        }
        return this.raIM;
    }

    private synchronized Xid getXid(Xid xid) {
        Xid xid2 = this.xidCached == null || !this.xidCached.equals(xid) ? new XidImpl(xid) : this.xidCached;
        return xid2;
    }

    private void clearXid(Xid xid) {
        if (this.xidCached != null && this.xidCached.equals(xid)) {
            this.xidCached = null;
        }
    }
}

