/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.work;

import java.util.ArrayList;
import java.util.List;
import weblogic.connector.work.LongRunningWorkRequest;
import weblogic.work.WorkManagerImpl;

public class LongRunningWorkManager {
    private final String name;
    private final List<LongRunningWorkRequest> activeWorks = new ArrayList<LongRunningWorkRequest>();
    private volatile int activeWorkCount = 0;
    private volatile int completedWorkCount = 0;
    private volatile int workCount = 0;

    LongRunningWorkManager(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(LongRunningWorkRequest longRunningWorkRequest) {
        int n;
        LongRunningWorkManager longRunningWorkManager = this;
        synchronized (longRunningWorkManager) {
            n = this.workCount++;
            ++this.activeWorkCount;
            this.activeWorks.add(longRunningWorkRequest);
        }
        WorkManagerImpl.executeDaemonTask((String)("LongRunning Work-" + this.name + "-" + n), (int)5, (Runnable)longRunningWorkRequest);
    }

    public synchronized void cleanup() {
        for (LongRunningWorkRequest longRunningWorkRequest : this.activeWorks) {
            longRunningWorkRequest.release();
        }
        this.activeWorks.clear();
    }

    public int getActiveWorkCount() {
        return this.activeWorkCount;
    }

    public int getCompletedWorkCount() {
        return this.completedWorkCount;
    }

    protected synchronized void unregister(LongRunningWorkRequest longRunningWorkRequest) {
        this.activeWorks.remove(longRunningWorkRequest);
        --this.activeWorkCount;
        ++this.completedWorkCount;
    }
}

