/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.work;

import java.io.Serializable;
import java.security.AccessController;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RACollectionManager;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.extensions.LongRunning;
import weblogic.connector.security.layer.ExecutionContextImpl;
import weblogic.connector.security.layer.WorkImpl;
import weblogic.connector.security.layer.WorkListenerImpl;
import weblogic.connector.work.LongRunningWorkManager;
import weblogic.connector.work.LongRunningWorkRequest;
import weblogic.connector.work.ProxyWork;
import weblogic.connector.work.WorkRequest;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.kernel.KernelStatus;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.StackTraceUtils;
import weblogic.work.WorkManagerFactory;

public class WorkManager
implements javax.resource.spi.work.WorkManager,
Serializable {
    private static final long serialVersionUID = 3997838374571468077L;
    private String appId;
    private String name;
    private boolean acceptingDoWorkCalls;
    private boolean suspended;
    private transient weblogic.work.WorkManager workManager;
    private transient LongRunningWorkManager lrWorkManager;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_After_Work;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Around_Work;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Before_Work;
    public static final JoinPoint _WLDF$INST_JPFLD_0;
    public static final JoinPoint _WLDF$INST_JPFLD_1;
    public static final JoinPoint _WLDF$INST_JPFLD_2;
    public static final JoinPoint _WLDF$INST_JPFLD_3;
    public static final JoinPoint _WLDF$INST_JPFLD_4;
    public static final JoinPoint _WLDF$INST_JPFLD_5;

    private WorkManager(String string, String string2, weblogic.work.WorkManager workManager) {
        this.appId = string;
        this.name = string2;
        this.acceptingDoWorkCalls = true;
        this.suspended = false;
        this.workManager = workManager;
        this.lrWorkManager = new LongRunningWorkManager(string2);
    }

    public static WorkManager create(String string, String string2, weblogic.work.WorkManager workManager) {
        return new WorkManager(string, string2, workManager);
    }

    public static WorkManager create(String string, String string2, int n) {
        return new WorkManager(string, string2, WorkManagerFactory.getInstance().getDefault());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doWork(Runnable runnable) throws WorkException {
        block7: {
            DynamicJoinPoint dynamicJoinPoint;
            Object[] objectArray;
            boolean bl = _WLDF$INST_FLD_Connector_Around_Work.isEnabledAndNotDyeFiltered();
            DiagnosticAction[] diagnosticActionArray = null;
            DiagnosticActionState[] diagnosticActionStateArray = null;
            Object var7_5 = null;
            if (bl) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Around_Work.isArgumentsCaptureNeeded()) {
                    objectArray = InstrumentationSupport.toSensitive((int)2);
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Work;
                diagnosticActionArray = delegatingMonitor.getActions();
                diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            if (_WLDF$INST_FLD_Connector_Before_Work.isEnabledAndNotDyeFiltered()) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Before_Work.isArgumentsCaptureNeeded()) {
                    objectArray = InstrumentationSupport.toSensitive((int)2);
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Work;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            try {
                this.doWork(new ProxyWork(runnable), Long.MAX_VALUE, null, null);
                Object var5_9 = null;
                if (!bl) break block7;
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                if (bl) {
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Work, (DiagnosticAction[])diagnosticActionArray, diagnosticActionStateArray);
                }
                if (!_WLDF$INST_FLD_Connector_After_Work.isEnabledAndNotDyeFiltered()) throw throwable;
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Work;
                InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                throw throwable;
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Work, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (!_WLDF$INST_FLD_Connector_After_Work.isEnabledAndNotDyeFiltered()) return;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Work;
        InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doWork(Work work) throws WorkException {
        block7: {
            DynamicJoinPoint dynamicJoinPoint;
            Object[] objectArray;
            boolean bl = _WLDF$INST_FLD_Connector_Around_Work.isEnabledAndNotDyeFiltered();
            DiagnosticAction[] diagnosticActionArray = null;
            DiagnosticActionState[] diagnosticActionStateArray = null;
            Object var7_5 = null;
            if (bl) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Around_Work.isArgumentsCaptureNeeded()) {
                    objectArray = InstrumentationSupport.toSensitive((int)2);
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Work;
                diagnosticActionArray = delegatingMonitor.getActions();
                diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            if (_WLDF$INST_FLD_Connector_Before_Work.isEnabledAndNotDyeFiltered()) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Before_Work.isArgumentsCaptureNeeded()) {
                    objectArray = InstrumentationSupport.toSensitive((int)2);
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Work;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            try {
                this.doWork(work, Long.MAX_VALUE, null, null);
                Object var5_9 = null;
                if (!bl) break block7;
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                if (bl) {
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Work, (DiagnosticAction[])diagnosticActionArray, diagnosticActionStateArray);
                }
                if (!_WLDF$INST_FLD_Connector_After_Work.isEnabledAndNotDyeFiltered()) throw throwable;
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Work;
                InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                throw throwable;
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Work, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (!_WLDF$INST_FLD_Connector_After_Work.isEnabledAndNotDyeFiltered()) return;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Work;
        InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
    }

    public void doWork(Runnable runnable, long l, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        this.doWork(new ProxyWork(runnable), l, executionContext, workListener);
    }

    public void doWork(Work work, long l, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        Object object;
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        RAInstanceManager rAInstanceManager = RACollectionManager.getRAInstanceManagerByAppIdAndModuleName(this.appId, this.name);
        Work work2 = work;
        if (work == null) {
            String string = Debug.getExceptionWorkIsNull();
            throw new IllegalArgumentException(string);
        }
        work = new WorkImpl(work, rAInstanceManager, authenticatedSubject);
        if (executionContext != null) {
            executionContext = new ExecutionContextImpl(executionContext, rAInstanceManager, authenticatedSubject);
        }
        if (workListener != null) {
            workListener = new WorkListenerImpl(workListener, rAInstanceManager, authenticatedSubject);
        }
        if (Debug.isWorkEnabled()) {
            Debug.work("WorkManager.doWork( " + work + ", " + l + ", " + executionContext + ", " + workListener + " )");
        }
        if (!this.acceptingDoWorkCalls && KernelStatus.isServer()) {
            object = Debug.getExceptionDoWorkNotAccepted();
            WorkManager.rejectWork(work, workListener, (WorkException)new WorkRejectedException((String)object), 2);
        }
        if (this.suspended) {
            object = Debug.getExceptionWorkManagerSuspended();
            WorkManager.rejectWork(work, workListener, (WorkException)new WorkRejectedException((String)object), 2);
        }
        this.sendWorkAcceptedEvent(work, workListener);
        object = this.createRequestAndSchedule(work, l, executionContext, workListener, rAInstanceManager, work2);
        ((WorkRequest)object).blockTillCompletion();
        WorkException workException = ((WorkRequest)object).getException();
        this.reportException(".doWork()", workException);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void scheduleWork(Runnable runnable) throws WorkException {
        block7: {
            DynamicJoinPoint dynamicJoinPoint;
            Object[] objectArray;
            boolean bl = _WLDF$INST_FLD_Connector_Around_Work.isEnabledAndNotDyeFiltered();
            DiagnosticAction[] diagnosticActionArray = null;
            DiagnosticActionState[] diagnosticActionStateArray = null;
            Object var7_5 = null;
            if (bl) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Around_Work.isArgumentsCaptureNeeded()) {
                    objectArray = InstrumentationSupport.toSensitive((int)2);
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_2, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Work;
                diagnosticActionArray = delegatingMonitor.getActions();
                diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            if (_WLDF$INST_FLD_Connector_Before_Work.isEnabledAndNotDyeFiltered()) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Before_Work.isArgumentsCaptureNeeded()) {
                    objectArray = InstrumentationSupport.toSensitive((int)2);
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_2, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Work;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            try {
                this.scheduleWork(new ProxyWork(runnable), Long.MAX_VALUE, null, null);
                Object var5_9 = null;
                if (!bl) break block7;
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                if (bl) {
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Work, (DiagnosticAction[])diagnosticActionArray, diagnosticActionStateArray);
                }
                if (!_WLDF$INST_FLD_Connector_After_Work.isEnabledAndNotDyeFiltered()) throw throwable;
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Work;
                InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                throw throwable;
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Work, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (!_WLDF$INST_FLD_Connector_After_Work.isEnabledAndNotDyeFiltered()) return;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Work;
        InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void scheduleWork(Work work) throws WorkException {
        block7: {
            DynamicJoinPoint dynamicJoinPoint;
            Object[] objectArray;
            boolean bl = _WLDF$INST_FLD_Connector_Around_Work.isEnabledAndNotDyeFiltered();
            DiagnosticAction[] diagnosticActionArray = null;
            DiagnosticActionState[] diagnosticActionStateArray = null;
            Object var7_5 = null;
            if (bl) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Around_Work.isArgumentsCaptureNeeded()) {
                    objectArray = InstrumentationSupport.toSensitive((int)2);
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_3, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Work;
                diagnosticActionArray = delegatingMonitor.getActions();
                diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            if (_WLDF$INST_FLD_Connector_Before_Work.isEnabledAndNotDyeFiltered()) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Before_Work.isArgumentsCaptureNeeded()) {
                    objectArray = InstrumentationSupport.toSensitive((int)2);
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_3, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Work;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            try {
                this.scheduleWork(work, Long.MAX_VALUE, null, null);
                Object var5_9 = null;
                if (!bl) break block7;
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                if (bl) {
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_3, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Work, (DiagnosticAction[])diagnosticActionArray, diagnosticActionStateArray);
                }
                if (!_WLDF$INST_FLD_Connector_After_Work.isEnabledAndNotDyeFiltered()) throw throwable;
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Work;
                InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_3, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                throw throwable;
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_3, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Work, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (!_WLDF$INST_FLD_Connector_After_Work.isEnabledAndNotDyeFiltered()) return;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Work;
        InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_3, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
    }

    public void scheduleWork(Runnable runnable, long l, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        this.scheduleWork(new ProxyWork(runnable), l, executionContext, workListener);
    }

    public void scheduleWork(Work work, long l, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        Object object;
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        RAInstanceManager rAInstanceManager = RACollectionManager.getRAInstanceManagerByAppIdAndModuleName(this.appId, this.name);
        Work work2 = work;
        if (work == null) {
            String string = Debug.getExceptionWorkIsNull();
            throw new IllegalArgumentException(string);
        }
        work = new WorkImpl(work, rAInstanceManager, authenticatedSubject);
        if (executionContext != null) {
            executionContext = new ExecutionContextImpl(executionContext, rAInstanceManager, authenticatedSubject);
        }
        if (workListener != null) {
            workListener = new WorkListenerImpl(workListener, rAInstanceManager, authenticatedSubject);
        }
        if (Debug.isWorkEnabled()) {
            Debug.work("WorkManager.scheduleWork( " + work + ", " + l + ", " + executionContext + ", " + workListener + " )");
        }
        if (this.suspended) {
            object = Debug.getExceptionWorkManagerSuspended();
            WorkManager.rejectWork(work, workListener, (WorkException)new WorkRejectedException((String)object), 2);
        }
        this.sendWorkAcceptedEvent(work, workListener);
        object = this.createRequestAndSchedule(work, l, executionContext, workListener, rAInstanceManager, work2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long startWork(Runnable runnable) throws WorkException {
        long l;
        DynamicJoinPoint dynamicJoinPoint;
        Object[] objectArray;
        boolean bl = _WLDF$INST_FLD_Connector_Around_Work.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var7_5 = null;
        if (bl) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Around_Work.isArgumentsCaptureNeeded()) {
                objectArray = InstrumentationSupport.toSensitive((int)2);
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_4, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Work;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (_WLDF$INST_FLD_Connector_Before_Work.isEnabledAndNotDyeFiltered()) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Before_Work.isArgumentsCaptureNeeded()) {
                objectArray = InstrumentationSupport.toSensitive((int)2);
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_4, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Work;
            InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        try {
            l = this.startWork(new ProxyWork(runnable), Long.MAX_VALUE, null, null);
            Object var5_9 = null;
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            Object object = InstrumentationSupport.convertToObject((long)0L);
            if (bl) {
                InstrumentationSupport.postProcess((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_4, null, (Object)object), (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Work, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            if (!_WLDF$INST_FLD_Connector_After_Work.isEnabledAndNotDyeFiltered()) throw throwable;
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Work;
            InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_4, null, (Object)object), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            throw throwable;
        }
        Object object = InstrumentationSupport.convertToObject((long)l);
        if (bl) {
            InstrumentationSupport.postProcess((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_4, null, (Object)object), (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Work, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (!_WLDF$INST_FLD_Connector_After_Work.isEnabledAndNotDyeFiltered()) return l;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Work;
        InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_4, null, (Object)object), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long startWork(Work work) throws WorkException {
        long l;
        DynamicJoinPoint dynamicJoinPoint;
        Object[] objectArray;
        boolean bl = _WLDF$INST_FLD_Connector_Around_Work.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var7_5 = null;
        if (bl) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Around_Work.isArgumentsCaptureNeeded()) {
                objectArray = InstrumentationSupport.toSensitive((int)2);
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_5, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Work;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (_WLDF$INST_FLD_Connector_Before_Work.isEnabledAndNotDyeFiltered()) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Before_Work.isArgumentsCaptureNeeded()) {
                objectArray = InstrumentationSupport.toSensitive((int)2);
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_5, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Work;
            InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        try {
            l = this.startWork(work, Long.MAX_VALUE, null, null);
            Object var5_9 = null;
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            Object object = InstrumentationSupport.convertToObject((long)0L);
            if (bl) {
                InstrumentationSupport.postProcess((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_5, null, (Object)object), (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Work, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            if (!_WLDF$INST_FLD_Connector_After_Work.isEnabledAndNotDyeFiltered()) throw throwable;
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Work;
            InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_5, null, (Object)object), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            throw throwable;
        }
        Object object = InstrumentationSupport.convertToObject((long)l);
        if (bl) {
            InstrumentationSupport.postProcess((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_5, null, (Object)object), (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Work, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (!_WLDF$INST_FLD_Connector_After_Work.isEnabledAndNotDyeFiltered()) return l;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Work;
        InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_5, null, (Object)object), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        return l;
    }

    public long startWork(Runnable runnable, long l, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        return this.startWork(new ProxyWork(runnable), l, executionContext, workListener);
    }

    public long startWork(Work work, long l, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        Object object;
        long l2 = System.currentTimeMillis();
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        RAInstanceManager rAInstanceManager = RACollectionManager.getRAInstanceManagerByAppIdAndModuleName(this.appId, this.name);
        Work work2 = work;
        if (work == null) {
            String string = Debug.getExceptionWorkIsNull();
            throw new IllegalArgumentException(string);
        }
        work = new WorkImpl(work, rAInstanceManager, authenticatedSubject);
        if (executionContext != null) {
            executionContext = new ExecutionContextImpl(executionContext, rAInstanceManager, authenticatedSubject);
        }
        if (workListener != null) {
            workListener = new WorkListenerImpl(workListener, rAInstanceManager, authenticatedSubject);
        }
        if (Debug.isWorkEnabled()) {
            Debug.work("WorkManager.startWork( " + work + ", " + l + ", " + executionContext + ", " + workListener + " )");
        }
        if (this.suspended) {
            object = Debug.getExceptionWorkManagerSuspended();
            WorkManager.rejectWork(work, workListener, (WorkException)new WorkRejectedException((String)object), 2);
        }
        this.sendWorkAcceptedEvent(work, workListener);
        object = this.createRequestAndSchedule(work, l, executionContext, workListener, rAInstanceManager, work2);
        ((WorkRequest)object).blockTillStart();
        WorkException workException = ((WorkRequest)object).getException();
        this.reportException("WorkManager.startWork()", workException);
        return System.currentTimeMillis() - l2;
    }

    private void sendWorkAcceptedEvent(Work work, WorkListener workListener) {
        if (Debug.isWorkEventsEnabled()) {
            Debug.workEvent("WorkManager.sendWorkAcceptedEvent( " + work + ", " + workListener + " )");
        }
        if (workListener != null) {
            WorkEvent workEvent = new WorkEvent(((WorkImpl)work).getSourceObj(), 1, (Work)((WorkImpl)work).getSourceObj(), null);
            workListener.workAccepted(workEvent);
        }
    }

    private void reportException(String string, WorkException workException) throws WorkException {
        if (workException != null) {
            if (Debug.isWorkEnabled()) {
                Debug.work(string + " threw exception: " + StackTraceUtils.throwable2StackTrace((Throwable)workException));
            }
            throw workException;
        }
    }

    public void acceptDoWorkCalls() {
        this.acceptingDoWorkCalls = true;
    }

    public void suspend() {
        this.suspended = true;
        if (Debug.isWorkEnabled()) {
            Debug.work("WorkManager.suspend()");
        }
    }

    public void resume() {
        this.suspended = false;
        if (Debug.isWorkEnabled()) {
            Debug.work("WorkManager.resume()");
        }
    }

    static void rejectWork(Work work, WorkListener workListener, WorkException workException, int n) throws WorkException {
        if (Debug.isWorkEventsEnabled()) {
            Debug.workEvent("WorkManager.rejectWork( " + workListener + ", " + workException + ", " + n + " )");
        }
        if (workListener != null) {
            WorkEvent workEvent = new WorkEvent(((WorkImpl)work).getSourceObj(), n, (Work)((WorkImpl)work).getSourceObj(), workException);
            workListener.workRejected(workEvent);
        }
        throw workException;
    }

    private WorkRequest createRequestAndSchedule(Work work, long l, ExecutionContext executionContext, WorkListener workListener, RAInstanceManager rAInstanceManager, Work work2) throws WorkException {
        WorkRequest workRequest;
        if (WorkManager.isLongRunningWork(work2)) {
            workRequest = new LongRunningWorkRequest(work, l, executionContext, workListener, rAInstanceManager, this.lrWorkManager);
            this.lrWorkManager.schedule((LongRunningWorkRequest)workRequest);
        } else {
            workRequest = new WorkRequest(work, l, executionContext, workListener, rAInstanceManager);
            this.workManager.schedule((Runnable)workRequest);
        }
        return workRequest;
    }

    public static boolean isLongRunningWork(Work work) {
        boolean bl = work.getClass().isAnnotationPresent(LongRunning.class);
        if (bl && Debug.isWorkEnabled()) {
            Debug.work("WorkManager.isLongRunningWork(): true : work:" + work);
        }
        return bl;
    }

    public LongRunningWorkManager getLongRunningWorkManager() {
        return this.lrWorkManager;
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.connector.work.WorkManager");
        _WLDF$INST_FLD_Connector_After_Work = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_After_Work");
        _WLDF$INST_FLD_Connector_Around_Work = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Around_Work");
        _WLDF$INST_FLD_Connector_Before_Work = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Before_Work");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"WorkManager.java", (String)"weblogic.connector.work.WorkManager", (String)"doWork", (String)"(Ljava/lang/Runnable;)V", (int)123, null, (boolean)false);
        _WLDF$INST_JPFLD_1 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"WorkManager.java", (String)"weblogic.connector.work.WorkManager", (String)"doWork", (String)"(Ljavax/resource/spi/work/Work;)V", (int)136, null, (boolean)false);
        _WLDF$INST_JPFLD_2 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"WorkManager.java", (String)"weblogic.connector.work.WorkManager", (String)"scheduleWork", (String)"(Ljava/lang/Runnable;)V", (int)251, null, (boolean)false);
        _WLDF$INST_JPFLD_3 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"WorkManager.java", (String)"weblogic.connector.work.WorkManager", (String)"scheduleWork", (String)"(Ljavax/resource/spi/work/Work;)V", (int)263, null, (boolean)false);
        _WLDF$INST_JPFLD_4 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"WorkManager.java", (String)"weblogic.connector.work.WorkManager", (String)"startWork", (String)"(Ljava/lang/Runnable;)J", (int)365, null, (boolean)false);
        _WLDF$INST_JPFLD_5 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"WorkManager.java", (String)"weblogic.connector.work.WorkManager", (String)"startWork", (String)"(Ljavax/resource/spi/work/Work;)J", (int)379, null, (boolean)false);
    }
}

