/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.work;

import java.util.HashMap;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.security.layer.WorkImpl;
import weblogic.connector.work.Gid;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.transaction.InterposedTransactionManager;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;
import weblogic.utils.StackTraceUtils;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.spi.WorkContextMapInterceptor;

class WorkRequest
implements Runnable {
    private Work work;
    private int status;
    private long startTimeout;
    private long creationTime;
    private ExecutionContext ec;
    private WorkListener listener;
    private boolean notifyOnWorkStart;
    private boolean notifyOnWorkCompletion;
    private WorkException exception;
    private WorkContextMapInterceptor contexts;
    private RAInstanceManager raIM;
    private static HashMap txIds;
    private boolean txOK;
    private Transaction tx;
    private TransactionManager tm;
    private Work originalWork;
    static final long serialVersionUID = 8675661177125583574L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_After_Work;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Around_Work;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Before_Work;
    public static final JoinPoint _WLDF$INST_JPFLD_0;
    public static final JoinPoint _WLDF$INST_JPFLD_1;
    public static final JoinPoint _WLDF$INST_JPFLD_2;

    WorkRequest(Work work, long l, ExecutionContext executionContext, WorkListener workListener, RAInstanceManager rAInstanceManager) throws WorkException {
        this.work = work;
        this.startTimeout = l;
        this.ec = executionContext;
        this.listener = workListener;
        this.raIM = rAInstanceManager;
        this.tx = null;
        this.originalWork = (Work)((WorkImpl)work).getSourceObj();
        this.creationTime = System.currentTimeMillis();
        this.contexts = WorkContextHelper.getWorkContextHelper().getInterceptor().copyThreadContexts(2);
        this.txOK = false;
    }

    public void run() {
        long l = System.currentTimeMillis();
        if (this.startTimeout != Long.MAX_VALUE && l > this.creationTime + this.startTimeout) {
            this.sendWorkRejectedEvent();
        } else {
            WorkContextHelper.getWorkContextHelper().getInterceptor().restoreThreadContexts(this.contexts);
            this.sendWorkStartedEvent();
            try {
                this.setExecutionContext();
                this.work.run();
                this.sendWorkCompletedEvent(null);
            }
            catch (Throwable throwable) {
                this.sendWorkCompletedEvent(throwable);
            }
        }
    }

    private void setExecutionContext() throws WorkCompletedException {
        try {
            if (Debug.isXAworkEnabled()) {
                Debug.xaWork("WorkRequest.setExecutionContext(), ExecutionContext = " + this.ec);
            }
            this.txOK = this.checkImportedTx();
            if (this.ec != null) {
                Xid xid = this.ec.getXid();
                if (Debug.isXAworkEnabled()) {
                    Debug.xaWork("WorkRequest.setExecutionContext(),  xid = " + TxHelper.xidToString(xid, true));
                }
                if (xid != null) {
                    long l = this.ec.getTransactionTimeout() / 1000L;
                    if (l > Integer.MAX_VALUE) {
                        throw new XAException(-5);
                    }
                    this.tm = TxHelper.getTransactionManager();
                    this.tx = this.tm.getTransaction(xid);
                    weblogic.transaction.Transaction transaction = TxHelper.getTransaction();
                    if (Debug.isXAworkEnabled()) {
                        Debug.xaWork("WorkRequest.setExecutionContext() tx(" + TxHelper.xidToString(xid, true) + ") = " + this.tx);
                        Debug.xaWork("WorkRequest.setExecutionContext() currentTx = " + transaction);
                    }
                    if (this.tx != null && ((weblogic.transaction.Transaction)this.tx).isCoordinatorLocal()) {
                        if (Debug.isXAworkEnabled()) {
                            Debug.xaWork("Setting tx on Work Thread (txid = " + TxHelper.xidToString(xid, true));
                        }
                        this.tm.resume(this.tx);
                        if (Debug.isXAworkEnabled()) {
                            Debug.xaWork("Succeeded in associating tx with thread. tx = " + TxHelper.xidToString(xid, true));
                        }
                    } else {
                        if (this.tx != null && transaction != null && !transaction.equals(this.tx)) {
                            if (Debug.isXAworkEnabled()) {
                                Debug.xaWork("Can't associate tx with thread for txid = " + TxHelper.xidToString(xid, true) + ".  There is a different tx already associated with the thread. (tx = " + TxHelper.xidToString(transaction.getXID(), true) + ")");
                            }
                            throw new WorkCompletedException("Attempt to associate tx with Thread when a different tx is already associated with the thread");
                        }
                        if (Debug.isXAworkEnabled()) {
                            Debug.xaWork("Starting tx using InterposedTransactionManager");
                        }
                        XAResource xAResource = this.getXAResource();
                        int n = new Long(l).intValue();
                        xAResource.setTransactionTimeout(n);
                        xAResource.start(xid, 0);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            String string = Debug.getExceptionSetExecutionContextFailed(throwable.toString());
            throw new WorkCompletedException(string, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendWorkCompletedEvent(Throwable throwable) {
        block21: {
            DynamicJoinPoint dynamicJoinPoint;
            Object[] objectArray;
            boolean bl = _WLDF$INST_FLD_Connector_Around_Work.isEnabledAndNotDyeFiltered();
            DiagnosticAction[] diagnosticActionArray = null;
            DiagnosticActionState[] diagnosticActionStateArray = null;
            Object var9_5 = null;
            if (bl) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Around_Work.isArgumentsCaptureNeeded()) {
                    objectArray = InstrumentationSupport.toSensitive((int)2);
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Work;
                diagnosticActionArray = delegatingMonitor.getActions();
                diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            if (_WLDF$INST_FLD_Connector_Before_Work.isEnabledAndNotDyeFiltered()) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Before_Work.isArgumentsCaptureNeeded()) {
                    objectArray = InstrumentationSupport.toSensitive((int)2);
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Work;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            try {
                WorkRequest workRequest;
                if (Debug.isWorkEventsEnabled()) {
                    Debug.workEvent("WorkRequest.sendWorkCompletedEvent(); listener = " + this.listener);
                }
                if (this.txOK) {
                    try {
                        this.releaseImportedTx(this.work, this.ec);
                    }
                    catch (XAException xAException) {
                        if (throwable == null) {
                            throwable = xAException;
                        }
                        xAException.initCause(throwable);
                        throwable = xAException;
                    }
                }
                if (throwable != null) {
                    if (Debug.isWorkEventsEnabled()) {
                        Debug.workEvent("WorkRequest.sendWorkCompletedEvent() creating WorkCompletedException\n" + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
                    }
                    if (throwable instanceof WorkCompletedException) {
                        this.exception = (WorkCompletedException)throwable;
                    } else {
                        this.exception = new WorkCompletedException();
                        this.exception.setErrorCode("0");
                        this.exception.initCause(throwable);
                    }
                }
                if (this.listener != null) {
                    workRequest = new WorkEvent((Object)this.originalWork, 4, this.originalWork, this.exception);
                    this.listener.workCompleted((WorkEvent)workRequest);
                }
                this.status = 4;
                workRequest = this;
                synchronized (workRequest) {
                    if (this.notifyOnWorkCompletion) {
                        this.notifyAll();
                    }
                }
                Object var7_12 = null;
                if (!bl) break block21;
            }
            catch (Throwable throwable2) {
                Object var7_13 = null;
                if (bl) {
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Work, (DiagnosticAction[])diagnosticActionArray, diagnosticActionStateArray);
                }
                if (!_WLDF$INST_FLD_Connector_After_Work.isEnabledAndNotDyeFiltered()) throw throwable2;
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Work;
                InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                throw throwable2;
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Work, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (!_WLDF$INST_FLD_Connector_After_Work.isEnabledAndNotDyeFiltered()) return;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Work;
        InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendWorkStartedEvent() {
        block13: {
            DynamicJoinPoint dynamicJoinPoint;
            Object[] objectArray;
            boolean bl = _WLDF$INST_FLD_Connector_Around_Work.isEnabledAndNotDyeFiltered();
            DiagnosticAction[] diagnosticActionArray = null;
            DiagnosticActionState[] diagnosticActionStateArray = null;
            Object var8_4 = null;
            if (bl) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Around_Work.isArgumentsCaptureNeeded()) {
                    objectArray = InstrumentationSupport.toSensitive((int)1);
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Work;
                diagnosticActionArray = delegatingMonitor.getActions();
                diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            if (_WLDF$INST_FLD_Connector_Before_Work.isEnabledAndNotDyeFiltered()) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Before_Work.isArgumentsCaptureNeeded()) {
                    objectArray = InstrumentationSupport.toSensitive((int)1);
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Work;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            try {
                WorkRequest workRequest;
                if (Debug.isWorkEventsEnabled()) {
                    Debug.workEvent("WorkRequest.sendWorkStartedEvent(); listener = " + this.listener);
                }
                if (this.listener != null) {
                    workRequest = new WorkEvent((Object)this.originalWork, 3, this.originalWork, null);
                    this.listener.workStarted((WorkEvent)workRequest);
                }
                this.status = 3;
                workRequest = this;
                synchronized (workRequest) {
                    if (this.notifyOnWorkStart) {
                        this.notifyAll();
                    }
                }
                Object var6_10 = null;
                if (!bl) break block13;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                if (bl) {
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Work, (DiagnosticAction[])diagnosticActionArray, diagnosticActionStateArray);
                }
                if (!_WLDF$INST_FLD_Connector_After_Work.isEnabledAndNotDyeFiltered()) throw throwable;
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Work;
                InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                throw throwable;
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Work, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (!_WLDF$INST_FLD_Connector_After_Work.isEnabledAndNotDyeFiltered()) return;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Work;
        InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendWorkRejectedEvent() {
        block12: {
            DynamicJoinPoint dynamicJoinPoint;
            Object[] objectArray;
            boolean bl = _WLDF$INST_FLD_Connector_Around_Work.isEnabledAndNotDyeFiltered();
            DiagnosticAction[] diagnosticActionArray = null;
            DiagnosticActionState[] diagnosticActionStateArray = null;
            Object var8_4 = null;
            if (bl) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Around_Work.isArgumentsCaptureNeeded()) {
                    objectArray = InstrumentationSupport.toSensitive((int)1);
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_2, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Work;
                diagnosticActionArray = delegatingMonitor.getActions();
                diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            if (_WLDF$INST_FLD_Connector_Before_Work.isEnabledAndNotDyeFiltered()) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Before_Work.isArgumentsCaptureNeeded()) {
                    objectArray = InstrumentationSupport.toSensitive((int)1);
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_2, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Work;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            try {
                WorkRequest workRequest;
                if (Debug.isWorkEventsEnabled()) {
                    Debug.workEvent("WorkRequest.sendWorkRejectedEvent(); listener = " + this.listener);
                }
                if (this.listener != null) {
                    this.exception = new WorkRejectedException();
                    this.exception.setErrorCode("1");
                    workRequest = new WorkEvent((Object)this.originalWork, 2, this.originalWork, this.exception);
                    this.listener.workRejected((WorkEvent)workRequest);
                }
                this.status = 2;
                workRequest = this;
                synchronized (workRequest) {
                    this.notifyAll();
                }
                Object var6_10 = null;
                if (!bl) break block12;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                if (bl) {
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Work, (DiagnosticAction[])diagnosticActionArray, diagnosticActionStateArray);
                }
                if (!_WLDF$INST_FLD_Connector_After_Work.isEnabledAndNotDyeFiltered()) throw throwable;
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Work;
                InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                throw throwable;
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Work, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (!_WLDF$INST_FLD_Connector_After_Work.isEnabledAndNotDyeFiltered()) return;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Work;
        InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_2, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void blockTillCompletion() {
        if (this.status == 4) {
            return;
        }
        WorkRequest workRequest = this;
        synchronized (workRequest) {
            if (this.status == 4) {
                return;
            }
            this.notifyOnWorkCompletion = true;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void blockTillStart() {
        if (this.status == 3 || this.status == 4) {
            return;
        }
        WorkRequest workRequest = this;
        synchronized (workRequest) {
            if (this.status == 3 || this.status == 4) {
                return;
            }
            this.notifyOnWorkStart = true;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    WorkException getException() {
        return this.exception;
    }

    private synchronized boolean checkImportedTx() throws WorkException {
        if (Debug.isXAworkEnabled()) {
            Debug.xaWork("WorkRequest.checkImportedTx( " + this.work + ", " + this.ec + ", " + this.listener + " )");
        }
        String string = null;
        if (this.ec != null) {
            Xid xid = this.ec.getXid();
            if (xid == null) {
                if (Debug.isXAworkEnabled()) {
                    Debug.xaWork("WorkRequest.checkImportedTx() found null Xid in ExcecutionContext; continuing with non-tx Work processing");
                }
                return false;
            }
            Gid gid = new Gid(xid.getGlobalTransactionId());
            if (Debug.isXAworkEnabled()) {
                string = "WorkRequest.checkImportedTx( " + this.work + ", " + this.ec + " ) with gid=" + gid;
                Debug.xaWork(string);
            }
            if (txIds.containsKey(gid)) {
                if (Debug.isXAworkEnabled()) {
                    Debug.xaWork(string + " REJECTED.");
                }
                String string2 = Debug.getExceptionImportedTxAlreadyActive(gid != null ? gid.toString() : null);
                throw new WorkCompletedException(string2, "2");
            }
            if (Debug.isXAworkEnabled()) {
                Debug.xaWork(string + " ACCEPTED.");
            }
            txIds.put(gid, this.work);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void releaseImportedTx(Work work, ExecutionContext executionContext) throws XAException {
        String string;
        String string2 = string = executionContext != null ? executionContext.toString() : null;
        if (Debug.isXAworkEnabled()) {
            Debug.xaWork("WorkRequest.releaseImportedTx( " + work + ", " + string + " )");
        }
        if (executionContext != null) {
            Work work2;
            String string3;
            Object object;
            Xid xid = executionContext.getXid();
            if (xid == null) {
                if (Debug.isXAworkEnabled()) {
                    Debug.xaWork("WorkRequest.releaseImportedTx() found null Xid; no imported tx to dissassociate from Work");
                }
                return;
            }
            if (this.tx != null) {
                try {
                    block15: {
                        try {
                            object = TxHelper.getTransactionManager().suspend();
                            if (object != null && object.equals(this.tx)) break block15;
                            Debug.xaWork("WARNING: WorkRequest.releaseImportedTx() tm.suspend() release tx = " + object + " instead of tx = " + this.tx + " as expected");
                        }
                        catch (SystemException systemException) {
                            Debug.xaWork("WARNING: WorkRequest.releaseImportedTx() tm.suspend() threw Exception " + (Object)((Object)systemException));
                            string3 = null;
                            this.tx = null;
                        }
                    }
                    string3 = null;
                    this.tx = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    this.tx = null;
                    throw throwable;
                }
            } else {
                object = this.getXAResource();
                object.end(xid, 0x4000000);
            }
            object = new Gid(xid.getGlobalTransactionId());
            if (Debug.isXAworkEnabled()) {
                Debug.xaWork("WorkRequest.releaseImportedTx( " + work + ", " + string + " ) releasing global tx " + object);
            }
            if ((work2 = (Work)txIds.get(object)) != work) {
                if (Debug.isXAworkEnabled()) {
                    Debug.xaWork("WorkRequest.releaseImportedTx( " + work + ", " + string + " ) failed to release global tx " + object + " ; Work instance does match Work that started tx: " + work2);
                }
                string3 = Debug.getExceptionInvalidGid(((Gid)object).toString());
                throw new IllegalArgumentException(string3);
            }
            if (txIds.remove(object) == null) {
                if (Debug.isXAworkEnabled()) {
                    Debug.xaWork("WorkRequest.releaseImportedTx( " + work + ", " + string + " ) failed to release global tx " + object + " ; WorkManager is not holding Work instance for gid");
                }
                string3 = Debug.getExceptionGidNotRegistered(((Gid)object).toString());
                throw new IllegalArgumentException(string3);
            }
        }
    }

    private XAResource getXAResource() {
        TransactionHelper transactionHelper = TransactionHelper.getTransactionHelper();
        InterposedTransactionManager interposedTransactionManager = (InterposedTransactionManager)transactionHelper.getTransactionManager();
        return interposedTransactionManager.getXAResource();
    }

    Work getWork() {
        return this.work;
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.connector.work.WorkRequest");
        _WLDF$INST_FLD_Connector_After_Work = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_After_Work");
        _WLDF$INST_FLD_Connector_Around_Work = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Around_Work");
        _WLDF$INST_FLD_Connector_Before_Work = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Before_Work");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"WorkRequest.java", (String)"weblogic.connector.work.WorkRequest", (String)"sendWorkCompletedEvent", (String)"(Ljava/lang/Throwable;)V", (int)209, null, (boolean)false);
        _WLDF$INST_JPFLD_1 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"WorkRequest.java", (String)"weblogic.connector.work.WorkRequest", (String)"sendWorkStartedEvent", (String)"()V", (int)261, null, (boolean)false);
        _WLDF$INST_JPFLD_2 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"WorkRequest.java", (String)"weblogic.connector.work.WorkRequest", (String)"sendWorkRejectedEvent", (String)"()V", (int)282, null, (boolean)false);
        txIds = new HashMap(10);
    }
}

