/*
 * Decompiled with CFR 0.152.
 */
package weblogic.console.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.security.AccessController;
import weblogic.Home;
import weblogic.management.ManagementException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ConsoleRuntimeMBean;
import weblogic.management.runtime.DomainRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.protocol.ServerURL;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.http.HttpParsing;

public class ConsoleRuntimeImpl
extends RuntimeMBeanDelegate
implements ConsoleRuntimeMBean {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final char SPECIAL = '\\';
    private static final char SEPARATOR = ';';
    private static final char NULL = '0';

    static void initialize() throws ManagementException {
        if (ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            new ConsoleRuntimeImpl(ConsoleRuntimeImpl.getDomainRuntimeMBean());
        }
    }

    private ConsoleRuntimeImpl(DomainRuntimeMBean domainRuntimeMBean) throws ManagementException {
        super(domainRuntimeMBean.getName(), (RuntimeMBean)domainRuntimeMBean);
        domainRuntimeMBean.setConsoleRuntime(this);
    }

    public boolean isEnabled() {
        File file = new File(Home.getPath() + File.separator + "lib" + File.separator + "consoleapp");
        if (!file.exists()) {
            return false;
        }
        return ConsoleRuntimeImpl.getDomainMBean().isConsoleEnabled();
    }

    public String getHomePageURL() {
        return this.getBaseConsoleURL() + this.getPage("HomePage1");
    }

    public String getSpecificPageURL(String string, String[] stringArray) {
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException("Page must not be null or empty.");
        }
        String string2 = this.getBaseConsoleURL() + this.getPage(string);
        string2 = stringArray != null && stringArray.length > 1 ? string2 + this.getHandle(stringArray) : string2 + this.getHandle(this.getObjectNameContext(ConsoleRuntimeImpl.getDomainObjectName()));
        return string2;
    }

    public String[] getSpecificPageURLs(String string, String[][] stringArray) {
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException("Page must not be null or empty.");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("Contexts must not be null.");
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                stringArray2[i] = this.getSpecificPageURL(string, stringArray[i]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Problem with contexts[" + i + "]", illegalArgumentException);
            }
        }
        return stringArray2;
    }

    public String[] getSpecificPageURLs(String[] stringArray, String[][] stringArray2) {
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("Pages and contexts must not be null and must be the same length.");
        }
        String[] stringArray3 = new String[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            try {
                stringArray3[i] = this.getSpecificPageURL(stringArray[i], stringArray2[i]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Problem with pages/contexts[" + i + "]", illegalArgumentException);
            }
        }
        return stringArray3;
    }

    public String getDefaultPageURL(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length < 1) {
            throw new IllegalArgumentException("Context must not be null or empty.");
        }
        String string2 = this.getBaseConsoleURL() + this.getPage("DispatcherPage") + this.getHandle(stringArray);
        if (string != null && string.length() > 0) {
            string2 = string2 + "&perspective=" + string;
        }
        return string2;
    }

    public String[] getDefaultPageURLs(String[][] stringArray, String string) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Contexts must not be null.");
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                stringArray2[i] = this.getDefaultPageURL(stringArray[i], string);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Problem with contexts[" + i + "]", illegalArgumentException);
            }
        }
        return stringArray2;
    }

    public String[] getDefaultPageURLs(String[][] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("Contexts and perspectives must not be null and must be the same length.");
        }
        String[] stringArray3 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                stringArray3[i] = this.getDefaultPageURL(stringArray[i], stringArray2[i]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Problem with contexts/perspectives[" + i + "]", illegalArgumentException);
            }
        }
        return stringArray3;
    }

    public String[] getObjectNameContext(String string) {
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException("ObjectName must not be null or empty.");
        }
        return new String[]{"com.bea.console.handles.JMXHandle", string};
    }

    private String getPage(String string) {
        return "?_nfpb=true&_pageLabel=" + string;
    }

    private String getHandle(String[] stringArray) {
        if (stringArray == null || stringArray.length < 1) {
            throw new IllegalArgumentException("context must include at least one string : received " + this.getContextString(stringArray));
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0]);
        stringBuffer.append("(\"");
        for (int i = 1; i < stringArray.length; ++i) {
            String string;
            if (i > 1) {
                stringBuffer.append(";");
            }
            if ((string = stringArray[i]) == null) {
                stringBuffer.append('\\');
                stringBuffer.append('0');
                continue;
            }
            for (int j = 0; j < string.length(); ++j) {
                char c = string.charAt(j);
                if (c == '\\') {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue;
                }
                if (c == ';') {
                    stringBuffer.append('\\');
                    stringBuffer.append(';');
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        stringBuffer.append("\")");
        return "&handle=" + HttpParsing.escape((String)stringBuffer.toString(), (String)"UTF-8");
    }

    private String getBaseConsoleURL() {
        try {
            ServerURL serverURL = new ServerURL(ChannelHelper.getLocalAdministrationURL());
            String string = serverURL.getProtocol();
            String string2 = "https".equalsIgnoreCase(string) || "t3s".equalsIgnoreCase(string) || "admin".equalsIgnoreCase(string) ? "https" : "http";
            return string2 + "://" + serverURL.getHost() + ":" + serverURL.getPort() + "/" + ConsoleRuntimeImpl.getDomainMBean().getConsoleContextPath() + "/" + "console.portal";
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    private static DomainRuntimeMBean getDomainRuntimeMBean() {
        return ManagementService.getDomainAccess(kernelId).getDomainRuntime();
    }

    private static DomainMBean getDomainMBean() {
        return ManagementService.getRuntimeAccess(kernelId).getDomain();
    }

    private static String getDomainObjectName() {
        return "com.bea:Name=" + ManagementService.getRuntimeAccess(kernelId).getDomainName() + ",Type=Domain";
    }

    private String getContextString(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

