/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba;

import java.io.FileReader;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import weblogic.corba.j2ee.naming.ORBHelper;
import weblogic.corba.j2ee.naming.Utils;
import weblogic.utils.Getopt2;

public final class cnsls {
    private static String objRefFileName = null;
    private static String globalResolveName = null;
    private static boolean dumpStringRef = false;
    private static boolean dumpRecursive = false;
    private static ORB theORB = null;
    private static String insUrl = "iiop://localhost:7001";
    private static final String CONTEXT_DESIGNATOR = "[context] ";
    private static final String OBJECT_DESIGNATOR = "[object]  ";
    private static final String INDENT = "    ";
    private static final String PROGRAM = "weblogic.corba.cnsls";

    public static void main(String[] stringArray) {
        java.lang.Object object;
        CharSequence charSequence;
        NameComponent[] nameComponentArray;
        cnsls.processCLOpts(stringArray);
        if (System.getProperty("weblogic.system.iiop.enableClient") == null) {
            System.setProperty("weblogic.system.iiop.enableClient", "false");
        }
        NamingContextExt namingContextExt = null;
        try {
            if (objRefFileName != null) {
                int n;
                nameComponentArray = new FileReader(objRefFileName);
                charSequence = new StringBuffer();
                while ((n = nameComponentArray.read()) >= 48) {
                    charSequence.append((char)n);
                }
                theORB = ORB.init((String[])new String[0], null);
                object = theORB.string_to_object(charSequence.toString());
                namingContextExt = NamingContextExtHelper.narrow((Object)object);
            } else {
                theORB = ORBHelper.getORBHelper().getORB(insUrl, null);
                nameComponentArray = theORB.resolve_initial_references("NameService");
                namingContextExt = NamingContextExtHelper.narrow((Object)nameComponentArray);
            }
        }
        catch (Exception exception) {
            System.err.println("Error retrieving name service root object reference: " + exception.getMessage());
            System.exit(1);
        }
        try {
            nameComponentArray = namingContextExt.to_name("");
        }
        catch (Exception exception) {
            System.err.println("Error connecting to name service, please make sure the name service is running.");
            System.exit(1);
        }
        nameComponentArray = null;
        Object object2 = null;
        if (globalResolveName == null || globalResolveName.length() == 0) {
            object2 = namingContextExt._duplicate();
            nameComponentArray = new NameComponent[]{new NameComponent("<root>", "")};
        } else {
            try {
                nameComponentArray = namingContextExt.to_name(globalResolveName);
            }
            catch (Exception exception) {
                System.err.println("Error, invalid name: " + globalResolveName);
                System.exit(1);
            }
            try {
                object2 = namingContextExt.resolve(nameComponentArray);
            }
            catch (NotFound notFound) {
                object = "Error, ";
                switch (notFound.why.value()) {
                    case 0: {
                        object = (String)object + "missing node: ";
                        break;
                    }
                    case 1: {
                        object = (String)object + "not context: ";
                        break;
                    }
                    case 2: {
                        object = (String)object + "not object: ";
                    }
                }
                object = (String)object + notFound.rest_of_name;
                System.out.println((String)object);
                System.exit(1);
            }
            catch (InvalidName invalidName) {
                System.out.println("Error, invalid name");
                System.exit(1);
            }
            catch (CannotProceed cannotProceed) {
                System.out.println("Error, cannot proceed: " + cannotProceed.rest_of_name);
                System.exit(1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("CORBA Exception: " + exception.getMessage());
                System.exit(1);
            }
        }
        try {
            if (object2._is_a(NamingContextHelper.id())) {
                charSequence = NamingContextHelper.narrow((Object)object2);
                object = namingContextExt.to_string(nameComponentArray);
                System.out.println("\n[context] " + (String)object);
                if (dumpStringRef) {
                    cnsls.dumpStringRef(theORB, object2);
                }
                cnsls.dumpBindings((NamingContext)charSequence, 1);
            } else {
                charSequence = namingContextExt.to_string(nameComponentArray);
                System.out.println("\n[object]  " + (String)charSequence);
                if (dumpStringRef) {
                    cnsls.dumpStringRef(theORB, object2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("CORBA Exception: " + exception.getMessage());
            System.exit(1);
        }
    }

    private static void processCLOpts(String[] stringArray) {
        Getopt2 getopt2 = new Getopt2();
        try {
            getopt2.addFlag("h", "Help");
            getopt2.addFlag("s", "Dump stringified IORs");
            getopt2.addFlag("R", "Dump contexts recursively");
            getopt2.addOption("f", "filename", "IOR filename");
            getopt2.addOption("u", "url", "Server URL");
            getopt2.setUsageArgs("[name]");
            if (stringArray.length == 0) {
                getopt2.usageAndExit(PROGRAM);
            }
            getopt2.grok(stringArray);
            if (getopt2.args().length > 0) {
                globalResolveName = getopt2.args()[0];
            }
            if (getopt2.hasOption("h")) {
                getopt2.usageAndExit(PROGRAM);
            }
            objRefFileName = getopt2.getOption("f");
            dumpStringRef = getopt2.hasOption("s");
            dumpRecursive = getopt2.hasOption("R");
            if (getopt2.hasOption("u")) {
                insUrl = getopt2.getOption("u");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Invalid option: " + illegalArgumentException.getMessage());
            getopt2.usageAndExit(PROGRAM);
        }
    }

    private static void dumpBindings(NamingContext namingContext, int n) {
        BindingListHolder bindingListHolder = new BindingListHolder();
        BindingIteratorHolder bindingIteratorHolder = new BindingIteratorHolder();
        namingContext.list(20, bindingListHolder, bindingIteratorHolder);
        cnsls.dumpBindingList(bindingListHolder, namingContext, n);
        if (bindingIteratorHolder.value != null) {
            boolean bl;
            int n2 = bindingListHolder.value.length;
            do {
                try {
                    bl = bindingIteratorHolder.value.next_n(20, bindingListHolder);
                    n2 += bindingListHolder.value.length;
                    cnsls.dumpBindingList(bindingListHolder, namingContext, n);
                }
                catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                    namingContext.list(n2, bindingListHolder, bindingIteratorHolder);
                    bl = true;
                }
            } while (bindingIteratorHolder.value != null && bl);
            try {
                if (bindingIteratorHolder.value != null) {
                    bindingIteratorHolder.value.destroy();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void dumpBindingList(BindingListHolder bindingListHolder, NamingContext namingContext, int n) {
        for (int i = 0; i < bindingListHolder.value.length; ++i) {
            String string = "";
            for (int j = 0; j < n; ++j) {
                string = string + INDENT;
            }
            String string2 = Utils.nameComponentToString(bindingListHolder.value[i].binding_name);
            Object object = null;
            if (dumpStringRef || dumpRecursive) {
                try {
                    object = namingContext.resolve(bindingListHolder.value[i].binding_name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bindingListHolder.value[i].binding_type.value() == 0) {
                System.out.println(string + OBJECT_DESIGNATOR + string2);
                if (!dumpStringRef) continue;
                cnsls.dumpStringRef(theORB, object);
                continue;
            }
            System.out.println(string + CONTEXT_DESIGNATOR + string2);
            if (dumpStringRef) {
                cnsls.dumpStringRef(theORB, object);
            }
            if (!dumpRecursive) continue;
            NamingContext namingContext2 = null;
            try {
                namingContext2 = NamingContextHelper.narrow((Object)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                cnsls.dumpBindings(namingContext2, n + 1);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error dumping bindings for " + bindingListHolder.value[i].binding_name[0].id);
            }
        }
    }

    private static void dumpStringRef(ORB oRB, Object object) {
        String string = object != null ? oRB.object_to_string(object) : "<nil>";
        System.out.println("\n" + string);
    }
}

