/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.cos.naming;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import javax.naming.AuthenticationException;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.omg.CORBA.Any;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import weblogic.corba.cos.naming.BindingIteratorImpl;
import weblogic.corba.cos.naming.NamingContextAnyHelper;
import weblogic.corba.cos.naming.NamingContextAnyPackage.CannotProceed;
import weblogic.corba.cos.naming.NamingContextAnyPackage.NotFound;
import weblogic.corba.cos.naming.NamingContextAnyPackage.TypeNotSupported;
import weblogic.corba.cos.naming.NamingContextAnyPackage.WNameComponent;
import weblogic.corba.cos.naming._NamingContextAnyImplBase;
import weblogic.corba.cos.transactions.TransactionFactoryImpl;
import weblogic.corba.idl.AnyImpl;
import weblogic.corba.idl.ObjectImpl;
import weblogic.corba.j2ee.naming.Utils;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPReplacer;
import weblogic.iiop.IOR;
import weblogic.iiop.spi.IORDelegate;
import weblogic.rjvm.JVMID;
import weblogic.rmi.internal.InitialReferenceConstants;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class NamingContextImpl
extends _NamingContextAnyImplBase
implements InitialReferenceConstants {
    public static final String TYPE_ID = NamingContextAnyHelper.id();
    private static final boolean DEBUG = false;
    private Context ctx;
    private static final DebugCategory debugNaming = Debug.getCategory((String)"weblogic.iiop.naming");
    private static final DebugLogger debugIIOPNaming = DebugLogger.getDebugLogger((String)"DebugIIOPNaming");

    protected static void p(String string) {
        System.err.println("<NamingContextImpl> " + string);
    }

    public static IOR getBootstrapIOR(JVMID jVMID) {
        return new IOR(TYPE_ID, 8);
    }

    protected NamingContextImpl() {
    }

    private NamingContextImpl(Context context) {
        this.ctx = context;
    }

    public IOR getIOR() throws IOException {
        return ((IORDelegate)this._get_delegate()).getIOR();
    }

    private Context getContext() throws NamingException {
        if (this.ctx == null) {
            this.ctx = new InitialContext();
        }
        return this.ctx;
    }

    public void bind(NameComponent[] nameComponentArray, Object object) throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed, InvalidName, AlreadyBound {
        String string = Utils.nameComponentToString(nameComponentArray);
        try {
            if (debugNaming.isEnabled() || debugIIOPNaming.isDebugEnabled()) {
                IIOPLogger.logDebugNaming((String)("bind(" + string + ") from " + this.getContext()));
            }
            this.getContext().bind(string, IIOPReplacer.getReplacer().resolveObject((java.lang.Object)object));
            return;
        }
        catch (IOException iOException) {
            this.throwNamingBindException(iOException, nameComponentArray);
        }
        catch (NamingException namingException) {
            this.throwNamingBindException(namingException, nameComponentArray);
        }
    }

    public void bind_context(NameComponent[] nameComponentArray, NamingContext namingContext) throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed, InvalidName, AlreadyBound {
        this.bind(nameComponentArray, (Object)namingContext);
    }

    public void rebind(NameComponent[] nameComponentArray, Object object) throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed, InvalidName {
        String string = Utils.nameComponentToString(nameComponentArray);
        try {
            if (debugNaming.isEnabled() || debugIIOPNaming.isDebugEnabled()) {
                IIOPLogger.logDebugNaming((String)("rebind(" + string + ") from " + this.getContext()));
            }
            this.getContext().rebind(string, IIOPReplacer.getReplacer().resolveObject((java.lang.Object)object));
            return;
        }
        catch (IOException iOException) {
            this.throwNamingException((Exception)iOException, nameComponentArray);
        }
        catch (NamingException namingException) {
            this.throwNamingException((Exception)namingException, nameComponentArray);
        }
    }

    public void rebind_context(NameComponent[] nameComponentArray, NamingContext namingContext) throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed, InvalidName {
        this.rebind(nameComponentArray, (Object)namingContext);
    }

    public Object resolve(NameComponent[] nameComponentArray) throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed, InvalidName {
        String string = Utils.nameComponentToString(nameComponentArray);
        java.lang.Object object = null;
        try {
            if (debugNaming.isEnabled() || debugIIOPNaming.isDebugEnabled()) {
                IIOPLogger.logDebugNaming((String)("resolve(" + string + ")"));
            }
            object = this.resolveObject(string);
        }
        catch (NamingException namingException) {
            this.throwNamingException((Exception)namingException, nameComponentArray);
        }
        if (!(object instanceof Object)) {
            try {
                return IIOPReplacer.makeInvocationHandler((IOR)IIOPReplacer.getReplacer().replaceObject(object));
            }
            catch (IOException iOException) {
                throw (org.omg.CosNaming.NamingContextPackage.CannotProceed)new org.omg.CosNaming.NamingContextPackage.CannotProceed((NamingContext)this, nameComponentArray).initCause((Throwable)iOException);
            }
            catch (ClassCastException classCastException) {
                throw (org.omg.CosNaming.NamingContextPackage.NotFound)new org.omg.CosNaming.NamingContextPackage.NotFound(NotFoundReason.not_object, nameComponentArray).initCause((Throwable)classCastException);
            }
        }
        return (Object)object;
    }

    public void unbind(NameComponent[] nameComponentArray) throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed, InvalidName {
        String string = Utils.nameComponentToString(nameComponentArray);
        if (string.equals("")) {
            return;
        }
        try {
            if (debugNaming.isEnabled() || debugIIOPNaming.isDebugEnabled()) {
                IIOPLogger.logDebugNaming((String)("unbind(" + string + ") from " + this.getContext()));
            }
            this.getContext().unbind(string);
            try {
                this.getContext().lookup(string);
                NamingContextImpl.p("error unbound name still exists");
            }
            catch (NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            return;
        }
        catch (NamingException namingException) {
            this.throwNamingException((Exception)namingException, nameComponentArray);
            return;
        }
    }

    public void list(int n, BindingListHolder bindingListHolder, BindingIteratorHolder bindingIteratorHolder) {
        try {
            NamingEnumeration<Binding> namingEnumeration = new InitialContext().listBindings(this.getContext().getNameInNamespace());
            BindingIteratorImpl.getBindings(namingEnumeration, n, bindingListHolder);
            bindingIteratorHolder.value = namingEnumeration.hasMore() ? new BindingIteratorImpl(namingEnumeration) : null;
        }
        catch (NamingException namingException) {
            this.throwUncheckedNamingException(namingException);
        }
    }

    public NamingContext new_context() {
        return null;
    }

    public NamingContext bind_new_context(NameComponent[] nameComponentArray) throws org.omg.CosNaming.NamingContextPackage.NotFound, AlreadyBound, org.omg.CosNaming.NamingContextPackage.CannotProceed, InvalidName {
        try {
            Context context = this.getContext().createSubcontext(Utils.nameComponentToString(nameComponentArray));
            return new NamingContextImpl(context);
        }
        catch (NamingException namingException) {
            this.throwNamingBindException(namingException, nameComponentArray);
            return null;
        }
    }

    public void destroy() throws NotEmpty {
        try {
            String string = this.getContext().getNameInNamespace();
            String string2 = null;
            int n = 0;
            n = string.lastIndexOf(47);
            if (n >= 0) {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            } else {
                n = string.lastIndexOf(46);
                if (n >= 0) {
                    string2 = string.substring(0, n);
                    string = string.substring(n + 1);
                } else {
                    throw new NotEmpty();
                }
            }
            ((Context)new InitialContext().lookup(string2)).destroySubcontext(string);
        }
        catch (ContextNotEmptyException contextNotEmptyException) {
            throw (NotEmpty)new NotEmpty().initCause((Throwable)contextNotEmptyException);
        }
        catch (NamingException namingException) {
            this.throwUncheckedNamingException(namingException);
        }
    }

    public void bind_any(WNameComponent[] wNameComponentArray, Any any) throws NotFound, CannotProceed, InvalidName, AlreadyBound, TypeNotSupported {
        String string = Utils.nameComponentToString(wNameComponentArray);
        try {
            if (debugNaming.isEnabled() || debugIIOPNaming.isDebugEnabled()) {
                IIOPLogger.logDebugNaming((String)("bind_any(" + string + ")"));
            }
            this.getContext().bind(string, NamingContextImpl.resolveAny(any));
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            throw (AlreadyBound)new AlreadyBound().initCause((Throwable)nameAlreadyBoundException);
        }
        catch (NamingException namingException) {
            this.throwNamingException((Exception)namingException, wNameComponentArray);
        }
        catch (IOException iOException) {
            this.throwNamingException((Exception)iOException, wNameComponentArray);
        }
    }

    public void rebind_any(WNameComponent[] wNameComponentArray, Any any) throws NotFound, CannotProceed, InvalidName, TypeNotSupported {
        String string = Utils.nameComponentToString(wNameComponentArray);
        try {
            if (debugNaming.isEnabled() || debugIIOPNaming.isDebugEnabled()) {
                IIOPLogger.logDebugNaming((String)("rebind_any(" + string + ")"));
            }
            this.getContext().rebind(string, NamingContextImpl.resolveAny(any));
        }
        catch (NamingException namingException) {
            this.throwNamingException((Exception)namingException, wNameComponentArray);
        }
        catch (IOException iOException) {
            this.throwNamingException((Exception)iOException, wNameComponentArray);
        }
    }

    public Any resolve_any(WNameComponent[] wNameComponentArray) throws NotFound, CannotProceed, InvalidName {
        AnyImpl anyImpl = new AnyImpl();
        String string = Utils.nameComponentToString(wNameComponentArray);
        if (debugNaming.isEnabled() || debugIIOPNaming.isDebugEnabled()) {
            IIOPLogger.logDebugNaming((String)("resolve_any(" + string + ")"));
        }
        try {
            java.lang.Object object = this.resolveObject(string);
            if (object instanceof Object) {
                anyImpl.insert_Object((Object)object);
            } else if (object instanceof Serializable) {
                anyImpl.insert_Value((Serializable)object);
            }
        }
        catch (NamingException namingException) {
            this.throwNamingException((Exception)namingException, wNameComponentArray);
        }
        return anyImpl;
    }

    public Any resolve_str_any(String string) throws NotFound, CannotProceed, InvalidName {
        try {
            return this.resolve_any(Utils.stringToWNameComponent(string));
        }
        catch (NamingException namingException) {
            throw (InvalidName)new InvalidName().initCause((Throwable)namingException);
        }
    }

    public String to_string(NameComponent[] nameComponentArray) throws InvalidName {
        return Utils.nameComponentToString(nameComponentArray);
    }

    public NameComponent[] to_name(String string) throws InvalidName {
        try {
            return Utils.stringToNameComponent(string);
        }
        catch (NamingException namingException) {
            throw (InvalidName)new InvalidName().initCause((Throwable)namingException);
        }
    }

    public String to_url(String string, String string2) throws InvalidName, InvalidAddress {
        return "corbaname:iiop:" + string + "#" + string2;
    }

    public Object resolve_str(String string) throws org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed, InvalidName {
        NameComponent[] nameComponentArray = null;
        try {
            nameComponentArray = Utils.stringToNameComponent(string);
            return this.resolve(nameComponentArray);
        }
        catch (NamingException namingException) {
            this.throwNamingException((Exception)namingException, nameComponentArray);
            return null;
        }
    }

    public static java.lang.Object resolveAny(Any any) throws TypeNotSupported, IOException {
        java.lang.Object object = null;
        switch (any.type().kind().value()) {
            case 29: 
            case 30: 
            case 32: {
                object = any.extract_Value();
                break;
            }
            case 14: {
                object = IIOPReplacer.getReplacer().resolveObject((java.lang.Object)any.extract_Object());
                break;
            }
            default: {
                throw new TypeNotSupported();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private java.lang.Object resolveObject(String string) throws NamingException {
        ClassLoader classLoader;
        Thread thread2;
        java.lang.Object object;
        block12: {
            if (string.equals("")) {
                return this;
            }
            object = this.getContext().lookup(string);
            thread2 = Thread.currentThread();
            classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(object.getClass().getClassLoader());
                if (!(object instanceof Proxy)) break block12;
                java.lang.Object object2 = object;
                java.lang.Object var7_7 = null;
                thread2.setContextClassLoader(classLoader);
                return object2;
            }
            catch (Throwable throwable) {
                java.lang.Object var7_9 = null;
                thread2.setContextClassLoader(classLoader);
                throw throwable;
            }
        }
        if (object instanceof Remote) {
            if (!(object instanceof Object)) {
                object = new ObjectImpl((Remote)object);
            }
        } else if (object instanceof Context) {
            object = new NamingContextImpl((Context)object);
        } else if (object instanceof UserTransaction) {
            object = TransactionFactoryImpl.getTransactionFactory();
        } else if (object instanceof TransactionManager) {
            object = TransactionFactoryImpl.getTransactionFactory();
        }
        java.lang.Object object3 = object;
        java.lang.Object var7_8 = null;
        thread2.setContextClassLoader(classLoader);
        return object3;
    }

    private void throwNamingBindException(Exception exception, NameComponent[] nameComponentArray) throws AlreadyBound, InvalidName, org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed {
        if (exception instanceof NameAlreadyBoundException) {
            if (debugNaming.isEnabled() || debugIIOPNaming.isDebugEnabled()) {
                IIOPLogger.logNamingException((Exception)exception);
            }
            throw (AlreadyBound)new AlreadyBound().initCause((Throwable)exception);
        }
        this.throwNamingException(exception, nameComponentArray);
    }

    private void throwNamingException(Exception exception, NameComponent[] nameComponentArray) throws InvalidName, org.omg.CosNaming.NamingContextPackage.NotFound, org.omg.CosNaming.NamingContextPackage.CannotProceed {
        if (debugNaming.isEnabled() || debugIIOPNaming.isDebugEnabled()) {
            IIOPLogger.logNamingException((Exception)exception);
        }
        if (exception instanceof NameNotFoundException) {
            throw (org.omg.CosNaming.NamingContextPackage.NotFound)new org.omg.CosNaming.NamingContextPackage.NotFound(NotFoundReason.missing_node, nameComponentArray).initCause((Throwable)exception);
        }
        if (exception instanceof NoPermissionException) {
            throw (NO_PERMISSION)new NO_PERMISSION(exception.getMessage()).initCause((Throwable)exception);
        }
        if (exception instanceof AuthenticationException) {
            throw (NO_PERMISSION)new NO_PERMISSION(exception.getMessage()).initCause((Throwable)exception);
        }
        if (exception instanceof IOException) {
            throw (org.omg.CosNaming.NamingContextPackage.CannotProceed)new org.omg.CosNaming.NamingContextPackage.CannotProceed((NamingContext)this, nameComponentArray).initCause((Throwable)exception);
        }
        throw (InvalidName)new InvalidName().initCause((Throwable)exception);
    }

    private void throwUncheckedNamingException(NamingException namingException) {
        if (debugNaming.isEnabled() || debugIIOPNaming.isDebugEnabled()) {
            IIOPLogger.logNamingException((Exception)namingException);
        }
        if (namingException instanceof NoPermissionException) {
            throw (NO_PERMISSION)new NO_PERMISSION(namingException.getMessage()).initCause((Throwable)namingException);
        }
        if (namingException instanceof AuthenticationException) {
            throw (NO_PERMISSION)new NO_PERMISSION(namingException.getMessage()).initCause((Throwable)namingException);
        }
        throw (UNKNOWN)new UNKNOWN(namingException.getMessage()).initCause((Throwable)namingException);
    }

    private void throwNamingException(Exception exception, WNameComponent[] wNameComponentArray) throws InvalidName, NotFound, CannotProceed {
        if (debugNaming.isEnabled() || debugIIOPNaming.isDebugEnabled()) {
            IIOPLogger.logNamingException((Exception)exception);
        }
        if (exception instanceof NameNotFoundException) {
            throw (NotFound)((java.lang.Object)new NotFound(NotFoundReason.missing_node, wNameComponentArray).initCause(exception));
        }
        if (exception instanceof NoPermissionException) {
            throw (NO_PERMISSION)new NO_PERMISSION(exception.getMessage()).initCause((Throwable)exception);
        }
        if (exception instanceof AuthenticationException) {
            throw (NO_PERMISSION)new NO_PERMISSION(exception.getMessage()).initCause((Throwable)exception);
        }
        if (exception instanceof IOException) {
            throw (CannotProceed)((java.lang.Object)new CannotProceed((NamingContext)this, wNameComponentArray).initCause(exception));
        }
        throw (InvalidName)new InvalidName().initCause((Throwable)exception);
    }
}

