/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.cos.transactions;

import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.Unavailable;
import org.omg.CosTransactions._CoordinatorImplBase;
import weblogic.corba.cos.transactions.CoordinatorImplFactory;
import weblogic.corba.cos.transactions.ForeignTransactionManager;
import weblogic.corba.cos.transactions.OTSHelper;
import weblogic.corba.cos.transactions.RecoveryCoordinatorImpl;
import weblogic.corba.cos.transactions.RecoveryCoordinatorReleaser;
import weblogic.corba.cos.transactions.ResourceImpl;
import weblogic.corba.cos.transactions.SynchronizationDispatcher;
import weblogic.iiop.IIOPLogger;
import weblogic.rmi.extensions.activation.Activatable;
import weblogic.rmi.extensions.activation.Activator;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;

public final class CoordinatorImpl
extends _CoordinatorImplBase
implements Activatable {
    protected static final boolean DEBUG = false;
    protected Xid xid;

    CoordinatorImpl(Xid xid) {
        this.xid = xid;
    }

    public Status get_parent_status() {
        return this.get_status();
    }

    public Status get_status() {
        int n;
        weblogic.transaction.Transaction transaction = this.getTx();
        if (transaction == null) {
            return Status.StatusNoTransaction;
        }
        try {
            n = transaction.getStatus();
        }
        catch (SystemException systemException) {
            throw new INVALID_TRANSACTION(systemException.getMessage());
        }
        return OTSHelper.jta2otsStatus(n);
    }

    public Status get_top_level_status() {
        return this.get_status();
    }

    public String get_transaction_name() {
        String string = "";
        weblogic.transaction.Transaction transaction = this.getTx();
        if (transaction != null) {
            string = transaction.getName();
        }
        return string;
    }

    public PropagationContext get_txcontext() throws Unavailable {
        weblogic.transaction.Transaction transaction = this.getTx();
        if (transaction == null) {
            throw new Unavailable();
        }
        try {
            return OTSHelper.exportTransaction(transaction, 1).getPropagationContext();
        }
        catch (Inactive inactive) {
            throw (Unavailable)((Object)new Unavailable().initCause((Throwable)((Object)inactive)));
        }
        catch (Throwable throwable) {
            throw new INVALID_TRANSACTION(throwable.getMessage());
        }
    }

    public int hash_top_level_tran() {
        return this.hash_transaction();
    }

    public int hash_transaction() {
        return this.xid.hashCode();
    }

    public boolean is_same_transaction(Coordinator coordinator) {
        if (coordinator instanceof CoordinatorImpl) {
            return this.xid.equals(((CoordinatorImpl)coordinator).xid);
        }
        return false;
    }

    public boolean is_ancestor_transaction(Coordinator coordinator) {
        return this.is_same_transaction(coordinator);
    }

    public boolean is_descendant_transaction(Coordinator coordinator) {
        return this.is_same_transaction(coordinator);
    }

    public boolean is_related_transaction(Coordinator coordinator) {
        return this.is_same_transaction(coordinator);
    }

    public boolean is_top_level_transaction() {
        return true;
    }

    public RecoveryCoordinator register_resource(Resource resource) throws Inactive {
        Object object;
        if (OTSHelper.isDebugEnabled()) {
            IIOPLogger.logDebugOTS((String)("register_resource(" + resource + ")"));
        }
        TransactionManager transactionManager = TxHelper.getTransactionManager();
        weblogic.transaction.Transaction transaction = this.getTx();
        if (transaction == null) {
            throw new Inactive();
        }
        if (!(resource instanceof ResourceImpl)) {
            try {
                object = ForeignTransactionManager.registerResource(resource, this.xid);
                transaction.enlistResource((XAResource)object);
                if (OTSHelper.isDebugEnabled()) {
                    IIOPLogger.logDebugOTS((String)("register_resource(" + object.toString() + "): enlisted " + object));
                }
            }
            catch (RollbackException rollbackException) {
                IIOPLogger.logOTSError((String)"register_resource() failed", (Throwable)rollbackException);
                throw new TRANSACTION_ROLLEDBACK("register_resource() failed" + rollbackException.getMessage());
            }
            catch (SystemException systemException) {
                IIOPLogger.logOTSError((String)"register_resource() failed", (Throwable)systemException);
                throw new INVALID_TRANSACTION("register_resource() failed: " + systemException.getMessage());
            }
        }
        object = (RecoveryCoordinatorImpl)RecoveryCoordinatorImpl.getRecoveryCoordinator(this.xid, resource);
        RecoveryCoordinatorReleaser.getReleaser().register((Transaction)this.getTx(), (RecoveryCoordinatorImpl)object);
        return object;
    }

    public Control create_subtransaction() throws SubtransactionsUnavailable, Inactive {
        throw new SubtransactionsUnavailable();
    }

    public void register_subtran_aware(SubtransactionAwareResource subtransactionAwareResource) throws Inactive, NotSubtransaction {
        throw new NotSubtransaction();
    }

    public void register_synchronization(Synchronization synchronization) throws Inactive, SynchronizationUnavailable {
        weblogic.transaction.Transaction transaction = this.getTx();
        if (transaction == null) {
            throw new Inactive();
        }
        try {
            transaction.registerSynchronization((javax.transaction.Synchronization)new SynchronizationDispatcher(synchronization));
        }
        catch (RollbackException rollbackException) {
            IIOPLogger.logOTSError((String)"register_synchronization() failed", (Throwable)rollbackException);
            throw new TRANSACTION_ROLLEDBACK(rollbackException.getMessage());
        }
        catch (SystemException systemException) {
            IIOPLogger.logOTSError((String)"register_synchronization() failed", (Throwable)systemException);
            throw new SynchronizationUnavailable();
        }
    }

    public void rollback_only() throws Inactive {
        weblogic.transaction.Transaction transaction = this.getTx();
        if (transaction == null) {
            throw new Inactive();
        }
        try {
            transaction.setRollbackOnly();
        }
        catch (IllegalStateException illegalStateException) {
            IIOPLogger.logOTSError((String)"rollback_only() failed", (Throwable)illegalStateException);
            throw new Inactive();
        }
        catch (SystemException systemException) {
            IIOPLogger.logOTSError((String)"rollback_only() failed", (Throwable)systemException);
            throw new INVALID_TRANSACTION(systemException.getMessage());
        }
    }

    private final weblogic.transaction.Transaction getTx() {
        weblogic.transaction.Transaction transaction = (weblogic.transaction.Transaction)TxHelper.getTransactionManager().getTransaction(this.xid);
        return transaction;
    }

    public Object getActivationID() {
        return this.xid;
    }

    public Activator getActivator() {
        return CoordinatorImplFactory.getActivator();
    }

    protected static void p(String string) {
        System.err.println("<CoordinatorImpl> " + string);
    }
}

