/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.cos.transactions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.security.AccessController;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Vote;
import weblogic.corba.cos.transactions.OTSHelper;
import weblogic.corba.utils.RemoteInfo;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPReplacer;
import weblogic.iiop.IOR;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.transaction.ServerTransactionManager;
import weblogic.transaction.Transaction;
import weblogic.transaction.TransactionLoggable;
import weblogic.transaction.TransactionLogger;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;
import weblogic.utils.AssertionError;
import weblogic.utils.collections.ConcurrentHashMap;

public final class ForeignTransactionManager
implements XAResource,
TransactionLoggable,
Serializable {
    protected static final boolean DEBUG = false;
    private String name;
    private int id;
    private int txTimeout = 0;
    private transient boolean isSynced = false;
    private transient boolean isFailed = false;
    private static final int FTM_POOL_SIZE = 1024;
    private static final ForeignTransactionManager[] ftmPool = new ForeignTransactionManager[1024];
    private static int ftmCounter = 0;
    private static String FTM_NAME;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ForeignTransactionManager registerResource(Resource resource, Xid xid) throws javax.transaction.SystemException {
        ForeignTransactionManager foreignTransactionManager = null;
        Transaction transaction = ForeignTransactionManager.getTx(xid);
        ForeignTransactionManager[] foreignTransactionManagerArray = ftmPool;
        synchronized (ftmPool) {
            ResourceMap resourceMap = (ResourceMap)transaction.getProperty("weblogic.transaction.ots.resources");
            if (resourceMap == null) {
                resourceMap = new ResourceMap();
                transaction.setProperty("weblogic.transaction.ots.resources", (Serializable)resourceMap);
            } else {
                foreignTransactionManager = (ForeignTransactionManager)resourceMap.get(resource);
                if (foreignTransactionManager != null) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return foreignTransactionManager;
                }
            }
            Integer n = (Integer)transaction.getProperty("weblogic.transaction.ots.ftmCounter");
            int n2 = n == null ? 0 : n;
            transaction.setProperty("weblogic.transaction.ots.ftmCounter", (Serializable)new Integer(n2 + 1));
            TransactionManager transactionManager = TxHelper.getTransactionManager();
            foreignTransactionManager = ftmPool[n2];
            if (foreignTransactionManager == null) {
                if (ftmCounter == 1024) {
                    throw new AssertionError("OTS Foreign TM pool exhausted");
                }
                if (n2 >= ftmCounter) {
                    ++ftmCounter;
                }
                foreignTransactionManager = ForeignTransactionManager.ftmPool[n2] = new ForeignTransactionManager(ForeignTransactionManager.getFtmName() + n2, n2);
                ((ServerTransactionManager)transactionManager).getTransactionLogger().store((TransactionLoggable)foreignTransactionManager);
                if (OTSHelper.isDebugEnabled()) {
                    IIOPLogger.logDebugOTS((String)("registerResource(" + foreignTransactionManager.getName() + "): registering with JTA"));
                }
                transactionManager.registerDynamicResource(foreignTransactionManager.getName(), (XAResource)foreignTransactionManager);
            }
            if (foreignTransactionManager.isFailed) {
                transactionManager.unregisterResource(foreignTransactionManager.getName());
                transactionManager.registerDynamicResource(foreignTransactionManager.getName(), (XAResource)foreignTransactionManager);
                foreignTransactionManager.isFailed = false;
                if (OTSHelper.isDebugEnabled()) {
                    IIOPLogger.logDebugOTS((String)("registerResource(" + foreignTransactionManager.getName() + "): re-registering with JTA"));
                }
            }
            resourceMap.put(resource, foreignTransactionManager);
            resourceMap.put(foreignTransactionManager, resource);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (OTSHelper.isDebugEnabled()) {
                IIOPLogger.logDebugOTS((String)("registerResource(" + foreignTransactionManager.getName() + "): enlisted " + foreignTransactionManager + " for " + xid));
            }
            return foreignTransactionManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getFtmName() {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        if (FTM_NAME != null) return FTM_NAME;
        Class<ForeignTransactionManager> clazz = ForeignTransactionManager.class;
        synchronized (ForeignTransactionManager.class) {
            FTM_NAME = ManagementService.getRuntimeAccess(authenticatedSubject).getServer().getName() + "_OTS_ForeignTM_";
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return FTM_NAME;
        }
    }

    public static void releaseResource(ForeignTransactionManager foreignTransactionManager) {
    }

    private ForeignTransactionManager(String string, int n) {
        this.name = string;
        this.id = n;
    }

    private void deenlist(Xid xid) {
    }

    public final String getName() {
        return this.name;
    }

    public final String toString() {
        return this.name;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        if (OTSHelper.isDebugEnabled()) {
            IIOPLogger.logDebugOTS((String)("commit(" + xid + ", " + bl + ")"));
        }
        try {
            Resource resource = this.findResource(xid);
            if (bl) {
                resource.commit_one_phase();
            } else {
                resource.commit();
            }
            ForeignTransactionManager.releaseResource(this);
        }
        catch (HeuristicMixed heuristicMixed) {
            throw (XAException)new XAException(5).initCause((Throwable)((Object)heuristicMixed));
        }
        catch (HeuristicRollback heuristicRollback) {
            throw (XAException)new XAException(6).initCause((Throwable)((Object)heuristicRollback));
        }
        catch (HeuristicHazard heuristicHazard) {
            throw (XAException)new XAException(8).initCause((Throwable)((Object)heuristicHazard));
        }
        catch (NotPrepared notPrepared) {
            throw (XAException)new XAException(6).initCause((Throwable)((Object)notPrepared));
        }
        catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
            throw (XAException)new XAException(100).initCause(tRANSACTION_ROLLEDBACK);
        }
        catch (UNKNOWN uNKNOWN) {
            if (uNKNOWN.minor >= 1111818304 && uNKNOWN.minor <= 1111818368) {
                throw (XAException)new XAException(uNKNOWN.minor - 1111818304).initCause(uNKNOWN);
            }
            throw (XAException)new XAException(-3).initCause(uNKNOWN);
        }
        catch (INVALID_TRANSACTION iNVALID_TRANSACTION) {
            throw (XAException)new XAException(-4).initCause(iNVALID_TRANSACTION);
        }
        catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
            throw new XAException(-4);
        }
        catch (SystemException systemException) {
            IIOPLogger.logOTSError((String)"commit() failed unexpectedly", (Throwable)systemException);
            this.isFailed = true;
            throw (XAException)new XAException(-3).initCause(systemException);
        }
        finally {
            this.deenlist(xid);
        }
    }

    public void end(Xid xid, int n) throws XAException {
        switch (n) {
            case 0x2000000: 
            case 0x4000000: 
            case 0x20000000: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            Resource resource = this.findResource(xid);
            resource.forget();
            ForeignTransactionManager.releaseResource(this);
        }
        catch (SystemException systemException) {
            IIOPLogger.logOTSError((String)"forget() failed unexpectedly", (Throwable)systemException);
            this.isFailed = true;
            throw (XAException)new XAException(-3).initCause(systemException);
        }
        finally {
            this.deenlist(xid);
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this.txTimeout;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        ForeignTransactionManager foreignTransactionManager;
        return xAResource instanceof ForeignTransactionManager && (foreignTransactionManager = (ForeignTransactionManager)xAResource).equals(this);
    }

    public boolean equals(Object object) {
        try {
            ForeignTransactionManager foreignTransactionManager = (ForeignTransactionManager)object;
            return foreignTransactionManager != null && this.name.equals(foreignTransactionManager.name) && this.id == foreignTransactionManager.id;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.id;
    }

    public int prepare(Xid xid) throws XAException {
        try {
            Resource resource = this.findResource(xid);
            Vote vote = resource.prepare();
            switch (vote.value()) {
                case 0: {
                    return 0;
                }
                case 2: {
                    return 3;
                }
            }
            throw new XAException(100);
        }
        catch (HeuristicMixed heuristicMixed) {
            throw (XAException)new XAException(5).initCause((Throwable)((Object)heuristicMixed));
        }
        catch (HeuristicHazard heuristicHazard) {
            throw (XAException)new XAException(8).initCause((Throwable)((Object)heuristicHazard));
        }
        catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
            throw (XAException)new XAException(100).initCause(tRANSACTION_ROLLEDBACK);
        }
        catch (INVALID_TRANSACTION iNVALID_TRANSACTION) {
            throw (XAException)new XAException(-4).initCause(iNVALID_TRANSACTION);
        }
        catch (SystemException systemException) {
            IIOPLogger.logOTSError((String)"prepare() failed unexpectedly", (Throwable)systemException);
            this.isFailed = true;
            throw (XAException)new XAException(-3).initCause(systemException);
        }
    }

    public Xid[] recover(int n) throws XAException {
        switch (n) {
            case 0x1000000: {
                return null;
            }
        }
        return null;
    }

    public void rollback(Xid xid) throws XAException {
        if (OTSHelper.isDebugEnabled()) {
            IIOPLogger.logDebugOTS((String)("rollback(" + xid + ")"));
        }
        try {
            Resource resource = this.findResource(xid);
            resource.rollback();
            ForeignTransactionManager.releaseResource(this);
        }
        catch (HeuristicMixed heuristicMixed) {
            throw (XAException)new XAException(5).initCause((Throwable)((Object)heuristicMixed));
        }
        catch (HeuristicCommit heuristicCommit) {
            throw (XAException)new XAException(7).initCause((Throwable)((Object)heuristicCommit));
        }
        catch (HeuristicHazard heuristicHazard) {
            throw (XAException)new XAException(8).initCause((Throwable)((Object)heuristicHazard));
        }
        catch (INVALID_TRANSACTION iNVALID_TRANSACTION) {
            throw (XAException)new XAException(-4).initCause(iNVALID_TRANSACTION);
        }
        catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
            throw new XAException(-4);
        }
        catch (SystemException systemException) {
            IIOPLogger.logOTSError((String)"rollback() failed unexpectedly", (Throwable)systemException);
            this.isFailed = true;
            throw (XAException)new XAException(-3).initCause(systemException);
        }
        finally {
            this.deenlist(xid);
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        this.txTimeout = n;
        return false;
    }

    public void start(Xid xid, int n) throws XAException {
        if (this.findResource(xid) == null) {
            throw new XAException(-4);
        }
    }

    private Resource findResource(Xid xid) throws XAException {
        Transaction transaction = ForeignTransactionManager.getTx(xid);
        if (transaction == null) {
            if (OTSHelper.isDebugEnabled()) {
                IIOPLogger.logDebugOTS((String)("findResource(" + xid + ") failed, no transaction"));
            }
            throw new XAException(-4);
        }
        ResourceMap resourceMap = (ResourceMap)transaction.getProperty("weblogic.transaction.ots.resources");
        Resource resource = null;
        if (resourceMap == null || (resource = (Resource)resourceMap.get(this)) == null) {
            if (OTSHelper.isDebugEnabled()) {
                IIOPLogger.logDebugOTS((String)("findResource(" + xid + ") failed because " + resourceMap == null ? "no resources are registered" : "no mapping exists for this resource"));
            }
            throw new XAException(-4);
        }
        return resource;
    }

    Resource findMissingResource(ForeignTransactionManager foreignTransactionManager, Transaction transaction) {
        LinkedList linkedList = (LinkedList)transaction.getLocalProperty("weblogic.transaction.ots.failedResources");
        if (linkedList != null) {
            ResourceMap resourceMap = (ResourceMap)transaction.getProperty("weblogic.transaction.ots.resources");
            if (resourceMap == null) {
                resourceMap = new ResourceMap();
                transaction.setProperty("weblogic.transaction.ots.resources", (Serializable)resourceMap);
            }
            Resource resource = (Resource)linkedList.removeFirst();
            resourceMap.put(foreignTransactionManager, resource);
            resourceMap.put(resource, foreignTransactionManager);
            return resource;
        }
        return null;
    }

    private static final Transaction getTx(Xid xid) {
        return (Transaction)TxHelper.getTransactionManager().getTransaction(xid);
    }

    public ForeignTransactionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(DataInput dataInput) throws IOException {
        this.name = dataInput.readUTF();
        this.txTimeout = dataInput.readInt();
        this.id = dataInput.readInt();
        ForeignTransactionManager[] foreignTransactionManagerArray = ftmPool;
        synchronized (ftmPool) {
            ForeignTransactionManager.ftmPool[this.id] = this;
            if (this.id >= ftmCounter) {
                ftmCounter = this.id + 1;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.name);
        dataOutput.writeInt(this.txTimeout);
        dataOutput.writeInt(this.id);
    }

    public synchronized void onDisk(TransactionLogger transactionLogger) {
        this.isSynced = true;
        this.notify();
    }

    private synchronized void waitForSync() {
        while (!this.isSynced) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.isSynced = false;
    }

    public void onError(TransactionLogger transactionLogger) {
    }

    public void onRecovery(TransactionLogger transactionLogger) {
        try {
            if (OTSHelper.isDebugEnabled()) {
                IIOPLogger.logDebugOTS((String)("recovering " + this));
            }
            TransactionManager transactionManager = TxHelper.getTransactionManager();
            transactionManager.registerDynamicResource(this.getName(), (XAResource)this);
        }
        catch (Exception exception) {
            ForeignTransactionManager.releaseResource(this);
        }
    }

    protected static void p(String string) {
        System.err.println("<ForeignTransactionManager> " + string);
    }

    public static class ResourceMap
    extends ConcurrentHashMap
    implements Externalizable {
        public synchronized void writeExternal(ObjectOutput objectOutput) throws IOException {
            Set set = this.entrySet();
            objectOutput.writeInt(set.size() / 2);
            for (Map.Entry entry : set) {
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (!(k instanceof ForeignTransactionManager)) continue;
                objectOutput.writeUTF(((ForeignTransactionManager)k).getName());
                objectOutput.writeObject((IOR)IIOPReplacer.getIIOPReplacer().replaceObject(v));
            }
        }

        public synchronized void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            int n = objectInput.readInt();
            for (int i = 0; i < n; ++i) {
                String string = objectInput.readUTF();
                ForeignTransactionManager foreignTransactionManager = null;
                int n2 = 0;
                if (n2 < ftmCounter && ftmPool[n2] != null && ftmPool[n2].getName().equals(string)) {
                    foreignTransactionManager = ftmPool[n2];
                }
                IOR iOR = (IOR)objectInput.readObject();
                if (foreignTransactionManager == null) continue;
                Resource resource = (Resource)IIOPReplacer.resolveObject(iOR, RemoteInfo.findRemoteInfo(Resource.class));
                this.put(foreignTransactionManager, resource);
                this.put(resource, foreignTransactionManager);
            }
        }
    }
}

