/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.cos.transactions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.omg.CORBA.Object;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.Status;
import weblogic.corba.cos.transactions.PropagationContextImpl;
import weblogic.corba.cos.transactions.ResourceImpl;
import weblogic.corba.cos.transactions.TransactionRegistrar;
import weblogic.corba.j2ee.transaction.Utils;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPReplacer;
import weblogic.iiop.IIOPService;
import weblogic.iiop.IOR;
import weblogic.transaction.InterposedTransactionManager;
import weblogic.transaction.TransactionSystemException;
import weblogic.transaction.TxHelper;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.transaction.internal.XidImpl;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class OTSHelper {
    public static final String OTS_INBOUND_CONTEXT = "weblogic.transaction.ots.inboundContext";
    public static final String OTS_OUTBOUND_CONTEXT = "weblogic.transaction.ots.outboundContext";
    public static final String OTS_MISSING_RESOURCES = "weblogic.transaction.ots.failedResources";
    private static final boolean DEBUG = false;
    private static final DebugCategory debugOTS = Debug.getCategory((String)"weblogic.iiop.ots");
    private static final DebugLogger debugIIOPOTS = DebugLogger.getDebugLogger((String)"DebugIIOPOTS");

    static final boolean isDebugEnabled() {
        return debugOTS.isEnabled() || debugIIOPOTS.isDebugEnabled();
    }

    public static Transaction importTransaction(PropagationContextImpl propagationContextImpl, int n) throws XAException {
        if (propagationContextImpl.isNull() && propagationContextImpl.isForeign() || IIOPService.txMechanism == 0) {
            if (OTSHelper.isDebugEnabled()) {
                IIOPLogger.logDebugOTS((String)"received null tx");
            }
            return null;
        }
        PropagationContext propagationContext = propagationContextImpl.getPropagationContext();
        Xid xid = propagationContextImpl.getXid();
        InterposedTransactionManager interposedTransactionManager = TxHelper.getServerInterposedTransactionManager();
        weblogic.transaction.Transaction transaction = null;
        try {
            transaction = (weblogic.transaction.Transaction)interposedTransactionManager.getTransaction(xid);
            if (transaction == null) {
                if (OTSHelper.isDebugEnabled()) {
                    IIOPLogger.logDebugOTS((String)("importing " + xid));
                }
                ResourceImpl resourceImpl = ResourceImpl.getResource(xid);
                new TransactionRegistrar(propagationContextImpl, resourceImpl);
                interposedTransactionManager.getXAResource().setTransactionTimeout(propagationContext.timeout);
                interposedTransactionManager.getXAResource().start(xid, 0);
                transaction = (weblogic.transaction.Transaction)interposedTransactionManager.getTransaction(xid);
                interposedTransactionManager.getXAResource().setTransactionTimeout(0);
                transaction.setLocalProperty(n == 0 ? OTS_INBOUND_CONTEXT : OTS_OUTBOUND_CONTEXT, (java.lang.Object)propagationContextImpl);
                if (OTSHelper.isDebugEnabled()) {
                    IIOPLogger.logDebugOTS((String)("imported " + xid + " -> " + transaction.getXid()));
                }
            } else {
                if (OTSHelper.isDebugEnabled()) {
                    IIOPLogger.logDebugOTS((String)("re-importing " + xid));
                }
                if (n == 0 && transaction.getProperty("weblogic.transaction.foreignXid") != null) {
                    interposedTransactionManager.getXAResource().start(xid, 0);
                }
                if (transaction.getLocalProperty(n == 0 ? OTS_INBOUND_CONTEXT : OTS_OUTBOUND_CONTEXT) == null) {
                    transaction.setLocalProperty(n == 0 ? OTS_INBOUND_CONTEXT : OTS_OUTBOUND_CONTEXT, (java.lang.Object)propagationContextImpl);
                }
            }
        }
        catch (XAException xAException) {
            if (xAException.errorCode == -8) {
                interposedTransactionManager.getXAResource().start(xid, 0x200000);
                transaction = (weblogic.transaction.Transaction)interposedTransactionManager.getTransaction(xid);
            }
            IIOPLogger.logOTSError((String)"couldn't import transaction", (Throwable)xAException);
        }
        return transaction;
    }

    public static void forceLocalCoordinator() {
        weblogic.transaction.Transaction transaction = TxHelper.getTransaction();
        if (transaction != null) {
            transaction.setLocalProperty("weblogic.transaction.otsTransactionExport", (java.lang.Object)"true");
        }
    }

    public static PropagationContextImpl exportTransaction(weblogic.transaction.internal.PropagationContext propagationContext, int n) throws Throwable {
        try {
            TransactionImpl transactionImpl = propagationContext.getTransaction();
            return OTSHelper.exportTransaction((weblogic.transaction.Transaction)transactionImpl, n);
        }
        catch (TransactionSystemException transactionSystemException) {
            throw new XAException(-3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PropagationContextImpl exportTransaction(weblogic.transaction.Transaction transaction, int n) throws Throwable {
        if (IIOPService.txMechanism == 0) {
            return PropagationContextImpl.NULL_CTX;
        }
        PropagationContextImpl propagationContextImpl = (PropagationContextImpl)transaction.getLocalProperty(n == 0 ? OTS_OUTBOUND_CONTEXT : OTS_INBOUND_CONTEXT);
        if (propagationContextImpl != null && OTSHelper.isDebugEnabled()) {
            IIOPLogger.logDebugOTS((String)("re-exporting " + transaction.getXID()));
        }
        if (propagationContextImpl == null) {
            propagationContextImpl = new PropagationContextImpl(transaction);
            transaction.setLocalProperty(n == 0 ? OTS_OUTBOUND_CONTEXT : OTS_INBOUND_CONTEXT, (java.lang.Object)propagationContextImpl);
            transaction.setLocalProperty("weblogic.transaction.otsTransactionExport", (java.lang.Object)"true");
        } else if (n == 1 && transaction.getProperty("weblogic.transaction.foreignXid") != null) {
            try {
                if (propagationContextImpl.waitForRegistration() != null) {
                    transaction.setRollbackOnly(propagationContextImpl.getRegistrationError());
                    throw propagationContextImpl.getRegistrationError();
                }
            }
            finally {
                if (OTSHelper.isDebugEnabled()) {
                    IIOPLogger.logDebugOTS((String)("ending " + propagationContextImpl.getXid()));
                }
                TxHelper.getServerInterposedTransactionManager().getXAResource().end(propagationContextImpl.getXid(), 0x4000000);
            }
        }
        return propagationContextImpl;
    }

    public static final Status jta2otsStatus(int n) {
        Status status;
        switch (n) {
            case 0: {
                status = Status.StatusActive;
                break;
            }
            case 1: {
                status = Status.StatusMarkedRollback;
                break;
            }
            case 2: {
                status = Status.StatusPrepared;
                break;
            }
            case 3: {
                status = Status.StatusCommitted;
                break;
            }
            case 4: {
                status = Status.StatusRolledBack;
                break;
            }
            case 6: {
                status = Status.StatusNoTransaction;
                break;
            }
            case 7: {
                status = Status.StatusPreparing;
                break;
            }
            case 8: {
                status = Status.StatusCommitting;
                break;
            }
            case 9: {
                status = Status.StatusRollingBack;
                break;
            }
            default: {
                status = Status.StatusUnknown;
            }
        }
        return status;
    }

    public static final int ots2jtaStatus(Status status) {
        return Utils.ots2jtaStatus(status);
    }

    private static final void p(String string) {
        System.err.println("<OTSHelper> " + string);
    }

    static final void writeBytes(DataOutput dataOutput, byte[] byArray) throws IOException {
        if (byArray == null) {
            dataOutput.writeInt(0);
        } else {
            dataOutput.writeInt(byArray.length);
            dataOutput.write(byArray);
        }
    }

    static final byte[] readBytes(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        return byArray;
    }

    static final void writeXid(DataOutput dataOutput, Xid xid) throws IOException {
        dataOutput.writeInt(xid.getFormatId());
        OTSHelper.writeBytes(dataOutput, xid.getGlobalTransactionId());
        OTSHelper.writeBytes(dataOutput, xid.getBranchQualifier());
    }

    static final Xid readXid(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        byte[] byArray = OTSHelper.readBytes(dataInput);
        byte[] byArray2 = OTSHelper.readBytes(dataInput);
        return new XidImpl(n, byArray, byArray2);
    }

    static final void writeObject(DataOutput dataOutput, Object object) throws IOException {
        Debug.assertion((object != null ? 1 : 0) != 0);
        IOR iOR = (IOR)IIOPReplacer.getReplacer().replaceObject((java.lang.Object)object);
        dataOutput.writeUTF(iOR.stringify());
    }

    static final Object readObject(DataInput dataInput) throws IOException {
        IOR iOR = IOR.destringify(dataInput.readUTF());
        return (Object)IIOPReplacer.getReplacer().resolveObject((java.lang.Object)iOR);
    }
}

