/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.cos.transactions;

import javax.transaction.xa.Xid;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.otid_t;
import weblogic.corba.cos.transactions.CoordinatorImpl;
import weblogic.corba.cos.transactions.OTSHelper;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.IIOPService;
import weblogic.iiop.ServiceContext;
import weblogic.transaction.Transaction;
import weblogic.transaction.TxHelper;

public class PropagationContextImpl
extends ServiceContext {
    private PropagationContext ctx;
    private Xid xid;
    private boolean registered = true;
    private Throwable registrationError;
    public static PropagationContextImpl NULL_CTX = new PropagationContextImpl();
    private static final byte[] NULL_BRANCH = new byte[]{11, 14, 10, 3};

    private PropagationContextImpl() {
        this(new otid_t(0, 0, new byte[0]));
    }

    private PropagationContextImpl(otid_t otid_t2) {
        super(0);
        TransIdentity transIdentity = new TransIdentity(null, null, otid_t2);
        this.ctx = new PropagationContext(0, transIdentity, new TransIdentity[0], null);
    }

    public PropagationContextImpl(Transaction transaction) {
        super(0);
        this.xid = transaction.getXID();
        if (OTSHelper.isDebugEnabled()) {
            IIOPLogger.logDebugOTS((String)("exporting " + transaction.getXID()));
        }
        byte[] byArray = transaction.getXID().getGlobalTransactionId();
        byte[] byArray2 = transaction.getXID().getBranchQualifier();
        if ((byArray2 == null || byArray2.length == 0) && transaction.getXID().getFormatId() == 48801) {
            byArray2 = NULL_BRANCH;
        }
        int n = byArray2 == null ? 0 : byArray2.length;
        byte[] byArray3 = new byte[byArray.length + n];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        if (n > 0) {
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        }
        otid_t otid_t2 = new otid_t(transaction.getXID().getFormatId(), n, byArray3);
        if (IIOPService.txMechanism != 0) {
            TransIdentity transIdentity = new TransIdentity(new CoordinatorImpl(transaction.getXID()), null, otid_t2);
            Integer n2 = (Integer)transaction.getProperty("weblogic.transaction.timeoutSeconds");
            this.ctx = new PropagationContext(n2 == null ? 0 : n2, transIdentity, new TransIdentity[0], null);
        } else {
            this.ctx = new PropagationContext(0, new TransIdentity(null, null, otid_t2), new TransIdentity[0], null);
        }
    }

    public PropagationContextImpl(PropagationContext propagationContext) {
        super(0);
        this.ctx = propagationContext;
    }

    public final PropagationContext getPropagationContext() {
        return this.ctx;
    }

    public final Xid getXid() {
        return this.xid;
    }

    public final boolean isNull() {
        return this.ctx == null || this.ctx.current.coord == null && this.ctx.current.term == null;
    }

    public final PropagationContextImpl getNullContext() {
        if (this.ctx == null || this.ctx.current.otid == null || this.ctx.current.otid.tid.length == 0) {
            return NULL_CTX;
        }
        return new PropagationContextImpl(this.ctx.current.otid);
    }

    public final boolean isForeign() {
        return this.ctx == null || this.ctx.current.otid.formatID != 48801;
    }

    public PropagationContextImpl(IIOPInputStream iIOPInputStream) {
        super(0);
        this.readEncapsulatedContext(iIOPInputStream);
    }

    public final synchronized Throwable waitForRegistration() {
        while (!this.registered) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.registrationError;
    }

    public final synchronized void notifyRegistration() {
        this.registrationError = null;
        this.registered = true;
        this.notify();
    }

    public final synchronized void notifyRegistration(Throwable throwable) {
        this.registrationError = throwable;
        this.registered = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requiresRegistration() {
        if (!this.registered) {
            return;
        }
        PropagationContextImpl propagationContextImpl = this;
        synchronized (propagationContextImpl) {
            this.registered = false;
        }
    }

    final Throwable getRegistrationError() {
        return this.registrationError;
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        this.writeEncapsulatedContext(iIOPOutputStream);
    }

    protected void writeEncapsulation(IIOPOutputStream iIOPOutputStream) {
        PropagationContextHelper.write((OutputStream)iIOPOutputStream, this.ctx);
    }

    protected void readEncapsulation(IIOPInputStream iIOPInputStream) {
        this.ctx = PropagationContextHelper.read((InputStream)iIOPInputStream);
        if (this.isNull() && this.isForeign()) {
            return;
        }
        int n = this.ctx.current.otid.tid.length - this.ctx.current.otid.bqual_length;
        byte[] byArray = new byte[n];
        System.arraycopy(this.ctx.current.otid.tid, 0, byArray, 0, n);
        if (this.ctx.current.otid.bqual_length > 0) {
            byte[] byArray2 = new byte[this.ctx.current.otid.bqual_length];
            System.arraycopy(this.ctx.current.otid.tid, n, byArray2, 0, this.ctx.current.otid.bqual_length);
            this.xid = byArray2.length == NULL_BRANCH.length && this.ctx.current.otid.formatID == 48801 && byArray2[0] == NULL_BRANCH[0] && byArray2[1] == NULL_BRANCH[1] && byArray2[2] == NULL_BRANCH[2] && byArray2[3] == NULL_BRANCH[3] ? TxHelper.createXid(this.ctx.current.otid.formatID, byArray, null) : TxHelper.createXid(this.ctx.current.otid.formatID, byArray, byArray2);
        } else {
            this.xid = TxHelper.createXid(this.ctx.current.otid.formatID, byArray, null);
        }
    }

    public String toString() {
        return "PropagationContextImpl: context (" + this.ctx + ")";
    }

    protected static final void p(String string) {
        System.err.println("<PropagationContextImpl> " + string);
    }
}

