/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.cos.transactions;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import javax.rmi.PortableRemoteObject;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import weblogic.corba.cos.transactions.OTSHelper;
import weblogic.corba.cos.transactions.RecoveryFactory;
import weblogic.corba.idl.ObjectImpl;
import weblogic.iiop.IIOPLogger;
import weblogic.rmi.extensions.activation.Activatable;
import weblogic.rmi.extensions.activation.Activator;
import weblogic.transaction.Transaction;
import weblogic.transaction.TxHelper;
import weblogic.utils.collections.ConcurrentHashMap;

public final class RecoveryCoordinatorImpl
extends ObjectImpl
implements RecoveryCoordinator,
Activatable {
    private RecoveryActivationID aid;
    private static boolean throwONE = Boolean.getBoolean("weblogic.iiop.recoverycoordinator.ThrowONE");

    public RecoveryCoordinatorImpl(Xid xid, Resource resource) {
        this.aid = new RecoveryActivationID(xid, resource);
    }

    RecoveryCoordinatorImpl(Object object) {
        this.aid = (RecoveryActivationID)object;
    }

    public static RecoveryCoordinator getRecoveryCoordinator(Xid xid, Resource resource) {
        return (RecoveryCoordinator)((RecoveryFactory)RecoveryFactory.getActivator()).activate(new RecoveryActivationID(xid, resource));
    }

    void release() {
        ((RecoveryFactory)RecoveryFactory.getActivator()).deactivate(this);
    }

    public Object getActivationID() {
        return this.aid;
    }

    public Activator getActivator() {
        return RecoveryFactory.getActivator();
    }

    public Status replay_completion(Resource resource) throws NotPrepared {
        Transaction transaction = this.getTx();
        if (transaction == null) {
            if (throwONE) {
                throw new OBJECT_NOT_EXIST("no transaction was found");
            }
            return Status.StatusRolledBack;
        }
        try {
            LinkedList linkedList;
            ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)transaction.getLocalProperty("weblogic.transaction.ots.resources");
            if (concurrentHashMap == null || concurrentHashMap.get((Object)resource) == null) {
                linkedList = (LinkedList)transaction.getLocalProperty("weblogic.transaction.ots.failedResources");
                if (linkedList == null) {
                    linkedList = new LinkedList();
                    transaction.setLocalProperty("weblogic.transaction.ots.failedResources", linkedList);
                }
                linkedList.add(resource);
            }
            linkedList = OTSHelper.jta2otsStatus(transaction.getStatus());
            switch (((Status)((Object)linkedList)).value()) {
                case 0: 
                case 7: {
                    throw new NotPrepared();
                }
            }
            return linkedList;
        }
        catch (SystemException systemException) {
            IIOPLogger.logOTSError((String)"replay_completion() failed unexpectedly", (Throwable)systemException);
            throw new INVALID_TRANSACTION(systemException.getMessage());
        }
    }

    private final Transaction getTx() {
        return (Transaction)TxHelper.getTransactionManager().getTransaction(this.aid.xid);
    }

    private static class RecoveryActivationID
    implements Externalizable {
        private static final long serialVersionUID = -3321373552041680942L;
        private Xid xid;
        private Resource resource;

        public RecoveryActivationID() {
        }

        private RecoveryActivationID(Xid xid, Resource resource) {
            this.xid = xid;
            this.resource = resource;
        }

        public int hashCode() {
            return this.resource.hashCode() ^ (this.xid == null ? 1 : this.xid.hashCode());
        }

        public boolean equals(Object object) {
            try {
                if (object == null) {
                    return false;
                }
                if (this.xid == null && ((RecoveryActivationID)object).xid == null || ((RecoveryActivationID)object).xid.equals(this.xid)) {
                    return ((RecoveryActivationID)object).resource.equals(this.resource);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return false;
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.xid = OTSHelper.readXid(objectInput);
            Object object = objectInput.readObject();
            this.resource = (Resource)PortableRemoteObject.narrow((Object)object, Resource.class);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            OTSHelper.writeXid(objectOutput, this.xid);
            objectOutput.writeObject(this.resource);
        }
    }
}

