/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.cos.transactions;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import weblogic.corba.cos.transactions.RecoveryCoordinatorImpl;
import weblogic.iiop.IIOPLogger;
import weblogic.time.common.Schedulable;
import weblogic.time.common.TimeTriggerException;
import weblogic.time.common.Triggerable;
import weblogic.time.common.internal.ScheduledTrigger;
import weblogic.work.WorkManagerFactory;

public final class RecoveryCoordinatorReleaser {
    private static RecoveryCoordinatorReleaser singleton;
    private RecoveryCoordinatorReleaseTrigger trigger;
    private Hashtable listeners = new Hashtable();

    public static RecoveryCoordinatorReleaser getReleaser() {
        return singleton == null ? RecoveryCoordinatorReleaser.createSingleton() : singleton;
    }

    private RecoveryCoordinatorReleaser() {
    }

    private static synchronized RecoveryCoordinatorReleaser createSingleton() {
        if (singleton == null) {
            singleton = new RecoveryCoordinatorReleaser();
        }
        return singleton;
    }

    public void register(Transaction transaction, RecoveryCoordinatorImpl recoveryCoordinatorImpl) {
        TxListener txListener;
        if (transaction == null) {
            return;
        }
        if (this.trigger == null) {
            try {
                this.trigger = new RecoveryCoordinatorReleaseTrigger();
            }
            catch (TimeTriggerException timeTriggerException) {
                IIOPLogger.logOTSError((String)"Could not schedule RecoveryCoordinator release trigger", (Throwable)((Object)timeTriggerException));
                return;
            }
        }
        if ((txListener = (TxListener)this.listeners.get(transaction)) == null) {
            txListener = new TxListener(transaction);
            try {
                transaction.registerSynchronization((Synchronization)txListener);
                this.listeners.put(transaction, txListener);
            }
            catch (RollbackException rollbackException) {
                IIOPLogger.logOTSError((String)"Could not register synchronization", (Throwable)rollbackException);
            }
            catch (SystemException systemException) {
                IIOPLogger.logOTSError((String)"Could not register synchronization", (Throwable)systemException);
            }
        }
        txListener.add(recoveryCoordinatorImpl);
    }

    private static class RecoveryCoordinatorReleaseTrigger
    implements Schedulable,
    Triggerable {
        private static final long RC_DEFUALT_RELEASE_SEC = 90000L;
        private static final long DEFAULT_TRIGGER_INTERVAL = 30000L;
        private long releaseSec = 90000L;
        private long triggerInterval = 30000L;
        private List[] array;
        private int currentIndex = 0;

        public RecoveryCoordinatorReleaseTrigger() throws TimeTriggerException {
            int n = this.releaseSec % this.triggerInterval == 0L ? 0 : 1;
            int n2 = (int)(this.releaseSec / this.triggerInterval) + n + 1;
            this.array = new LinkedList[n2];
            ScheduledTrigger scheduledTrigger = new ScheduledTrigger((Schedulable)this, (Triggerable)this, WorkManagerFactory.getInstance().getSystem());
            scheduledTrigger.schedule();
        }

        public synchronized void add(List list) {
            LinkedList linkedList = this.array[this.currentIndex];
            if (linkedList == null) {
                linkedList = this.array[this.currentIndex] = new LinkedList();
            }
            linkedList.addAll(list);
        }

        public long schedule(long l) {
            return l + this.triggerInterval;
        }

        public synchronized void trigger(Schedulable schedulable) {
            this.currentIndex = (this.currentIndex + 1) % this.array.length;
            List list = this.array[this.currentIndex];
            if (list != null) {
                for (RecoveryCoordinatorImpl recoveryCoordinatorImpl : list) {
                    recoveryCoordinatorImpl.release();
                }
                this.array[this.currentIndex] = null;
            }
        }
    }

    private class TxListener
    implements Synchronization {
        private List recoverys = new LinkedList();
        private Transaction tx;

        TxListener(Transaction transaction) {
            this.tx = transaction;
        }

        public void add(RecoveryCoordinatorImpl recoveryCoordinatorImpl) {
            this.recoverys.add(recoveryCoordinatorImpl);
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int n) {
            RecoveryCoordinatorReleaser.this.trigger.add(this.recoverys);
            RecoveryCoordinatorReleaser.this.listeners.remove(this.tx);
        }
    }
}

