/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.cos.transactions;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Status;
import weblogic.corba.cos.transactions.OTSHelper;
import weblogic.corba.cos.transactions.ResourceImpl;
import weblogic.iiop.IIOPLogger;
import weblogic.t3.srvr.T3Srvr;
import weblogic.transaction.Transaction;
import weblogic.transaction.TxHelper;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

public final class RecoveryRegistrar
extends WorkAdapter {
    private static final boolean DEBUG = false;
    private ResourceImpl res;
    private static final int MAX_RETRIES = 5;
    private int retries = 0;

    RecoveryRegistrar(ResourceImpl resourceImpl) {
        this.res = resourceImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (T3Srvr.getT3Srvr().getRunState() != 2) {
            WorkManagerFactory.getInstance().getSystem().schedule((Runnable)((Object)this));
            return;
        }
        ResourceImpl resourceImpl = this.res;
        synchronized (resourceImpl) {
            ResourceImpl.ResourceActivationID resourceActivationID = (ResourceImpl.ResourceActivationID)this.res.getActivationID();
            if (OTSHelper.isDebugEnabled()) {
                IIOPLogger.logDebugOTS((String)("recovering tx: " + resourceActivationID.getXid()));
            }
            Transaction transaction = null;
            try {
                transaction = (Transaction)TxHelper.getTransactionManager().getTransaction(resourceActivationID.getXid());
                if (transaction == null) {
                    ResourceImpl.releaseResource(this.res);
                    return;
                }
                switch (transaction.getStatus()) {
                    case 3: 
                    case 8: {
                        ResourceImpl.releaseLogRecord(this.res);
                        transaction.setLocalProperty("weblogic.transaction.otsReplayCompletionExecuteRequest", null);
                        return;
                    }
                    case 6: {
                        ResourceImpl.releaseResource(this.res);
                        transaction.setLocalProperty("weblogic.transaction.otsReplayCompletionExecuteRequest", null);
                        return;
                    }
                }
                Status status = resourceActivationID.getRecoveryCoordinator().replay_completion(this.res);
                if (OTSHelper.isDebugEnabled()) {
                    IIOPLogger.logDebugOTS((String)("tx: " + resourceActivationID.getXid() + " status is: " + status.value()));
                }
                switch (status.value()) {
                    case 2: 
                    case 7: {
                        break;
                    }
                    case 3: 
                    case 8: {
                        RecoveryRegistrar.getTMResource().commit(resourceActivationID.getXid(), false);
                        ResourceImpl.releaseResource(this.res);
                        break;
                    }
                    default: {
                        try {
                            RecoveryRegistrar.getTMResource().rollback(resourceActivationID.getXid());
                            break;
                        }
                        catch (XAException xAException) {
                            if (xAException.errorCode != -4) {
                                throw xAException;
                            }
                            break;
                        }
                        finally {
                            ResourceImpl.releaseResource(this.res);
                        }
                    }
                }
            }
            catch (NotPrepared notPrepared) {
                ResourceImpl.releaseResource(this.res);
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                if (OTSHelper.isDebugEnabled()) {
                    IIOPLogger.logDebugOTS((String)"couldn't contact coordinator, retrying");
                }
                transaction.setLocalProperty("weblogic.transaction.otsReplayCompletionExecuteRequest", (Object)this);
                transaction.setLocalProperty("weblogic.transaction.otsLogRecord", (Object)this.res);
            }
            catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                if (OTSHelper.isDebugEnabled()) {
                    IIOPLogger.logDebugOTS((String)"coordinator hasn't exported the RecoveryCoordinator, retrying");
                }
                transaction.setLocalProperty("weblogic.transaction.otsReplayCompletionExecuteRequest", (Object)this);
                transaction.setLocalProperty("weblogic.transaction.otsLogRecord", (Object)this.res);
                try {
                    RecoveryRegistrar.getTMResource().rollback(resourceActivationID.getXid());
                }
                catch (XAException xAException) {
                    if (xAException.errorCode != -4) {
                        IIOPLogger.logOTSError((String)("rollback of " + this.res + " failed"), null);
                        try {
                            ResourceImpl.releaseResource(this.res);
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    ResourceImpl.releaseResource(this.res);
                }
            }
            catch (Exception exception) {
                IIOPLogger.logOTSError((String)("recovery of " + this.res + " failed"), (Throwable)exception);
                try {
                    ResourceImpl.releaseResource(this.res);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    private static final XAResource getTMResource() {
        return TxHelper.getServerInterposedTransactionManager().getXAResource();
    }

    private static final void p(String string) {
        System.err.println("<RecoveryRegistrar> " + string);
    }
}

