/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.cos.transactions;

import java.util.HashMap;
import weblogic.corba.cos.transactions.OTSHelper;
import weblogic.corba.cos.transactions.ResourceImpl;
import weblogic.iiop.IIOPLogger;
import weblogic.rmi.extensions.activation.Activatable;
import weblogic.rmi.extensions.activation.Activator;

public class ResourceFactory
implements Activator {
    private static final HashMap map = new HashMap();
    private static final Activator activator = new ResourceFactory();

    public static final Activator getActivator() {
        return activator;
    }

    private ResourceFactory() {
    }

    public synchronized Activatable activate(Object object) {
        if (map.get(object) == null) {
            ResourceImpl resourceImpl = ResourceImpl.getResource(((ResourceImpl.ResourceActivationID)object).getXid());
            if (OTSHelper.isDebugEnabled()) {
                IIOPLogger.logDebugOTS((String)("activating new resource " + resourceImpl));
            }
            return resourceImpl;
        }
        return (Activatable)map.get(object);
    }

    synchronized void activateResource(ResourceImpl resourceImpl) {
        if (OTSHelper.isDebugEnabled()) {
            IIOPLogger.logDebugOTS((String)("activating resource " + resourceImpl));
        }
        map.put(resourceImpl.getActivationID(), resourceImpl);
    }

    public synchronized void deactivate(Activatable activatable) {
    }

    public synchronized void release(Activatable activatable) {
        if (OTSHelper.isDebugEnabled()) {
            IIOPLogger.logDebugOTS((String)("released resource " + activatable));
        }
        map.remove(activatable.getActivationID());
    }
}

