/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.cos.transactions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Vote;
import weblogic.corba.cos.transactions.OTSHelper;
import weblogic.corba.cos.transactions.RecoveryRegistrar;
import weblogic.corba.cos.transactions.ResourceFactory;
import weblogic.corba.idl.ObjectImpl;
import weblogic.iiop.IIOPLogger;
import weblogic.rmi.extensions.activation.Activatable;
import weblogic.rmi.extensions.activation.Activator;
import weblogic.transaction.ServerTransactionManager;
import weblogic.transaction.Transaction;
import weblogic.transaction.TransactionLoggable;
import weblogic.transaction.TransactionLogger;
import weblogic.transaction.TxHelper;
import weblogic.utils.Debug;
import weblogic.utils.collections.Pool;
import weblogic.utils.collections.StackPool;
import weblogic.work.WorkManagerFactory;

public final class ResourceImpl
extends ObjectImpl
implements Resource,
TransactionLoggable,
Activatable {
    private ResourceActivationID aid;
    private static final int RESOURCE_POOL_SIZE = 1024;
    private static final Pool resourcePool = new StackPool(1024);
    private static final boolean DEBUG = false;
    private boolean isSynced = false;

    static ResourceImpl getResource(Xid xid) {
        Debug.assertion((xid != null ? 1 : 0) != 0);
        ResourceImpl resourceImpl = (ResourceImpl)resourcePool.remove();
        if (resourceImpl == null) {
            resourceImpl = new ResourceImpl(xid);
        } else {
            resourceImpl.aid.xid = xid;
            resourceImpl.aid.recoveryCoordinator = null;
        }
        ((ResourceFactory)ResourceFactory.getActivator()).activateResource(resourceImpl);
        return resourceImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseResource(ResourceImpl resourceImpl) {
        ResourceImpl resourceImpl2 = resourceImpl;
        synchronized (resourceImpl2) {
            if (resourceImpl.aid.xid == null) {
                return;
            }
            ((ServerTransactionManager)TxHelper.getTransactionManager()).getTransactionLogger().release((TransactionLoggable)resourceImpl);
            ((ResourceFactory)ResourceFactory.getActivator()).release(resourceImpl);
            resourceImpl.aid.xid = null;
            resourceImpl.aid.recoveryCoordinator = null;
            resourcePool.add((Object)resourceImpl);
        }
    }

    public static void releaseLogRecord(ResourceImpl resourceImpl) {
        ((ServerTransactionManager)TxHelper.getTransactionManager()).getTransactionLogger().release((TransactionLoggable)resourceImpl);
    }

    private ResourceImpl(Xid xid) {
        this.aid = new ResourceActivationID(xid, null);
    }

    public Object getActivationID() {
        return this.aid;
    }

    void registerForRecovery(RecoveryCoordinator recoveryCoordinator) {
        this.aid.recoveryCoordinator = recoveryCoordinator;
    }

    public synchronized void commit() throws NotPrepared, HeuristicRollback, HeuristicMixed, HeuristicHazard {
        try {
            ServerTransactionManager serverTransactionManager = (ServerTransactionManager)TxHelper.getTransactionManager();
            Transaction transaction = (Transaction)serverTransactionManager.getTransaction(this.aid.xid);
            if (transaction == null) {
                throw new XAException(-4);
            }
            ResourceImpl.getTMResource().commit(this.aid.xid, false);
            ResourceImpl.releaseResource(this);
        }
        catch (XAException xAException) {
            switch (xAException.errorCode) {
                case 5: {
                    ResourceImpl.releaseResource(this);
                    throw new HeuristicMixed();
                }
                case 6: {
                    ResourceImpl.releaseResource(this);
                    throw new HeuristicRollback();
                }
                case 8: {
                    ResourceImpl.releaseResource(this);
                    throw new HeuristicHazard();
                }
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    ResourceImpl.releaseResource(this);
                    throw new TRANSACTION_ROLLEDBACK(xAException.getMessage());
                }
                case -4: {
                    ResourceImpl.releaseResource(this);
                    throw new INVALID_TRANSACTION(xAException.getMessage());
                }
            }
            IIOPLogger.logOTSError((String)"local commit() failed unexpectedly", (Throwable)xAException);
            throw new UNKNOWN(xAException.getMessage(), 1111818304 + xAException.errorCode, CompletionStatus.COMPLETED_NO);
        }
    }

    public synchronized void commit_one_phase() throws HeuristicHazard {
        try {
            ServerTransactionManager serverTransactionManager = (ServerTransactionManager)TxHelper.getTransactionManager();
            Transaction transaction = (Transaction)serverTransactionManager.getTransaction(this.aid.xid);
            if (transaction == null) {
                throw new XAException(-4);
            }
            serverTransactionManager.getTransactionLogger().store((TransactionLoggable)this);
            this.waitForSync();
            transaction.setLocalProperty("weblogic.transaction.otsLogRecord", (Object)this);
            ResourceImpl.getTMResource().commit(this.aid.xid, true);
            ResourceImpl.releaseResource(this);
        }
        catch (XAException xAException) {
            switch (xAException.errorCode) {
                case 8: {
                    ResourceImpl.releaseResource(this);
                    throw new HeuristicHazard();
                }
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: {
                    ResourceImpl.releaseResource(this);
                    throw new TRANSACTION_ROLLEDBACK(xAException.getMessage());
                }
                case -4: {
                    ResourceImpl.releaseResource(this);
                    throw new INVALID_TRANSACTION(xAException.getMessage());
                }
            }
            throw new UNKNOWN(xAException.getMessage(), 1111818304 + xAException.errorCode, CompletionStatus.COMPLETED_NO);
        }
    }

    public void forget() {
        try {
            ResourceImpl.getTMResource().forget(this.aid.xid);
        }
        catch (XAException xAException) {
            throw new UNKNOWN(xAException.getMessage(), 1111818304 + xAException.errorCode, CompletionStatus.COMPLETED_MAYBE);
        }
        finally {
            ResourceImpl.releaseResource(this);
        }
    }

    public Vote prepare() throws HeuristicMixed, HeuristicHazard {
        try {
            ServerTransactionManager serverTransactionManager = (ServerTransactionManager)TxHelper.getTransactionManager();
            Transaction transaction = (Transaction)serverTransactionManager.getTransaction(this.aid.xid);
            if (transaction == null) {
                ResourceImpl.releaseResource(this);
                throw new XAException(-4);
            }
            serverTransactionManager.getTransactionLogger().store((TransactionLoggable)this);
            transaction.setLocalProperty("weblogic.transaction.otsReplayCompletionExecuteRequest", (Object)new RecoveryRegistrar(this));
            transaction.setLocalProperty("weblogic.transaction.otsLogRecord", (Object)this);
            this.waitForSync();
            int n = ResourceImpl.getTMResource().prepare(this.aid.xid);
            switch (n) {
                case 0: {
                    return Vote.VoteCommit;
                }
                case 3: {
                    return Vote.VoteReadOnly;
                }
            }
        }
        catch (XAException xAException) {
            switch (xAException.errorCode) {
                case 5: {
                    throw new HeuristicMixed();
                }
                case 8: {
                    throw new HeuristicHazard();
                }
            }
        }
        return Vote.VoteRollback;
    }

    public synchronized void rollback() throws HeuristicCommit, HeuristicMixed, HeuristicHazard {
        try {
            ServerTransactionManager serverTransactionManager = (ServerTransactionManager)TxHelper.getTransactionManager();
            Transaction transaction = (Transaction)serverTransactionManager.getTransaction(this.aid.xid);
            if (transaction == null) {
                throw new XAException(-4);
            }
            ResourceImpl.getTMResource().rollback(this.aid.xid);
        }
        catch (XAException xAException) {
            switch (xAException.errorCode) {
                case 5: {
                    throw new HeuristicMixed();
                }
                case 7: {
                    throw new HeuristicCommit();
                }
                case 8: {
                    throw new HeuristicHazard();
                }
            }
            IIOPLogger.logOTSError((String)"local rollback() failed unexpectedly", (Throwable)xAException);
            throw new INVALID_TRANSACTION(xAException.getMessage());
        }
        finally {
            ResourceImpl.releaseResource(this);
        }
    }

    private static final XAResource getTMResource() {
        return TxHelper.getServerInterposedTransactionManager().getXAResource();
    }

    public ResourceImpl() {
        this.aid = new ResourceActivationID();
    }

    public Activator getActivator() {
        return ResourceFactory.getActivator();
    }

    public void readExternal(DataInput dataInput) throws IOException {
        this.aid.xid = OTSHelper.readXid(dataInput);
        this.aid.recoveryCoordinator = (RecoveryCoordinator)OTSHelper.readObject(dataInput);
    }

    public void writeExternal(DataOutput dataOutput) throws IOException {
        OTSHelper.writeXid(dataOutput, this.aid.xid);
        OTSHelper.writeObject(dataOutput, this.aid.recoveryCoordinator);
    }

    public synchronized void onDisk(TransactionLogger transactionLogger) {
        this.isSynced = true;
        this.notify();
    }

    private synchronized void waitForSync() {
        while (!this.isSynced) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.isSynced = false;
    }

    public void onError(TransactionLogger transactionLogger) {
    }

    public void onRecovery(TransactionLogger transactionLogger) {
        if (OTSHelper.isDebugEnabled()) {
            IIOPLogger.logDebugOTS((String)("recovering " + this));
        }
        Debug.assertion((this.aid.recoveryCoordinator != null ? 1 : 0) != 0);
        ((ResourceFactory)ResourceFactory.getActivator()).activateResource(this);
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)((Object)new RecoveryRegistrar(this)));
    }

    protected static void p(String string) {
        System.err.println("<ResourceImpl> " + string);
    }

    static class ResourceActivationID
    implements Externalizable {
        private static final long serialVersionUID = -7221498218539947141L;
        private Xid xid;
        private RecoveryCoordinator recoveryCoordinator;

        public ResourceActivationID() {
        }

        private ResourceActivationID(Xid xid, RecoveryCoordinator recoveryCoordinator) {
            this.xid = xid;
            this.recoveryCoordinator = recoveryCoordinator;
        }

        final RecoveryCoordinator getRecoveryCoordinator() {
            return this.recoveryCoordinator;
        }

        final Xid getXid() {
            return this.xid;
        }

        public boolean equals(Object object) {
            try {
                if (object == null) {
                    return false;
                }
                if (this.xid == null && ((ResourceActivationID)object).xid == null) {
                    return true;
                }
                if (((ResourceActivationID)object).xid.equals(this.xid)) {
                    return true;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return false;
        }

        public int hashCode() {
            if (this.xid == null) {
                return 1;
            }
            return this.xid.hashCode();
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.xid = OTSHelper.readXid(objectInput);
            this.recoveryCoordinator = (RecoveryCoordinator)objectInput.readObject();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            OTSHelper.writeXid(objectOutput, this.xid);
            objectOutput.writeObject(this.recoveryCoordinator);
        }
    }
}

