/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.cos.transactions;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions._TerminatorImplBase;
import weblogic.iiop.Connection;
import weblogic.rmi.internal.OIDManager;
import weblogic.transaction.Transaction;
import weblogic.transaction.TxHelper;

public final class TerminatorImpl
extends _TerminatorImplBase {
    private Connection connection;
    private Xid xid;
    private Control control;
    private static final long serialVersionUID = 4068654570203577465L;

    TerminatorImpl(Xid xid, Connection connection, Control control) {
        this.xid = xid;
        this.connection = connection;
        this.control = control;
    }

    public void commit(boolean bl) throws HeuristicMixed, HeuristicHazard {
        Transaction transaction;
        if (this.connection != null) {
            this.connection.setTxContext(null);
        }
        if ((transaction = (Transaction)TxHelper.getTransactionManager().getTransaction(this.xid)) == null) {
            this.release();
            throw new INVALID_TRANSACTION("No transaction");
        }
        try {
            transaction.commit();
        }
        catch (HeuristicMixedException heuristicMixedException) {
            if (bl) {
                throw new HeuristicMixed();
            }
        }
        catch (HeuristicRollbackException heuristicRollbackException) {
            if (bl) {
                throw new HeuristicHazard();
            }
        }
        catch (RollbackException rollbackException) {
            throw new TRANSACTION_ROLLEDBACK(rollbackException.getMessage());
        }
        catch (SecurityException securityException) {
            throw new INVALID_TRANSACTION(securityException.getMessage());
        }
        catch (SystemException systemException) {
            throw new INVALID_TRANSACTION(systemException.getMessage());
        }
        finally {
            this.release();
        }
    }

    public void rollback() {
        Transaction transaction;
        if (this.connection != null) {
            this.connection.setTxContext(null);
        }
        if ((transaction = (Transaction)TxHelper.getTransactionManager().getTransaction(this.xid)) == null) {
            this.release();
            throw new INVALID_TRANSACTION("No transaction");
        }
        try {
            transaction.rollback();
        }
        catch (IllegalStateException illegalStateException) {
            throw new INVALID_TRANSACTION(illegalStateException.getMessage());
        }
        catch (SystemException systemException) {
            throw new INVALID_TRANSACTION(systemException.getMessage());
        }
        finally {
            this.release();
        }
    }

    private void release() {
        OIDManager oIDManager = OIDManager.getInstance();
        if (oIDManager.getServerReference((Object)this) != null) {
            oIDManager.removeServerReference(oIDManager.getServerReference((Object)this));
        }
        if (oIDManager.getServerReference((Object)this.control) != null) {
            oIDManager.removeServerReference(oIDManager.getServerReference((Object)this.control));
        }
    }
}

