/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.cos.transactions;

import java.rmi.server.ServerNotActiveException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.TransactionFactoryHelper;
import org.omg.CosTransactions._TransactionFactoryImplBase;
import weblogic.common.internal.PeerInfo;
import weblogic.corba.cos.transactions.ControlImpl;
import weblogic.corba.cos.transactions.OTSHelper;
import weblogic.iiop.Connection;
import weblogic.iiop.EndPoint;
import weblogic.iiop.IOR;
import weblogic.iiop.ObjectKey;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.internal.InitialReferenceConstants;
import weblogic.transaction.Transaction;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.TransactionManager;

public final class TransactionFactoryImpl
extends _TransactionFactoryImplBase
implements InitialReferenceConstants {
    private static TransactionFactoryImpl singleton;
    public static final String TYPE_ID;
    private static final IOR ior;

    public static TransactionFactoryImpl getTransactionFactory() {
        return singleton == null ? TransactionFactoryImpl.createSingleton() : singleton;
    }

    private static synchronized TransactionFactoryImpl createSingleton() {
        if (singleton == null) {
            singleton = new TransactionFactoryImpl();
        }
        return singleton;
    }

    private TransactionFactoryImpl() {
    }

    public IOR getIOR() {
        return ior;
    }

    public Control create(int n) {
        try {
            TransactionManager transactionManager = (TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager();
            transactionManager.begin("CORBA", n);
            Transaction transaction = (Transaction)transactionManager.getTransaction();
            transactionManager.suspend();
            EndPoint endPoint = (EndPoint)ServerHelper.getClientEndPoint();
            Connection connection = endPoint.getConnection();
            if (OTSHelper.isDebugEnabled()) {
                TransactionFactoryImpl.p("creating UserTransaction on: " + connection);
            }
            if ((endPoint.getPeerInfo() == PeerInfo.FOREIGN || endPoint.getPeerInfo() == null) && connection.getTxContext() == null) {
                connection.setTxContext(transaction);
                return new ControlImpl(transaction.getXID(), connection);
            }
            return new ControlImpl(transaction.getXID(), null);
        }
        catch (NotSupportedException notSupportedException) {
            throw new NO_IMPLEMENT(notSupportedException.getMessage());
        }
        catch (ServerNotActiveException serverNotActiveException) {
            throw new BAD_INV_ORDER(serverNotActiveException.getMessage());
        }
        catch (SystemException systemException) {
            throw new INVALID_TRANSACTION(systemException.getMessage());
        }
    }

    public Control recreate(PropagationContext propagationContext) {
        throw new NO_IMPLEMENT();
    }

    protected static void p(String string) {
        System.err.println("<TransactionFactoryImpl> " + string);
    }

    static {
        TYPE_ID = TransactionFactoryHelper.id();
        ior = new IOR(TYPE_ID, new ObjectKey(TYPE_ID, 17));
    }
}

