/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.cos.transactions;

import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.TaggedComponent;
import weblogic.utils.Debug;

public final class TransactionPolicyComponent
extends TaggedComponent {
    public static final int OTS_POLICY_RESERVED = 0;
    public static final int OTS_POLICY_REQUIRES = 1;
    public static final int OTS_POLICY_FORBIDS = 2;
    public static final int OTS_POLICY_ADAPTS = 3;
    public static final TransactionPolicyComponent EJB_OTS_POLICY = new TransactionPolicyComponent(31, 3);
    public static final TransactionPolicyComponent NON_TX_POLICY = new TransactionPolicyComponent(31, 2);
    private static final TransactionPolicyComponent[] OTS_POLICIES = new TransactionPolicyComponent[]{null, new TransactionPolicyComponent(31, 1), new TransactionPolicyComponent(31, 2), EJB_OTS_POLICY};
    public static final int INVOCATION_POLICY_EITHER = 0;
    public static final int INVOCATION_POLICY_SHARED = 1;
    public static final int INVOCATION_POLICY_UNSHARED = 2;
    public static final TransactionPolicyComponent EJB_INV_POLICY = new TransactionPolicyComponent(32, 1);
    private static final TransactionPolicyComponent[] INV_POLICIES = new TransactionPolicyComponent[]{new TransactionPolicyComponent(32, 0), EJB_INV_POLICY, new TransactionPolicyComponent(32, 2)};
    private int policy;

    public TransactionPolicyComponent(int n, int n2) {
        super(n);
        this.policy = n2;
    }

    public static TaggedComponent getInvocationPolicy(int n) {
        Debug.assertion((n >= 0 && n <= 2 ? 1 : 0) != 0);
        return INV_POLICIES[n];
    }

    public static TaggedComponent getOTSPolicy(int n) {
        Debug.assertion((n > 0 && n <= 3 ? 1 : 0) != 0);
        return OTS_POLICIES[n];
    }

    public final int getPolicy() {
        return this.policy;
    }

    public TransactionPolicyComponent(IIOPInputStream iIOPInputStream, int n) {
        super(n);
        this.read(iIOPInputStream);
    }

    public final void read(IIOPInputStream iIOPInputStream) {
        long l = iIOPInputStream.startEncapsulation();
        this.policy = iIOPInputStream.read_unsigned_short();
        iIOPInputStream.endEncapsulation(l);
    }

    public final void write(IIOPOutputStream iIOPOutputStream) {
        iIOPOutputStream.write_long(this.tag);
        long l = iIOPOutputStream.startEncapsulation();
        iIOPOutputStream.write_unsigned_short(this.policy);
        iIOPOutputStream.endEncapsulation(l);
    }
}

