/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.cos.transactions;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.transaction.xa.XAException;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.RecoveryCoordinator;
import weblogic.corba.cos.transactions.OTSHelper;
import weblogic.corba.cos.transactions.PropagationContextImpl;
import weblogic.corba.cos.transactions.ResourceImpl;
import weblogic.iiop.IIOPLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

public final class TransactionRegistrar
extends WorkAdapter {
    private static final boolean DEBUG = false;
    static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private PropagationContextImpl ctx;
    private ResourceImpl res;
    private AuthenticatedSubject subject;

    TransactionRegistrar(PropagationContextImpl propagationContextImpl, ResourceImpl resourceImpl) {
        this.ctx = propagationContextImpl;
        this.res = resourceImpl;
        this.ctx.requiresRegistration();
        this.subject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)((Object)this));
    }

    public void run() {
        SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    if (OTSHelper.isDebugEnabled()) {
                        IIOPLogger.logDebugOTS((String)("registering " + TransactionRegistrar.this.ctx));
                    }
                    RecoveryCoordinator recoveryCoordinator = ((TransactionRegistrar)TransactionRegistrar.this).ctx.getPropagationContext().current.coord.register_resource(TransactionRegistrar.this.res);
                    TransactionRegistrar.this.res.registerForRecovery(recoveryCoordinator);
                    TransactionRegistrar.this.ctx.notifyRegistration();
                }
                catch (Inactive inactive) {
                    TransactionRegistrar.this.ctx.notifyRegistration(new XAException(-7));
                }
                catch (Throwable throwable) {
                    IIOPLogger.logOTSError((String)"resource registration failed", (Throwable)throwable);
                    TransactionRegistrar.this.ctx.notifyRegistration(throwable);
                }
                return null;
            }
        });
    }

    private static final void p(String string) {
        System.err.println("<TransactionRegistrar> " + string);
    }
}

