/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.idl;

import java.io.IOException;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.InboundRequest;
import weblogic.iiop.spi.Message;
import weblogic.protocol.ServerChannel;
import weblogic.rmi.extensions.server.InvokableServerReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.rmi.internal.ServerReference;
import weblogic.rmi.spi.EndPoint;
import weblogic.rmi.spi.InvokeHandler;
import weblogic.rmi.spi.MsgInput;
import weblogic.rmi.spi.MsgOutput;
import weblogic.rmi.spi.OutboundResponse;
import weblogic.security.service.ContextHandler;
import weblogic.security.subject.AbstractSubject;

public class CollocatedRequest
implements InboundRequest,
weblogic.iiop.OutboundResponse,
ResponseHandler,
Message {
    private InvokableServerReference dispatcher;
    private String method;
    private Object txContext;
    private Object activationID;
    private IIOPOutputStream output;
    private InputStream input;
    private boolean responseExpected;
    private boolean exception = false;

    public CollocatedRequest(ServerReference serverReference, String string, boolean bl, Object object) {
        serverReference = serverReference.getDelegate();
        if (!(serverReference instanceof InvokeHandler) || !(serverReference instanceof InvokableServerReference)) {
            throw new IllegalArgumentException("ServerReference must be invokable: " + serverReference);
        }
        this.dispatcher = (InvokableServerReference)serverReference;
        this.method = string;
        this.responseExpected = bl;
        this.activationID = object;
    }

    public InputStream getInputStream() {
        if (this.input == null) {
            if (this.output == null) {
                throw new IllegalStateException("No OutputStream");
            }
            this.input = this.output.create_input_stream();
            this.output = null;
        }
        return this.input;
    }

    public OutputStream getOutputStream() {
        if (this.output == null) {
            this.output = new IIOPOutputStream(false, null, this);
        }
        return this.output;
    }

    public ResponseHandler createResponseHandler(InboundRequest inboundRequest) {
        if (inboundRequest != this) {
            throw new IllegalArgumentException("request not valid: " + inboundRequest);
        }
        return this;
    }

    public OutputStream createExceptionReply() {
        this.closeInput();
        this.exception = true;
        return this.getOutputStream();
    }

    public OutputStream createReply() {
        this.closeInput();
        return this.getOutputStream();
    }

    private void closeInput() {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.input = null;
        }
    }

    public String getMethod() {
        return this.method;
    }

    public boolean responseExpected() {
        return this.responseExpected;
    }

    public boolean isCollocated() {
        return true;
    }

    public void setTxContext(Object object) throws RemoteException {
        this.txContext = object;
    }

    public Object getTxContext() {
        return this.txContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() throws Exception {
        Thread thread2 = null;
        ClassLoader classLoader = null;
        ClassLoader classLoader2 = this.dispatcher.getApplicationClassLoader();
        if (classLoader2 != null) {
            thread2 = Thread.currentThread();
            classLoader = thread2.getContextClassLoader();
            thread2.setContextClassLoader(classLoader2);
        }
        try {
            ((InvokeHandler)this.dispatcher).invoke(null, (weblogic.rmi.spi.InboundRequest)this, (OutboundResponse)(this.responseExpected ? this : null));
            if (this.exception) {
                InputStream inputStream = this.getInputStream();
                inputStream.mark(0);
                String string = inputStream.read_string();
                inputStream.reset();
                throw new ApplicationException(string, inputStream);
            }
        }
        finally {
            if (classLoader != null) {
                thread2.setContextClassLoader(classLoader);
            }
        }
    }

    public void close() throws IOException {
        this.closeInput();
        if (this.output != null) {
            this.output.close();
        }
    }

    public Object getActivationID() throws IOException {
        return this.activationID;
    }

    public int getMinorVersion() {
        return 2;
    }

    public byte getMaxStreamFormatVersion() {
        return 2;
    }

    public void transferThreadLocalContext(weblogic.rmi.spi.InboundRequest inboundRequest) {
    }

    public void retrieveThreadLocalContext() throws IOException {
    }

    public void setContext(int n, Object object) throws IOException {
    }

    public Object getContext(int n) throws IOException {
        return null;
    }

    public X509Certificate[] getCertificateChain() {
        return null;
    }

    public ContextHandler getContextHandler() {
        return null;
    }

    public Object getReplicaInfo() throws IOException {
        return null;
    }

    public void setReplicaInfo(Object object) throws IOException {
    }

    public void sendThrowable(Throwable throwable) {
        throw new UnsupportedOperationException("sendThrowable()");
    }

    public RuntimeMethodDescriptor getRuntimeMethodDescriptor(RuntimeDescriptor runtimeDescriptor) {
        throw new UnsupportedOperationException("getRuntimeMethodDescriptor()");
    }

    public OutboundResponse getOutboundResponse() {
        throw new UnsupportedOperationException("getOutboundResponse()");
    }

    public EndPoint getEndPoint() {
        throw new UnsupportedOperationException("getEndPoint()");
    }

    public ServerChannel getServerChannel() {
        throw new UnsupportedOperationException("getServerChannel()");
    }

    public MsgInput getMsgInput() {
        throw new UnsupportedOperationException("getMsgInput()");
    }

    public MsgOutput getMsgOutput() {
        throw new UnsupportedOperationException("getMsgOutput()");
    }

    public AbstractSubject getSubject() {
        throw new UnsupportedOperationException("getSubject()");
    }

    public void send() throws RemoteException {
        throw new UnsupportedOperationException("send()");
    }
}

