/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.idl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.HashMap;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import weblogic.corba.idl.CorbaStub;
import weblogic.corba.idl.DelegateImpl;
import weblogic.corba.utils.RemoteInfo;
import weblogic.corba.utils.RepositoryId;
import weblogic.iiop.IIOPRemoteRef;
import weblogic.iiop.IOR;
import weblogic.iiop.InboundRequest;
import weblogic.iiop.ObjectKey;
import weblogic.iiop.ProtocolHandlerIIOP;
import weblogic.iiop.Utils;
import weblogic.iiop.spi.IORDelegate;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.rmi.extensions.server.RemoteReference;
import weblogic.rmi.extensions.server.RuntimeMethodDescriptor;
import weblogic.rmi.extensions.server.StubReference;
import weblogic.rmi.internal.BasicServerRef;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.internal.StubInfo;
import weblogic.rmi.spi.OutboundResponse;
import weblogic.rmi.utils.Utilities;

public final class CorbaServerRef
extends BasicServerRef
implements IORDelegate,
IDLEntity {
    private static final long serialVersionUID = 6604979373837293000L;
    private static final String OPERATIONS = "Operations";
    private static final String TIE_CLASS_SUFFIX = "_Tie";
    private static HashMap objectMethods = new HashMap();
    public static final ResponseHandler NULL_RESPONSE;
    private InvokeHandler delegate;
    private StubReference stub;
    private RemoteInfo rinfo;

    public CorbaServerRef(java.lang.Object object) throws RemoteException {
        this(OIDManager.getInstance().getNextObjectID(), object);
    }

    public CorbaServerRef(int n, java.lang.Object object) throws RemoteException {
        super(n, (java.lang.Object)CorbaServerRef.getTie(object));
        this.initialize((InvokeHandler)this.getImplementation());
    }

    private void initialize(InvokeHandler invokeHandler) {
        this.delegate = invokeHandler;
        this.incrementRefCount();
        ObjectImpl objectImpl = (ObjectImpl)invokeHandler;
        this.rinfo = CorbaServerRef.setDelegate(objectImpl, this.getObjectID());
    }

    public static RemoteInfo setDelegate(ObjectImpl objectImpl, int n) {
        String string = objectImpl._ids()[0];
        ServerChannel serverChannel = ServerChannelManager.findLocalServerChannel((Protocol)ProtocolHandlerIIOP.PROTOCOL_IIOP);
        String string2 = "localhost";
        int n2 = -1;
        if (serverChannel != null) {
            string2 = serverChannel.getPublicAddress();
            n2 = serverChannel.getPublicPort();
        }
        ObjectKey objectKey = new ObjectKey(string, n, LocalServerIdentity.getIdentity());
        RepositoryId repositoryId = new RepositoryId(string);
        RemoteInfo remoteInfo = RemoteInfo.findRemoteInfo(repositoryId, objectImpl.getClass());
        IOR iOR = new IOR(string, string2, n2, objectKey, Utilities.getAnnotationString((java.lang.Object)objectImpl), null, remoteInfo.getDescriptor());
        objectImpl._set_delegate((Delegate)new DelegateImpl(iOR));
        return remoteInfo;
    }

    private static InvokeHandler getTie(java.lang.Object object) throws NoSuchObjectException {
        if (object instanceof InvokeHandler) {
            return (InvokeHandler)object;
        }
        Class clazz = CorbaServerRef.getOperationsClass(object);
        if (clazz == null) {
            throw new NoSuchObjectException("Couldn't find Tie for class: " + object.getClass().getName());
        }
        String string = clazz.getName();
        String string2 = string.substring(0, string.length() - OPERATIONS.length()) + TIE_CLASS_SUFFIX;
        try {
            Class clazz2 = Utils.loadClass(string2, null, object.getClass().getClassLoader());
            Constructor constructor = clazz2.getDeclaredConstructor(clazz);
            return (InvokeHandler)constructor.newInstance(object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw (NoSuchObjectException)new NoSuchObjectException(noSuchMethodException.getMessage()).initCause(noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw (NoSuchObjectException)new NoSuchObjectException(instantiationException.getMessage()).initCause(instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (NoSuchObjectException)new NoSuchObjectException(invocationTargetException.getTargetException().getMessage()).initCause(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (NoSuchObjectException)new NoSuchObjectException(illegalAccessException.getMessage()).initCause(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchObjectException("Couldn't load Tie class: " + string2);
        }
    }

    public IOR getIOR() {
        return ((IORDelegate)((ObjectImpl)this.delegate)._get_delegate()).getIOR();
    }

    public StubReference getStubReference() {
        if (this.stub == null) {
            this.stub = new StubInfo((RemoteReference)new IIOPRemoteRef(this.getIOR(), this.rinfo), this.getDescriptor().getClientRuntimeDescriptor(null), null, CorbaStub.class.getName());
        }
        return this.stub;
    }

    public void invoke(RuntimeMethodDescriptor runtimeMethodDescriptor, weblogic.rmi.spi.InboundRequest inboundRequest, OutboundResponse outboundResponse) throws Exception {
        try {
            InboundRequest inboundRequest2 = (InboundRequest)inboundRequest;
            if (!inboundRequest2.isCollocated() && inboundRequest2.getEndPoint().isDead()) {
                throw new ConnectException("Connection is already shutdown for " + inboundRequest);
            }
            Integer n = (Integer)objectMethods.get(inboundRequest2.getMethod());
            ResponseHandler responseHandler = outboundResponse == null ? NULL_RESPONSE : ((weblogic.iiop.OutboundResponse)outboundResponse).createResponseHandler(inboundRequest2);
            if (n != null) {
                this.invokeObjectMethod(n, inboundRequest2.getInputStream(), responseHandler);
            } else {
                this.delegate._invoke(inboundRequest2.getMethod(), inboundRequest2.getInputStream(), responseHandler);
            }
            if (outboundResponse != null) {
                outboundResponse.transferThreadLocalContext(inboundRequest);
            }
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchObjectException("CORBA ties are only supported with IIOP");
        }
    }

    protected OutputStream invokeObjectMethod(Integer n, InputStream inputStream, ResponseHandler responseHandler) {
        OutputStream outputStream = null;
        ObjectImpl objectImpl = (ObjectImpl)this.delegate;
        switch (n) {
            case 0: {
                boolean bl = objectImpl._is_a(inputStream.read_string());
                responseHandler.createReply().write_boolean(bl);
                break;
            }
            case 1: {
                boolean bl = objectImpl._is_equivalent(inputStream.read_Object());
                responseHandler.createReply().write_boolean(bl);
                break;
            }
            case 2: {
                boolean bl = objectImpl._non_existent();
                responseHandler.createReply().write_boolean(bl);
                break;
            }
            case 3: {
                Object object = objectImpl._get_interface_def();
                responseHandler.createReply().write_Object(object);
                break;
            }
            case 4: {
                objectImpl._release();
                break;
            }
            default: {
                throw new BAD_OPERATION(0, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        return outputStream;
    }

    public static Class getOperationsClass(java.lang.Object object) {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                String string = classArray[i].getName();
                if (!string.endsWith(OPERATIONS)) continue;
                return classArray[i];
            }
        }
        return null;
    }

    static {
        objectMethods.put("_is_a", new Integer(0));
        objectMethods.put("_is_equivalent", new Integer(1));
        objectMethods.put("_non_existent", new Integer(2));
        objectMethods.put("_interface", new Integer(3));
        objectMethods.put("_release", new Integer(4));
        NULL_RESPONSE = new ResponseHandler(){

            public OutputStream createReply() {
                return null;
            }

            public OutputStream createExceptionReply() {
                return null;
            }
        };
    }
}

