/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.idl;

import java.io.IOException;
import java.security.AccessController;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Request;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CosTransactions.TransactionalObject;
import weblogic.corba.cos.transactions.OTSHelper;
import weblogic.corba.idl.DelegateImpl;
import weblogic.corba.idl.RequestImpl;
import weblogic.corba.idl.poa.RelativeRequestTimeoutPolicyImpl;
import weblogic.corba.idl.poa.RelativeRoundtripTimeoutPolicyImpl;
import weblogic.corba.idl.poa.ReplyEndTimePolicyImpl;
import weblogic.corba.idl.poa.RequestEndTimePolicyImpl;
import weblogic.corba.iiop.cluster.Selector;
import weblogic.corba.iiop.cluster.SelectorFactory;
import weblogic.corba.j2ee.naming.ORBHelper;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.ClusterComponent;
import weblogic.iiop.EndPoint;
import weblogic.iiop.EndPointManager;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPLogger;
import weblogic.iiop.IIOPRemoteRef;
import weblogic.iiop.IIOPService;
import weblogic.iiop.IOR;
import weblogic.iiop.ReplyMessage;
import weblogic.iiop.RequestMessage;
import weblogic.iiop.Utils;
import weblogic.iiop.VendorInfoCluster;
import weblogic.iiop.spi.MessageStream;
import weblogic.kernel.KernelStatus;
import weblogic.rmi.cluster.Version;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.transaction.ServerTransactionInterceptor;
import weblogic.transaction.Transaction;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.TransactionManager;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.StackTraceUtils;

final class RemoteDelegateImpl
extends DelegateImpl {
    private static final AbstractSubject kernelId = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
    private static final DebugCategory debugTransport = Debug.getCategory((String)"weblogic.iiop.transport");
    private static final DebugLogger debugIIOPTransport = DebugLogger.getDebugLogger((String)"DebugIIOPTransport");
    private IOR currentIOR;
    private ClusterComponent replicas;
    private Version version;
    private int current = 0;
    private Selector selector;

    public RemoteDelegateImpl(IOR iOR) {
        super(iOR);
        this.getIOR().getProfile();
    }

    protected RemoteDelegateImpl(RemoteDelegateImpl remoteDelegateImpl) {
        super(remoteDelegateImpl);
        this.currentIOR = remoteDelegateImpl.currentIOR;
        this.replicas = remoteDelegateImpl.replicas;
        this.version = remoteDelegateImpl.version;
        this.current = remoteDelegateImpl.current;
        this.selector = remoteDelegateImpl.selector;
    }

    protected Delegate copy() {
        return new RemoteDelegateImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean is_a(Object object, String string) {
        String[] stringArray = ((ObjectImpl)object)._ids();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        OutputStream outputStream = this.request(object, "_is_a", true);
        boolean bl = false;
        InputStream inputStream = null;
        try {
            outputStream.write_string(string);
            inputStream = this.invoke(object, outputStream);
            bl = inputStream.read_boolean();
        }
        catch (ApplicationException applicationException) {
            this.releaseReply(object, inputStream);
        }
        catch (RemarshalException remarshalException) {
            boolean bl2 = this.is_a(object, string);
            {
                catch (Throwable throwable) {
                    this.releaseReply(object, inputStream);
                    throw throwable;
                }
            }
            this.releaseReply(object, inputStream);
            return bl2;
        }
        this.releaseReply(object, inputStream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean non_existent(Object object) {
        OutputStream outputStream = this.request(object, "_non_existent", true);
        boolean bl = false;
        InputStream inputStream = null;
        try {
            inputStream = this.invoke(object, outputStream);
            bl = inputStream.read_boolean();
        }
        catch (ApplicationException applicationException) {
        }
        catch (RemarshalException remarshalException) {
            boolean bl2 = this.non_existent(object);
            return bl2;
        }
        finally {
            this.releaseReply(object, inputStream);
        }
        return bl;
    }

    public boolean is_local(Object object) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get_interface_def(Object object) {
        OutputStream outputStream = this.request(object, "_interface", true);
        Object object2 = null;
        InputStream inputStream = null;
        try {
            inputStream = this.invoke(object, outputStream);
            object2 = inputStream.read_Object();
        }
        catch (ApplicationException applicationException) {
        }
        catch (RemarshalException remarshalException) {
            Object object3 = this.get_interface_def(object);
            return object3;
        }
        finally {
            this.releaseReply(object, inputStream);
        }
        return object2;
    }

    public OutputStream request(Object object, String string, boolean bl) {
        try {
            Policy policy;
            IOR iOR = this.getInvocationIOR();
            EndPoint endPoint = EndPointManager.findOrCreateEndPoint(iOR);
            RequestMessage requestMessage = new RequestMessage(endPoint, iOR, string, !bl);
            if (this.version != null) {
                endPoint.setMessageServiceContext(requestMessage, new VendorInfoCluster(this.version));
            }
            if ((policy = this.getPolicy(32)) != null) {
                requestMessage.setTimeout(((RelativeRoundtripTimeoutPolicyImpl)policy).relativeExpiryMillis());
            } else {
                policy = this.getPolicy(31);
                if (policy != null) {
                    requestMessage.setTimeout(((RelativeRequestTimeoutPolicyImpl)policy).relativeExpiryMillis());
                } else {
                    policy = this.getPolicy(28);
                    if (policy != null) {
                        requestMessage.setTimeout(((RequestEndTimePolicyImpl)policy).relativeTimeoutMillis());
                    } else {
                        policy = this.getPolicy(30);
                        if (policy != null) {
                            requestMessage.setTimeout(((ReplyEndTimePolicyImpl)policy).relativeTimeoutMillis());
                        }
                    }
                }
            }
            endPoint.setSubject(requestMessage, (AuthenticatedSubject)SubjectManager.getSubjectManager().getCurrentSubject(kernelId));
            if (iOR.getProfile().isTransactional() || IIOPService.txMechanism == 3 || object instanceof TransactionalObject) {
                if (KernelStatus.isServer()) {
                    OTSHelper.forceLocalCoordinator();
                }
                TransactionManager transactionManager = (TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager();
                ServerTransactionInterceptor serverTransactionInterceptor = (ServerTransactionInterceptor)transactionManager.getInterceptor();
                endPoint.setOutboundRequestTxContext(requestMessage, serverTransactionInterceptor.sendRequest((java.lang.Object)null));
            }
            requestMessage.flush();
            return requestMessage.getOutputStream();
        }
        catch (IOException iOException) {
            throw Utils.mapToCORBAException(iOException);
        }
    }

    public InputStream invoke(Object object, OutputStream outputStream) throws ApplicationException, RemarshalException {
        RequestMessage requestMessage = (RequestMessage)((MessageStream)outputStream).getMessage();
        if (requestMessage.isOneWay()) {
            this.sendOneway(requestMessage);
            return null;
        }
        return this.invoke(object, requestMessage);
    }

    public Request request(Object object, String string) {
        return new RequestImpl(object, this, string, null, null, null);
    }

    public Request create_request(Object object, Context context, String string, NVList nVList, NamedValue namedValue, ExceptionList exceptionList, ContextList contextList) {
        return new RequestImpl(object, this, string, nVList, namedValue, exceptionList);
    }

    public Request create_request(Object object, Context context, String string, NVList nVList, NamedValue namedValue) {
        return new RequestImpl(object, this, string, nVList, namedValue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream invoke(Object object, RequestMessage requestMessage) throws ApplicationException, RemarshalException {
        try {
            try {
                EndPoint endPoint = requestMessage.getEndPoint();
                if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
                    IIOPLogger.logDebugTransport((String)("REQUEST(" + requestMessage.getRequestID() + "): remote IDL invoke " + requestMessage.getOperationName() + "()"));
                }
                ReplyMessage replyMessage = (ReplyMessage)endPoint.sendReceive(requestMessage);
                return this.postInvoke(object, requestMessage, replyMessage);
            }
            catch (IOException iOException) {
                throw Utils.mapToCORBAException(iOException);
            }
        }
        catch (SystemException systemException) {
            if (this.replicas != null && ORBHelper.isRecoverableORBFailure(systemException, this.replicas.getIdempotent())) {
                ClusterComponent clusterComponent = this.replicas;
                synchronized (clusterComponent) {
                    if (this.replicas.getIORs().size() > 1) {
                        this.replicas.getIORs().remove(this.replicas.getIORs().indexOf(requestMessage.getIOR()));
                        throw new RemarshalException();
                    }
                }
            }
            throw systemException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IIOPInputStream postInvoke(Object object, RequestMessage requestMessage, ReplyMessage replyMessage) throws ApplicationException, RemarshalException, IOException {
        java.lang.Object object2;
        java.lang.Object object3;
        EndPoint endPoint = replyMessage.getEndPoint();
        if (requestMessage.getIOR().getProfile().isTransactional() || IIOPService.txMechanism == 3 || object instanceof TransactionalObject) {
            object3 = (TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager();
            object2 = object3.getInterceptor();
            object2.receiveResponse(endPoint.getInboundResponseTxContext(replyMessage));
        }
        if (replyMessage.needsForwarding()) {
            if (this.replicas != null) {
                object3 = this.replicas;
                synchronized (object3) {
                    int n = this.replicas.getIORs().indexOf(requestMessage.getIOR());
                    this.replicas.getIORs().remove(n);
                    this.replicas.getIORs().add(n, replyMessage.getIOR());
                }
            }
            this.currentIOR = replyMessage.getIOR();
            throw new RemarshalException();
        }
        object3 = (VendorInfoCluster)endPoint.getMessageServiceContext(replyMessage, 1111834883);
        if (object3 != null) {
            object2 = this;
            synchronized (object2) {
                ((VendorInfoCluster)object3).setClusterInfo(this.replicas);
                this.replicas = ((VendorInfoCluster)object3).getClusterInfo();
                this.version = (Version)((VendorInfoCluster)object3).version();
            }
        }
        if (replyMessage.getReplyStatus() == 1) {
            throw new ApplicationException(replyMessage.getExceptionId().toString(), (InputStream)replyMessage.getInputStream());
        }
        object2 = replyMessage.getThrowable();
        if (object2 != null) {
            Transaction transaction;
            if (KernelStatus.isServer() && object2 instanceof TRANSACTION_ROLLEDBACK && (transaction = (Transaction)TransactionHelper.getTransactionHelper().getTransaction()) != null) {
                transaction.setRollbackOnly((Throwable)object2);
            }
            throw (SystemException)StackTraceUtils.getThrowableWithCause((Throwable)object2);
        }
        return replyMessage.getInputStream();
    }

    void sendDeferred(RequestMessage requestMessage) {
        try {
            EndPoint endPoint = requestMessage.getEndPoint();
            if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
                IIOPLogger.logDebugTransport((String)("REQUEST(" + requestMessage.getRequestID() + "): deferred IDL invoke " + requestMessage.getOperationName() + "()"));
            }
            endPoint.sendDeferred(requestMessage);
        }
        catch (IOException iOException) {
            throw Utils.mapToCORBAException(iOException);
        }
    }

    void sendOneway(RequestMessage requestMessage) {
        try {
            EndPoint endPoint = requestMessage.getEndPoint();
            if (debugTransport.isEnabled() || debugIIOPTransport.isDebugEnabled()) {
                IIOPLogger.logDebugTransport((String)("REQUEST(" + requestMessage.getRequestID() + "): oneway IDL invoke " + requestMessage.getOperationName() + "()"));
            }
            endPoint.send(requestMessage.getOutputStream());
        }
        catch (IOException iOException) {
            throw Utils.mapToCORBAException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IOR getInvocationIOR() throws IOException {
        if (this.currentIOR != null) {
            if (this.replicas != null) {
                this.current = this.selector.select(this.current, this.replicas.getIORs().size());
                this.currentIOR = (IOR)this.replicas.getIORs().get(this.current);
            }
            return this.currentIOR;
        }
        RemoteDelegateImpl remoteDelegateImpl = this;
        synchronized (remoteDelegateImpl) {
            if (this.currentIOR == null) {
                this.currentIOR = IIOPRemoteRef.locateIORForRequest(this.getIOR());
                this.replicas = (ClusterComponent)this.currentIOR.getProfile().getComponent(1111834883);
                if (this.replicas != null) {
                    this.selector = SelectorFactory.getSelector(this.replicas.getClusterAlgorithm());
                    this.version = this.replicas.getVersion();
                    this.current = 0;
                }
            }
        }
        return this.getInvocationIOR();
    }
}

