/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.idl;

import java.io.IOException;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.Environment;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.Request;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UnknownUserException;
import org.omg.CORBA.UserException;
import org.omg.CORBA.WrongTransaction;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.RemarshalException;
import weblogic.corba.idl.AnyImpl;
import weblogic.corba.idl.EnvironmentImpl;
import weblogic.corba.idl.ExceptionListImpl;
import weblogic.corba.idl.NVListImpl;
import weblogic.corba.idl.NamedValueImpl;
import weblogic.corba.idl.RemoteDelegateImpl;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.ReplyMessage;
import weblogic.iiop.RequestMessage;
import weblogic.iiop.Utils;

public class RequestImpl
extends Request {
    private RemoteDelegateImpl delegate;
    private final NVList arguments;
    private final String operationName;
    private final NamedValue returnValue;
    private final ExceptionList exceptions;
    private final Environment env;
    private RequestMessage deferredRequest;
    private final Object target;
    private TypeCode returnType;
    private static final String RESULT = "result";

    RequestImpl(Object object, RemoteDelegateImpl remoteDelegateImpl, String string, NVList nVList, NamedValue namedValue, ExceptionList exceptionList) {
        this.delegate = remoteDelegateImpl;
        this.operationName = string;
        this.target = object;
        this.arguments = nVList == null ? new NVListImpl(2) : nVList;
        this.exceptions = exceptionList == null ? new ExceptionListImpl() : exceptionList;
        this.returnValue = namedValue == null ? new NamedValueImpl(RESULT, new AnyImpl(), 2) : namedValue;
        this.env = new EnvironmentImpl();
    }

    private RequestMessage marshalArgs(boolean bl) throws Bounds {
        IIOPOutputStream iIOPOutputStream = (IIOPOutputStream)this.delegate.request(null, this.operationName, bl);
        for (int i = 0; i < this.arguments.count(); ++i) {
            NamedValue namedValue = this.arguments.item(i);
            switch (namedValue.flags()) {
                case 1: 
                case 3: {
                    iIOPOutputStream.write_any(namedValue.value(), namedValue.value().type());
                }
            }
        }
        return (RequestMessage)iIOPOutputStream.getMessage();
    }

    private void unmarshalArgs(IIOPInputStream iIOPInputStream) throws Bounds {
        if (this.returnType != null) {
            this.returnValue.value().type(this.returnType);
            iIOPInputStream.read_any(this.returnValue.value(), this.returnType);
        }
        for (int i = 0; i < this.arguments.count(); ++i) {
            NamedValue namedValue = this.arguments.item(i);
            switch (namedValue.flags()) {
                case 2: 
                case 3: {
                    iIOPInputStream.read_any(namedValue.value(), namedValue.value().type());
                }
            }
        }
        this.env.clear();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke() {
        IIOPInputStream iIOPInputStream = null;
        if (this.delegate == null) {
            throw new BAD_INV_ORDER("invoke() already called", 1330446346, CompletionStatus.COMPLETED_NO);
        }
        try {
            RequestMessage requestMessage = this.marshalArgs(true);
            iIOPInputStream = (IIOPInputStream)this.delegate.invoke(this.target, requestMessage);
            this.unmarshalArgs(iIOPInputStream);
            this.delegate.releaseReply(null, (InputStream)iIOPInputStream);
            this.delegate = null;
            return;
        }
        catch (RemarshalException remarshalException) {
            this.invoke();
            return;
            catch (ApplicationException applicationException) {
                try {
                    int n = 0;
                    while (n < this.exceptions.count()) {
                        if (this.exceptions.item(n).id().equals(applicationException.getId())) {
                            AnyImpl anyImpl = new AnyImpl();
                            anyImpl.read_value(applicationException.getInputStream(), this.exceptions.item(n));
                            this.env.exception((Exception)new UnknownUserException((Any)anyImpl));
                        }
                        ++n;
                    }
                    return;
                }
                catch (UserException userException) {
                    // empty catch block
                    return;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (Bounds bounds) {
                    throw new AssertionError((java.lang.Object)(bounds.toString() + " thrown"));
                    catch (SystemException systemException) {
                        this.env.exception((Exception)((java.lang.Object)systemException));
                        throw systemException;
                    }
                }
            }
        }
        finally {
            this.delegate.releaseReply(null, (InputStream)iIOPInputStream);
            this.delegate = null;
        }
    }

    public Object target() {
        return this.target;
    }

    public String operation() {
        return this.operationName;
    }

    public NamedValue result() {
        return this.returnValue;
    }

    public NVList arguments() {
        return this.arguments;
    }

    public Environment env() {
        return this.env;
    }

    public ExceptionList exceptions() {
        return this.exceptions;
    }

    public ContextList contexts() {
        throw new NO_IMPLEMENT();
    }

    public void ctx(Context context) {
        throw new NO_IMPLEMENT();
    }

    public Context ctx() {
        throw new NO_IMPLEMENT();
    }

    public Any add_in_arg() {
        return this.arguments.add(1).value();
    }

    public Any add_named_in_arg(String string) {
        return this.arguments.add_item(string, 1).value();
    }

    public Any add_inout_arg() {
        return this.arguments.add(3).value();
    }

    public Any add_named_inout_arg(String string) {
        return this.arguments.add_item(string, 3).value();
    }

    public Any add_out_arg() {
        return this.arguments.add(2).value();
    }

    public Any add_named_out_arg(String string) {
        return this.arguments.add_item(string, 2).value();
    }

    public void set_return_type(TypeCode typeCode) {
        this.returnType = typeCode;
    }

    public Any return_value() {
        if (this.returnType == null) {
            throw new BAD_INV_ORDER("Cannot access return value before invoke");
        }
        return this.returnValue.value();
    }

    public void send_oneway() {
        java.lang.Object var1_1 = null;
        if (this.delegate == null) {
            throw new BAD_INV_ORDER("send_oneway() already called", 1330446346, CompletionStatus.COMPLETED_NO);
        }
        try {
            RequestMessage requestMessage = this.marshalArgs(false);
            this.delegate.sendOneway(requestMessage);
            this.delegate = null;
        }
        catch (Bounds bounds) {
            throw new AssertionError((java.lang.Object)(bounds.toString() + " thrown"));
        }
        catch (SystemException systemException) {
            this.env.exception((Exception)((java.lang.Object)systemException));
            throw systemException;
        }
    }

    public void send_deferred() {
        if (this.deferredRequest != null || this.delegate == null) {
            throw new BAD_INV_ORDER("send_deferred() already called", 1330446346, CompletionStatus.COMPLETED_NO);
        }
        try {
            this.deferredRequest = this.marshalArgs(true);
            this.delegate.sendDeferred(this.deferredRequest);
        }
        catch (Bounds bounds) {
            throw new AssertionError((java.lang.Object)(bounds.toString() + " thrown"));
        }
        catch (SystemException systemException) {
            this.env.exception((Exception)((java.lang.Object)systemException));
            throw systemException;
        }
    }

    public boolean poll_response() {
        if (this.delegate == null) {
            throw new BAD_INV_ORDER("poll_response() after invoke()", 1330446349, CompletionStatus.COMPLETED_NO);
        }
        if (this.deferredRequest == null) {
            throw new BAD_INV_ORDER("poll_response() without outstanding request", 1330446347, CompletionStatus.COMPLETED_NO);
        }
        return this.deferredRequest.pollResponse();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void get_response() throws WrongTransaction {
        if (this.delegate == null) {
            throw new BAD_INV_ORDER("get_response() after invoke()", 1330446349, CompletionStatus.COMPLETED_NO);
        }
        if (this.deferredRequest == null) {
            throw new BAD_INV_ORDER("get_response() without outstanding request", 1330446347, CompletionStatus.COMPLETED_NO);
        }
        IIOPInputStream iIOPInputStream = null;
        try {
            ReplyMessage replyMessage = (ReplyMessage)this.deferredRequest.getReply();
            iIOPInputStream = this.delegate.postInvoke(this.target, this.deferredRequest, replyMessage);
            this.unmarshalArgs(iIOPInputStream);
            this.deferredRequest = null;
        }
        catch (RemarshalException remarshalException) {
            this.env.exception((Exception)((java.lang.Object)remarshalException));
            this.deferredRequest = null;
            this.delegate.releaseReply(null, (InputStream)iIOPInputStream);
            this.delegate = null;
            return;
            catch (ApplicationException applicationException) {
                try {
                    for (int i = 0; i < this.exceptions.count(); ++i) {
                        if (!this.exceptions.item(i).id().equals(applicationException.getId())) continue;
                        AnyImpl anyImpl = new AnyImpl();
                        anyImpl.read_value(applicationException.getInputStream(), this.exceptions.item(i));
                        this.env.exception((Exception)new UnknownUserException((Any)anyImpl));
                    }
                }
                catch (UserException userException) {
                    // empty catch block
                }
                this.deferredRequest = null;
                {
                    catch (Throwable throwable) {
                        this.deferredRequest = null;
                        this.delegate.releaseReply(null, (InputStream)iIOPInputStream);
                        this.delegate = null;
                        throw throwable;
                    }
                }
                this.delegate.releaseReply(null, (InputStream)iIOPInputStream);
                this.delegate = null;
                return;
                catch (Bounds bounds) {
                    throw new AssertionError((java.lang.Object)(bounds.toString() + " thrown"));
                    catch (IOException iOException) {
                        SystemException systemException = Utils.mapToCORBAException(iOException);
                        this.env.exception((Exception)((java.lang.Object)systemException));
                        throw systemException;
                    }
                    catch (SystemException systemException) {
                        this.env.exception((Exception)((java.lang.Object)systemException));
                        throw systemException;
                    }
                }
            }
        }
        this.delegate.releaseReply(null, (InputStream)iIOPInputStream);
        this.delegate = null;
        return;
    }
}

