/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.idl;

import org.omg.CORBA.Any;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import weblogic.corba.utils.RepositoryId;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;

public final class TypeCodeImpl
extends TypeCode {
    public static final int VM_NONE = 0;
    public static final int VM_CUSTOM = 1;
    public static final int VM_ABSTRACT = 2;
    public static final int VM_TRUNCATABLE = 3;
    private static final boolean DEBUG = false;
    private TCKind type;
    private RepositoryId repid;
    private String name;
    private TypeCode content_type;
    private MemberInfo[] members;
    private int length = 0;
    private short mod = 0;
    private short digits = (short)-1;
    private short scale = (short)-1;
    public static final TypeCodeImpl NULL_TC = new TypeCodeImpl(0);
    public static final TypeCodeImpl NULL = new TypeCodeImpl(32, RepositoryId.NULL, "");
    public static final TypeCodeImpl OCTET = new TypeCodeImpl(10);
    public static final TypeCodeImpl STRING = new TypeCodeImpl(30, RepositoryId.STRING, "", new TypeCodeImpl(27));
    public static final TypeCodeImpl OBJECT = new TypeCodeImpl(14, RepositoryId.OBJECT, "");
    public static final TypeCodeImpl VALUE = new TypeCodeImpl(29, RepositoryId.EMPTY, "", NULL_TC);
    private static final TypeCodeImpl[] simpleTypes = new TypeCodeImpl[]{NULL_TC, new TypeCodeImpl(1), new TypeCodeImpl(2), new TypeCodeImpl(3), new TypeCodeImpl(4), new TypeCodeImpl(5), new TypeCodeImpl(6), new TypeCodeImpl(7), new TypeCodeImpl(8), new TypeCodeImpl(9), OCTET, new TypeCodeImpl(11), new TypeCodeImpl(12), new TypeCodeImpl(13), OBJECT, new TypeCodeImpl(15), new TypeCodeImpl(16), new TypeCodeImpl(17), new TypeCodeImpl(18), new TypeCodeImpl(19), new TypeCodeImpl(20), new TypeCodeImpl(21), new TypeCodeImpl(22), new TypeCodeImpl(23), new TypeCodeImpl(24), new TypeCodeImpl(25), new TypeCodeImpl(26), new TypeCodeImpl(27), new TypeCodeImpl(28), VALUE, new TypeCodeImpl(30), new TypeCodeImpl(31), new TypeCodeImpl(32)};

    public TypeCodeImpl(int n, RepositoryId repositoryId, String string, TypeCode typeCode) {
        this.repid = repositoryId;
        this.name = string;
        this.type = TCKind.from_int((int)n);
        this.content_type = typeCode;
    }

    public TypeCodeImpl(int n, RepositoryId repositoryId, String string) {
        this(n, repositoryId, string, null);
    }

    public TypeCodeImpl(int n) {
        this.repid = null;
        this.name = null;
        this.type = TCKind.from_int((int)n);
    }

    public boolean equal(TypeCode typeCode) {
        if (!(typeCode instanceof TypeCodeImpl)) {
            return false;
        }
        TypeCodeImpl typeCodeImpl = (TypeCodeImpl)typeCode;
        return typeCodeImpl.type.value() == this.type.value() && typeCodeImpl.length == this.length && typeCodeImpl.mod == this.mod && typeCodeImpl.digits == this.digits && typeCodeImpl.scale == this.scale && TypeCodeImpl.safe_equals(typeCodeImpl.repid, this.repid) && TypeCodeImpl.safe_equals(typeCodeImpl.name, this.name) && TypeCodeImpl.safe_equals(typeCodeImpl.content_type, this.content_type) && this.members_equal(typeCodeImpl);
    }

    public boolean equals(Object object) {
        if (object instanceof TypeCode) {
            return this.equal((TypeCode)object);
        }
        return false;
    }

    private static final boolean safe_equals(Object object, Object object2) {
        return object == null && object2 == null || object != null && object.equals(object2);
    }

    private final boolean members_equal(TypeCodeImpl typeCodeImpl) {
        if (typeCodeImpl.members == null && this.members == null) {
            return true;
        }
        if (this.members != null && typeCodeImpl.members != null && this.members.length == typeCodeImpl.members.length) {
            for (int i = 0; i < this.members.length; ++i) {
                if (TypeCodeImpl.safe_equals(this.members[i].name, typeCodeImpl.members[i].name) && TypeCodeImpl.safe_equals(this.members[i].type, typeCodeImpl.members[i].type) && TypeCodeImpl.safe_equals(this.members[i].label, typeCodeImpl.members[i].label) && this.members[i].access == typeCodeImpl.members[i].access) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equivalent(TypeCode typeCode) {
        return this.equal(typeCode);
    }

    public TypeCode get_compact_typecode() {
        return simpleTypes[this.type.value()];
    }

    public TCKind kind() {
        return this.type;
    }

    public String id() throws BadKind {
        if (this.repid == null) {
            return "";
        }
        return this.repid.toString();
    }

    public final RepositoryId getRepositoryId() {
        return this.repid;
    }

    public static final RepositoryId getRepositoryId(TypeCode typeCode) {
        if (typeCode instanceof TypeCodeImpl) {
            return ((TypeCodeImpl)typeCode).getRepositoryId();
        }
        try {
            return new RepositoryId(typeCode.id());
        }
        catch (BadKind badKind) {
            return null;
        }
    }

    public String name() throws BadKind {
        return this.name;
    }

    public int member_count() throws BadKind {
        if (this.members == null) {
            return 0;
        }
        return this.members.length;
    }

    public String member_name(int n) throws BadKind, Bounds {
        if (this.members == null) {
            throw new BadKind();
        }
        if (n >= this.members.length) {
            throw new Bounds();
        }
        return this.members[n].name;
    }

    public TypeCode member_type(int n) throws BadKind, Bounds {
        if (this.members == null) {
            throw new BadKind();
        }
        if (n >= this.members.length) {
            throw new Bounds();
        }
        return this.members[n].type;
    }

    public Any member_label(int n) throws BadKind, Bounds {
        if (this.members == null) {
            throw new BadKind();
        }
        if (n >= this.members.length) {
            throw new Bounds();
        }
        return this.members[n].label;
    }

    public TypeCode discriminator_type() throws BadKind {
        if (this.content_type == null) {
            throw new BadKind();
        }
        return this.content_type;
    }

    public int default_index() throws BadKind {
        if (this.type.value() != 16) {
            throw new BadKind();
        }
        return this.length;
    }

    public int length() throws BadKind {
        if (this.length < 0) {
            throw new BadKind();
        }
        return this.length;
    }

    public TypeCode content_type() throws BadKind {
        if (this.content_type == null) {
            throw new BadKind();
        }
        return this.content_type;
    }

    public short fixed_digits() throws BadKind {
        if (this.digits == -1) {
            throw new BadKind();
        }
        return this.digits;
    }

    public short fixed_scale() throws BadKind {
        if (this.scale == -1) {
            throw new BadKind();
        }
        return this.scale;
    }

    public short member_visibility(int n) throws BadKind, Bounds {
        if (this.members == null) {
            throw new BadKind();
        }
        if (n >= this.members.length) {
            throw new Bounds();
        }
        return this.members[n].access;
    }

    public short type_modifier() throws BadKind {
        return this.mod;
    }

    public TypeCode concrete_base_type() throws BadKind {
        if (this.content_type == null) {
            throw new BadKind();
        }
        return this.content_type;
    }

    public void read(IIOPInputStream iIOPInputStream) {
        switch (this.type.value()) {
            case 14: 
            case 32: {
                long l = iIOPInputStream.startEncapsulation();
                this.repid = iIOPInputStream.read_repository_id();
                this.name = iIOPInputStream.read_string();
                iIOPInputStream.endEncapsulation(l);
                break;
            }
            case 29: {
                long l = iIOPInputStream.startEncapsulation();
                this.repid = iIOPInputStream.read_repository_id();
                this.name = iIOPInputStream.read_string();
                this.mod = iIOPInputStream.read_short();
                this.content_type = iIOPInputStream.read_TypeCode();
                int n = iIOPInputStream.read_ulong();
                this.members = new MemberInfo[n];
                for (int i = 0; i < n; ++i) {
                    this.members[i] = new MemberInfo();
                    this.members[i].name = iIOPInputStream.read_string();
                    this.members[i].type = iIOPInputStream.read_TypeCode();
                    this.members[i].access = iIOPInputStream.read_short();
                }
                iIOPInputStream.endEncapsulation(l);
                break;
            }
            case 15: 
            case 22: {
                long l = iIOPInputStream.startEncapsulation();
                this.repid = iIOPInputStream.read_repository_id();
                this.name = iIOPInputStream.read_string();
                int n = iIOPInputStream.read_ulong();
                this.members = new MemberInfo[n];
                for (int i = 0; i < n; ++i) {
                    this.members[i] = new MemberInfo();
                    this.members[i].name = iIOPInputStream.read_string();
                    this.members[i].type = iIOPInputStream.read_TypeCode();
                }
                iIOPInputStream.endEncapsulation(l);
                break;
            }
            case 16: {
                long l = iIOPInputStream.startEncapsulation();
                this.repid = iIOPInputStream.read_repository_id();
                this.name = iIOPInputStream.read_string();
                this.content_type = iIOPInputStream.read_TypeCode();
                this.length = iIOPInputStream.read_long();
                int n = iIOPInputStream.read_ulong();
                this.members = new MemberInfo[n];
                for (int i = 0; i < n; ++i) {
                    this.members[i] = new MemberInfo();
                    if (i == this.length) {
                        this.members[i].label = iIOPInputStream.read_any(TypeCodeImpl.OCTET);
                    } else {
                        this.members[i].label = iIOPInputStream.read_any((TypeCodeImpl)this.content_type);
                    }
                    this.members[i].name = iIOPInputStream.read_string();
                    this.members[i].type = iIOPInputStream.read_TypeCode();
                }
                iIOPInputStream.endEncapsulation(l);
                break;
            }
            case 17: {
                long l = iIOPInputStream.startEncapsulation();
                this.repid = iIOPInputStream.read_repository_id();
                this.name = iIOPInputStream.read_string();
                int n = iIOPInputStream.read_ulong();
                this.members = new MemberInfo[n];
                for (int i = 0; i < n; ++i) {
                    this.members[i] = new MemberInfo();
                    this.members[i].name = iIOPInputStream.read_string();
                }
                iIOPInputStream.endEncapsulation(l);
                break;
            }
            case 30: {
                long l = iIOPInputStream.startEncapsulation();
                this.repid = iIOPInputStream.read_repository_id();
                this.name = iIOPInputStream.read_string();
                this.content_type = iIOPInputStream.read_TypeCode();
                iIOPInputStream.endEncapsulation(l);
                break;
            }
            case 18: 
            case 27: {
                this.length = iIOPInputStream.read_ulong();
                break;
            }
            case 19: 
            case 20: {
                long l = iIOPInputStream.startEncapsulation();
                this.content_type = iIOPInputStream.read_TypeCode();
                this.length = iIOPInputStream.read_ulong();
                iIOPInputStream.endEncapsulation(l);
                break;
            }
            case 21: {
                long l = iIOPInputStream.startEncapsulation();
                this.repid = iIOPInputStream.read_repository_id();
                this.name = iIOPInputStream.read_string();
                this.content_type = iIOPInputStream.read_TypeCode();
                iIOPInputStream.endEncapsulation(l);
                break;
            }
            case 28: {
                this.digits = iIOPInputStream.read_short();
                this.scale = iIOPInputStream.read_short();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            default: {
                throw new MARSHAL("Unknown tc: " + this.type.value());
            }
        }
    }

    public void write(IIOPOutputStream iIOPOutputStream) {
        TypeCodeImpl.write(this, iIOPOutputStream);
    }

    public static void write(TypeCode typeCode, IIOPOutputStream iIOPOutputStream) {
        iIOPOutputStream.write_long(typeCode.kind().value());
        try {
            switch (typeCode.kind().value()) {
                case 18: 
                case 27: {
                    iIOPOutputStream.write_ulong(0);
                    break;
                }
                case 14: 
                case 32: {
                    long l = iIOPOutputStream.startEncapsulation();
                    iIOPOutputStream.write_string(typeCode.id());
                    iIOPOutputStream.write_string(typeCode.name());
                    iIOPOutputStream.endEncapsulation(l);
                    break;
                }
                case 29: {
                    long l = iIOPOutputStream.startEncapsulation();
                    iIOPOutputStream.write_string(typeCode.id());
                    iIOPOutputStream.write_string(typeCode.name());
                    iIOPOutputStream.write_short(typeCode.type_modifier());
                    iIOPOutputStream.write_TypeCode(typeCode.concrete_base_type());
                    int n = typeCode.member_count();
                    iIOPOutputStream.write_ulong(n);
                    for (int i = 0; i < n; ++i) {
                        iIOPOutputStream.write_string(typeCode.member_name(i));
                        iIOPOutputStream.write_TypeCode(typeCode.member_type(i));
                        iIOPOutputStream.write_short(typeCode.member_visibility(i));
                    }
                    iIOPOutputStream.endEncapsulation(l);
                    break;
                }
                case 16: {
                    long l = iIOPOutputStream.startEncapsulation();
                    iIOPOutputStream.write_string(typeCode.id());
                    iIOPOutputStream.write_string(typeCode.name());
                    iIOPOutputStream.write_TypeCode(typeCode.discriminator_type());
                    int n = typeCode.default_index();
                    iIOPOutputStream.write_long(n);
                    int n2 = typeCode.member_count();
                    iIOPOutputStream.write_ulong(n2);
                    for (int i = 0; i < n2; ++i) {
                        if (i == n) {
                            iIOPOutputStream.write_octet((byte)0);
                        } else {
                            iIOPOutputStream.write_any(typeCode.member_label(i), typeCode.discriminator_type());
                        }
                        iIOPOutputStream.write_string(typeCode.member_name(i));
                        iIOPOutputStream.write_TypeCode(typeCode.member_type(i));
                    }
                    iIOPOutputStream.endEncapsulation(l);
                    break;
                }
                case 17: {
                    long l = iIOPOutputStream.startEncapsulation();
                    iIOPOutputStream.write_string(typeCode.id());
                    iIOPOutputStream.write_string(typeCode.name());
                    int n = typeCode.member_count();
                    iIOPOutputStream.write_ulong(n);
                    for (int i = 0; i < n; ++i) {
                        iIOPOutputStream.write_string(typeCode.member_name(i));
                    }
                    iIOPOutputStream.endEncapsulation(l);
                    break;
                }
                case 15: 
                case 22: {
                    long l = iIOPOutputStream.startEncapsulation();
                    iIOPOutputStream.write_string(typeCode.id());
                    iIOPOutputStream.write_string(typeCode.name());
                    int n = typeCode.member_count();
                    iIOPOutputStream.write_ulong(n);
                    for (int i = 0; i < n; ++i) {
                        iIOPOutputStream.write_string(typeCode.member_name(i));
                        iIOPOutputStream.write_TypeCode(typeCode.member_type(i));
                    }
                    iIOPOutputStream.endEncapsulation(l);
                    break;
                }
                case 30: {
                    long l = iIOPOutputStream.startEncapsulation();
                    iIOPOutputStream.write_string(typeCode.id());
                    iIOPOutputStream.write_string(typeCode.name());
                    iIOPOutputStream.write_TypeCode(typeCode.content_type());
                    iIOPOutputStream.endEncapsulation(l);
                    break;
                }
                case 19: 
                case 20: {
                    long l = iIOPOutputStream.startEncapsulation();
                    iIOPOutputStream.write_TypeCode(typeCode.content_type());
                    iIOPOutputStream.write_ulong(typeCode.length());
                    iIOPOutputStream.endEncapsulation(l);
                    break;
                }
                case 21: {
                    long l = iIOPOutputStream.startEncapsulation();
                    iIOPOutputStream.write_string(typeCode.id());
                    iIOPOutputStream.write_string(typeCode.name());
                    iIOPOutputStream.write_TypeCode(typeCode.content_type());
                    iIOPOutputStream.endEncapsulation(l);
                    break;
                }
                case 28: {
                    iIOPOutputStream.write_unsigned_short(typeCode.fixed_digits());
                    iIOPOutputStream.write_short(typeCode.fixed_scale());
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    break;
                }
                default: {
                    throw new NO_IMPLEMENT("Unsupported TypeCode: " + typeCode);
                }
            }
        }
        catch (BadKind badKind) {
            throw new MARSHAL("Invalid TypeCode: " + typeCode);
        }
        catch (Bounds bounds) {
            throw new MARSHAL("Invalid TypeCode: " + typeCode);
        }
    }

    public static TypeCode get_primitive_tc(TCKind tCKind) {
        return simpleTypes[tCKind.value()];
    }

    public static TypeCode get_primitive_tc(int n) {
        return simpleTypes[n];
    }

    public static TypeCode create_struct_tc(int n, String string, String string2, StructMember[] structMemberArray) {
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(n, new RepositoryId(string), string2);
        typeCodeImpl.members = new MemberInfo[structMemberArray.length];
        for (int i = 0; i < typeCodeImpl.members.length; ++i) {
            typeCodeImpl.members[i] = new MemberInfo();
            typeCodeImpl.members[i].name = structMemberArray[i].name;
            typeCodeImpl.members[i].type = structMemberArray[i].type;
        }
        return typeCodeImpl;
    }

    public static TypeCode create_union_tc(String string, String string2, TypeCode typeCode, UnionMember[] unionMemberArray) {
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(16, new RepositoryId(string), string2, typeCode);
        typeCodeImpl.members = new MemberInfo[unionMemberArray.length];
        for (int i = 0; i < typeCodeImpl.members.length; ++i) {
            typeCodeImpl.members[i] = new MemberInfo();
            typeCodeImpl.members[i].label = unionMemberArray[i].label;
            typeCodeImpl.members[i].name = unionMemberArray[i].name;
            typeCodeImpl.members[i].type = unionMemberArray[i].type;
        }
        return typeCodeImpl;
    }

    public static TypeCode create_enum_tc(String string, String string2, String[] stringArray) {
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(17, new RepositoryId(string), string2);
        typeCodeImpl.members = new MemberInfo[stringArray.length];
        for (int i = 0; i < typeCodeImpl.members.length; ++i) {
            typeCodeImpl.members[i] = new MemberInfo();
            typeCodeImpl.members[i].name = stringArray[i];
        }
        return typeCodeImpl;
    }

    public static TypeCode create_string_tc(int n) {
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(18);
        typeCodeImpl.length = n;
        return typeCodeImpl;
    }

    public static TypeCode create_wstring_tc(int n) {
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(27);
        typeCodeImpl.length = n;
        return typeCodeImpl;
    }

    public static TypeCode create_sequence_tc(int n, TypeCode typeCode) {
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(19);
        typeCodeImpl.length = n;
        typeCodeImpl.content_type = typeCode;
        return typeCodeImpl;
    }

    public static TypeCode create_array_tc(int n, TypeCode typeCode) {
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(20);
        typeCodeImpl.length = n;
        typeCodeImpl.content_type = typeCode;
        return typeCodeImpl;
    }

    public static TypeCode create_fixed_tc(short s, short s2) {
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(28);
        typeCodeImpl.digits = s;
        typeCodeImpl.scale = s2;
        return typeCodeImpl;
    }

    public static TypeCode create_value_tc(String string, String string2, short s, TypeCode typeCode, ValueMember[] valueMemberArray) {
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(29, new RepositoryId(string), string2, typeCode);
        typeCodeImpl.members = new MemberInfo[valueMemberArray.length];
        for (int i = 0; i < typeCodeImpl.members.length; ++i) {
            typeCodeImpl.members[i] = new MemberInfo();
            typeCodeImpl.members[i].access = valueMemberArray[i].access;
            typeCodeImpl.members[i].name = valueMemberArray[i].name;
            typeCodeImpl.members[i].type = valueMemberArray[i].type;
        }
        return typeCodeImpl;
    }

    public String toString() {
        return TypeCodeImpl.toString(this.type) + (this.repid == null ? "<simple>" : this.repid.toString());
    }

    public static String toString(TCKind tCKind) {
        String string;
        switch (tCKind.value()) {
            case 14: {
                string = "_tk_objref";
                break;
            }
            case 32: {
                string = "_tk_abstract_interface";
                break;
            }
            case 29: {
                string = "_tk_value";
                break;
            }
            case 30: {
                string = "_tk_value_box";
                break;
            }
            case 18: {
                string = "_tk_string";
                break;
            }
            case 27: {
                string = "_tk_wstring";
                break;
            }
            case 19: {
                string = "_tk_sequence";
                break;
            }
            case 20: {
                string = "_tk_array";
                break;
            }
            case 21: {
                string = "_tk_alias";
                break;
            }
            case 3: {
                string = "_tk_long";
                break;
            }
            case 23: {
                string = "_tk_longlong";
                break;
            }
            case 5: {
                string = "_tk_ulong";
                break;
            }
            case 24: {
                string = "_tk_ulonglong";
                break;
            }
            case 11: {
                string = "_tk_any";
                break;
            }
            case 0: {
                string = "_tk_null";
                break;
            }
            case 22: {
                string = "_tk_except";
                break;
            }
            case 15: {
                string = "_tk_struct";
                break;
            }
            case 16: {
                string = "_tk_union";
                break;
            }
            default: {
                string = "" + tCKind.value();
            }
        }
        return "TCKind<" + string + ">: ";
    }

    private static void p(String string) {
        System.out.println("<TypeCodeImpl> " + string);
    }

    private static final class MemberInfo {
        private String name;
        private TypeCode type;
        private short access;
        private Any label;

        private MemberInfo() {
        }
    }
}

