/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.idl.poa;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA_2_3.portable.ObjectImpl;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableServer.AdapterActivator;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicy;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicy;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.NoServant;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicy;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicy;
import org.omg.PortableServer.ThreadPolicyValue;
import org.omg.PortableServer.portable.Delegate;
import weblogic.corba.idl.DelegateFactory;
import weblogic.corba.idl.poa.IdAssignmentPolicyImpl;
import weblogic.corba.idl.poa.IdUniquenessPolicyImpl;
import weblogic.corba.idl.poa.ImplicitActivationPolicyImpl;
import weblogic.corba.idl.poa.LifespanPolicyImpl;
import weblogic.corba.idl.poa.POADelegateImpl;
import weblogic.corba.idl.poa.POAManagerImpl;
import weblogic.corba.idl.poa.POAServerRef;
import weblogic.corba.idl.poa.PolicyImpl;
import weblogic.corba.idl.poa.RequestProcessingPolicyImpl;
import weblogic.corba.idl.poa.ServantRetentionPolicyImpl;
import weblogic.corba.idl.poa.ThreadPolicyImpl;
import weblogic.corba.utils.RemoteInfo;
import weblogic.corba.utils.RepositoryId;
import weblogic.iiop.IIOPReplacer;
import weblogic.iiop.IOR;
import weblogic.iiop.ObjectKey;
import weblogic.iiop.ProtocolHandlerIIOP;
import weblogic.iiop.spi.IORDelegate;
import weblogic.jndi.Environment;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelManager;
import weblogic.rmi.cluster.ClusterableActivatableServerRef;
import weblogic.rmi.extensions.server.ActivatableServerReference;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.internal.ServerReference;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityManager;
import weblogic.utils.Debug;
import weblogic.utils.collections.NumericKeyHashMap;

public class POAImpl
extends ObjectImpl
implements POA,
PolicyFactory {
    private static final boolean DEBUG = false;
    private static int nextOID = 0;
    private static final int POFF = 16;
    private final String name;
    private final int[] policyValues = new int[8];
    private final HashMap children = new HashMap();
    private final HashMap aom = new HashMap();
    private final HashMap asm = new HashMap();
    private final NumericKeyHashMap policies = new NumericKeyHashMap();
    private final POA parent;
    private final POAManager manager;
    private Servant defaultServant;
    private ServantManager servantManager;
    private int objectId = -1;
    private String applicationName;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public POAImpl(String string) {
        this.name = string;
        this.parent = null;
        this.manager = new POAManagerImpl(this.composeName());
        this.setDefaultPolicies();
    }

    public POAImpl(String string, Policy[] policyArray, POA pOA, POAManager pOAManager) throws InvalidPolicy {
        this.name = string;
        this.parent = pOA;
        this.manager = pOAManager == null ? new POAManagerImpl(this.composeName()) : pOAManager;
        this.setDefaultPolicies();
        for (int i = 0; i < policyArray.length; ++i) {
            PolicyImpl policyImpl = (PolicyImpl)policyArray[i];
            if (policyImpl.policy_type() < 16 || policyImpl.policy_type() > 24) {
                this.policies.put((long)policyImpl.policy_type(), (java.lang.Object)policyImpl);
                continue;
            }
            this.setPolicy(policyImpl.policy_type(), policyImpl.policy_value());
        }
    }

    private void setPolicy(int n, int n2) throws InvalidPolicy {
        if (n < 16 || n > 24) {
            throw new InvalidPolicy();
        }
        this.policyValues[n - 16] = n2;
    }

    private int getPolicy(int n) {
        Debug.assertion((n >= 16 && n < 24 ? 1 : 0) != 0);
        return this.policyValues[n - 16];
    }

    private void setDefaultPolicies() {
        try {
            this.setPolicy(16, 0);
            this.setPolicy(17, 0);
            this.setPolicy(18, 0);
            this.setPolicy(19, 1);
            this.setPolicy(21, 0);
            this.setPolicy(22, 0);
            this.setPolicy(20, 0);
        }
        catch (InvalidPolicy invalidPolicy) {
            // empty catch block
        }
    }

    public byte[] id() {
        return POAHelper.id().getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy(boolean bl, boolean bl2) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            HashMap hashMap2 = (HashMap)this.children.clone();
            Iterator object = hashMap2.values().iterator();
            while (object.hasNext()) {
                ((POA)object.next()).destroy(bl, bl2);
            }
        }
        ((POAImpl)this.parent).destroyChild(this.name);
        hashMap = OIDManager.getInstance().getServerReference((java.lang.Object)this);
        OIDManager.getInstance().removeServerReference((ServerReference)hashMap);
        if (KernelStatus.isServer() && hashMap.getDescriptor().isClusterable()) {
            try {
                SecurityManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public java.lang.Object run() throws NamingException {
                        Environment environment = new Environment();
                        environment.setCreateIntermediateContexts(true);
                        environment.getInitialContext().unbind(POAImpl.this.composeName() + "/thePOA");
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (BAD_PARAM)new BAD_PARAM(privilegedActionException.getException().getMessage(), 1330446346, CompletionStatus.COMPLETED_NO).initCause((Throwable)privilegedActionException.getException());
            }
        }
        if (this.servantManager instanceof ServantActivator) {
            for (Map.Entry entry : this.aom.entrySet()) {
                ((ServantActivator)this.servantManager).etherealize(((String)entry.getKey()).getBytes(), (POA)this, (Servant)entry.getValue(), bl, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyChild(String string) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            if (this.children.remove(string) == null) {
                throw new BAD_PARAM(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate_object(byte[] byArray) throws ObjectNotActive, WrongPolicy {
        HashMap hashMap = this.aom;
        synchronized (hashMap) {
            Servant servant = (Servant)this.aom.remove(new String(byArray, 0));
            if (servant == null) {
                throw new ObjectNotActive();
            }
            this.asm.remove(servant);
            if (this.servantManager instanceof ServantActivator) {
                ((ServantActivator)this.servantManager).etherealize(byArray, (POA)this, servant, false, false);
            }
        }
    }

    public String the_name() {
        return this.name;
    }

    public byte[] reference_to_id(Object object) throws WrongAdapter, WrongPolicy {
        if (!(object instanceof ObjectImpl)) {
            throw new WrongAdapter("Not an ObjectImpl");
        }
        ObjectImpl objectImpl = (ObjectImpl)object;
        org.omg.CORBA.portable.Delegate delegate = objectImpl._get_delegate();
        if (!(delegate instanceof IORDelegate)) {
            throw new WrongAdapter("Not an IORDelegate");
        }
        ObjectKey objectKey = ((IORDelegate)delegate).getIOR().getProfile().getObjectKey();
        if (objectKey.getObjectID() != this.objectId || objectKey.getActivationID() == null) {
            throw new WrongAdapter("Wrong Object Key");
        }
        return (byte[])objectKey.getActivationID();
    }

    public Object id_to_reference(byte[] byArray) throws ObjectNotActive, WrongPolicy {
        HashMap hashMap = this.aom;
        synchronized (hashMap) {
            Servant servant = (Servant)this.aom.get(new String(byArray, 0));
            if (servant == null) {
                throw new ObjectNotActive("No active object: " + new String(byArray, 0));
            }
            try {
                return IIOPReplacer.makeInvocationHandler((IOR)IIOPReplacer.getReplacer().replaceObject((java.lang.Object)servant));
            }
            catch (IOException iOException) {
                throw (INTERNAL)new INTERNAL("id_to_reference()").initCause((Throwable)iOException);
            }
        }
    }

    public AdapterActivator the_activator() {
        throw new NO_IMPLEMENT("the_activator");
    }

    public void the_activator(AdapterActivator adapterActivator) {
        throw new NO_IMPLEMENT("the_activator");
    }

    public POAManager the_POAManager() {
        return this.manager;
    }

    public Servant get_servant() throws NoServant, WrongPolicy {
        if (this.defaultServant == null) {
            throw new NoServant();
        }
        if (this.getPolicy(22) != 1) {
            throw new WrongPolicy("RequestProcessingPolicyValue: " + this.getPolicy(22));
        }
        return this.defaultServant;
    }

    public void set_servant(Servant servant) throws WrongPolicy {
        if (this.getPolicy(22) != 1) {
            throw new WrongPolicy("RequestProcessingPolicyValue: " + this.getPolicy(22));
        }
        this.defaultServant = servant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] activate_object(Servant servant) throws ServantAlreadyActive, WrongPolicy {
        HashMap hashMap = this.aom;
        synchronized (hashMap) {
            if (this.getPolicy(18) == 0 && this.aom.containsValue(servant)) {
                throw new ServantAlreadyActive();
            }
            if (this.getPolicy(19) != 1 || this.getPolicy(21) != 0) {
                throw new WrongPolicy();
            }
            String string = Integer.toString(this.getNextObjectID());
            servant._set_delegate(this.createDelegate(servant, string.getBytes()));
            this.aom.put(string, servant);
            this.asm.put(servant, string);
            return string.getBytes();
        }
    }

    public synchronized int getNextObjectID() {
        return ++nextOID;
    }

    public byte[] servant_to_id(Servant servant) throws ServantNotActive, WrongPolicy {
        if (this.getPolicy(22) != 1 && (this.getPolicy(21) != 0 || this.getPolicy(18) != 0 && this.getPolicy(20) != 0)) {
            throw new WrongPolicy("servant_to_id()");
        }
        HashMap hashMap = this.aom;
        synchronized (hashMap) {
            String string;
            if (this.getPolicy(18) == 0 && (string = (String)this.asm.get(servant)) != null) {
                return string.getBytes();
            }
            if (this.getPolicy(20) == 0 && (this.getPolicy(18) == 1 || this.asm.get(servant) == null)) {
                try {
                    return this.activate_object(servant);
                }
                catch (ServantAlreadyActive servantAlreadyActive) {
                    throw (AssertionError)((java.lang.Object)((Throwable)((java.lang.Object)new AssertionError())).initCause(servantAlreadyActive));
                }
            }
            if (this.getPolicy(22) == 1 && this.defaultServant != null && servant.equals(this.defaultServant)) {
                throw new NO_IMPLEMENT("servant_to_id()");
            }
            throw new ServantNotActive("servant_to_id: " + servant.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servant id_to_servant(byte[] byArray) throws ObjectNotActive, WrongPolicy {
        if (this.getPolicy(21) == 0) {
            HashMap hashMap = this.aom;
            synchronized (hashMap) {
                Servant servant = (Servant)this.aom.get(new String(byArray, 0));
                if (servant == null) {
                    if (this.getPolicy(22) == 2) {
                        try {
                            servant = ((ServantActivator)this.servantManager).incarnate(byArray, (POA)this);
                        }
                        catch (ForwardRequest forwardRequest) {
                            throw new NO_IMPLEMENT("ForwardRequest");
                        }
                    } else {
                        throw new ObjectNotActive(new String(byArray, 0));
                    }
                }
                return servant;
            }
        }
        if (this.getPolicy(22) == 1) {
            if (this.defaultServant == null) {
                throw new ObjectNotActive("No default Servant registered");
            }
            return this.defaultServant;
        }
        throw new WrongPolicy("Neither RETAIN or USE_DEFAULT_SERVANT were specified");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate_object_with_id(byte[] byArray, Servant servant) throws ServantAlreadyActive, ObjectAlreadyActive, WrongPolicy {
        HashMap hashMap = this.aom;
        synchronized (hashMap) {
            String string = new String(byArray, 0);
            if (this.getPolicy(18) == 0 && this.aom.get(string) != null) {
                throw new ServantAlreadyActive();
            }
            if (this.aom.containsValue(servant)) {
                throw new ObjectAlreadyActive();
            }
            if (this.getPolicy(21) != 0) {
                throw new WrongPolicy();
            }
            servant._set_delegate(this.createDelegate(servant, byArray));
            this.aom.put(string, servant);
            this.asm.put(servant, string);
        }
    }

    private Delegate createDelegate(Servant servant, byte[] byArray) {
        String string = servant._all_interfaces((POA)this, byArray)[0];
        ServerChannel serverChannel = ServerChannelManager.findLocalServerChannel((Protocol)ProtocolHandlerIIOP.PROTOCOL_IIOP);
        String string2 = serverChannel.getPublicAddress();
        int n = serverChannel.getPublicPort();
        ObjectKey objectKey = new ObjectKey(string, this.objectId, byArray);
        RepositoryId repositoryId = new RepositoryId(string);
        RemoteInfo remoteInfo = RemoteInfo.findRemoteInfo(repositoryId, servant.getClass());
        return new POADelegateImpl(this, remoteInfo.getDescriptor() != null ? new IOR(string, string2, n, objectKey, null, null, remoteInfo.getDescriptor()) : new IOR(string, string2, n, objectKey, null, null, this.policies), remoteInfo, byArray);
    }

    private IOR createIOR(String string, byte[] byArray) {
        ServerChannel serverChannel = ServerChannelManager.findLocalServerChannel((Protocol)ProtocolHandlerIIOP.PROTOCOL_IIOP);
        String string2 = serverChannel.getPublicAddress();
        int n = serverChannel.getPublicPort();
        ObjectKey objectKey = new ObjectKey(string, this.objectId, byArray);
        return new IOR(string, string2, n, objectKey, null, null, this.policies);
    }

    public ServantManager get_servant_manager() throws WrongPolicy {
        if (this.getPolicy(22) != 2) {
            throw new WrongPolicy("RequestProcessingPolicyValue: " + this.getPolicy(22));
        }
        return this.servantManager;
    }

    public void set_servant_manager(ServantManager servantManager) throws WrongPolicy {
        if (this.servantManager != null) {
            throw new BAD_INV_ORDER("ServantManager already set");
        }
        if (servantManager == null || this.getPolicy(21) == 0 && !(servantManager instanceof ServantActivator) || this.getPolicy(21) != 0 && !(servantManager instanceof ServantLocator)) {
            throw new OBJ_ADAPTER("Wrong ServantManager");
        }
        if (this.getPolicy(22) != 2) {
            throw new WrongPolicy("RequestProcessingPolicyValue: " + this.getPolicy(22));
        }
        this.servantManager = servantManager;
    }

    public ServantManager getServantManager() {
        return this.servantManager;
    }

    public Object create_reference(String string) throws WrongPolicy {
        if (this.getPolicy(19) != 1) {
            throw new WrongPolicy("create_reference() requires SYSTEM_ID");
        }
        byte[] byArray = Integer.toString(this.getNextObjectID()).getBytes();
        IOR iOR = this.createIOR(string, byArray);
        return new IIOPReplacer.AnonymousCORBAStub(string, DelegateFactory.createDelegate(iOR));
    }

    public Object create_reference_with_id(byte[] byArray, String string) {
        if (this.getPolicy(19) == 1) {
            try {
                Integer.parseInt(new String(byArray, 0));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BAD_PARAM("create_reference_with_id() requires system id for SYSTEM_ID");
            }
        }
        IOR iOR = this.createIOR(string, byArray);
        return new IIOPReplacer.AnonymousCORBAStub(string, DelegateFactory.createDelegate(iOR));
    }

    public Object servant_to_reference(Servant servant) throws ServantNotActive, WrongPolicy {
        if (this.getPolicy(21) != 0 || this.getPolicy(18) != 0 && this.getPolicy(20) != 0) {
            throw new WrongPolicy("servant_to_reference()");
        }
        HashMap hashMap = this.aom;
        synchronized (hashMap) {
            if (this.getPolicy(18) == 0 && this.asm.get(servant) != null) {
                return servant._this_object();
            }
            if (this.getPolicy(20) == 0 && (this.getPolicy(18) == 1 || this.asm.get(servant) == null)) {
                try {
                    this.activate_object(servant);
                    return servant._this_object();
                }
                catch (ServantAlreadyActive servantAlreadyActive) {
                    throw (AssertionError)((java.lang.Object)((Throwable)((java.lang.Object)new AssertionError())).initCause(servantAlreadyActive));
                }
            }
            throw new ServantNotActive("servant_to_reference: " + servant.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servant reference_to_servant(Object object) throws ObjectNotActive, WrongPolicy, WrongAdapter {
        if (!(object instanceof ObjectImpl)) {
            throw new WrongAdapter("Not an ObjectImpl");
        }
        ObjectImpl objectImpl = (ObjectImpl)object;
        org.omg.CORBA.portable.Delegate delegate = objectImpl._get_delegate();
        if (!(delegate instanceof IORDelegate)) {
            throw new WrongAdapter("Not an IORDelegate");
        }
        ObjectKey objectKey = ((IORDelegate)delegate).getIOR().getProfile().getObjectKey();
        if (objectKey.getObjectID() != this.objectId || objectKey.getActivationID() == null) {
            throw new WrongAdapter("Wrong Object Key");
        }
        String string = new String((byte[])objectKey.getActivationID(), 0);
        if (this.getPolicy(21) == 0) {
            HashMap hashMap = this.aom;
            synchronized (hashMap) {
                Servant servant = (Servant)this.aom.get(string);
                if (servant == null) {
                    throw new ObjectNotActive(string);
                }
                return servant;
            }
        }
        if (this.getPolicy(22) == 1) {
            if (this.defaultServant == null) {
                throw new ObjectNotActive("No default Servant registered");
            }
            return this.defaultServant;
        }
        throw new WrongPolicy("Neither RETAIN or USE_DEFAULT_SERVANT were specified");
    }

    public POA the_parent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POA[] the_children() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            return this.children.values().toArray(new POA[this.children.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POA create_POA(String string, POAManager pOAManager, Policy[] policyArray) throws AdapterAlreadyExists, InvalidPolicy {
        try {
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                if (this.children.get(string) != null) {
                    throw new AdapterAlreadyExists(string);
                }
                POAImpl pOAImpl = new POAImpl(string, policyArray, this, pOAManager);
                this.children.put(string, pOAImpl);
                return pOAImpl.export();
            }
        }
        catch (IOException iOException) {
            throw (BAD_PARAM)new BAD_PARAM(iOException.getMessage(), 1330446346, CompletionStatus.COMPLETED_NO).initCause((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POA export() throws IOException {
        if (this.objectId < 0) {
            POAImpl pOAImpl = this;
            synchronized (pOAImpl) {
                if (this.objectId < 0) {
                    ActivatableServerReference activatableServerReference = new POAServerRef(this);
                    if (activatableServerReference.getDescriptor().isClusterable()) {
                        activatableServerReference = new ClusterableActivatableServerRef(activatableServerReference);
                    }
                    this.objectId = activatableServerReference.exportObject().getObjectID();
                    if (KernelStatus.isServer() && activatableServerReference.getDescriptor().isClusterable()) {
                        final String string = this.composeName() + "/thePOA";
                        try {
                            SecurityManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                                public java.lang.Object run() throws NamingException {
                                    Environment environment = new Environment();
                                    environment.setCreateIntermediateContexts(true);
                                    environment.getInitialContext().bind(string, (java.lang.Object)this);
                                    return null;
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw (IOException)new IOException(privilegedActionException.getException().getMessage()).initCause(privilegedActionException.getException());
                        }
                        ((ClusterableActivatableServerRef)activatableServerReference).initialize(string);
                    }
                }
            }
        }
        return this;
    }

    private String composeName() {
        if (this.parent == null) {
            return "weblogic/corba/" + this.name;
        }
        return ((POAImpl)this.parent).composeName() + "/" + this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POA find_POA(String string, boolean bl) throws AdapterNonExistent {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            POA pOA = (POA)this.children.get(string);
            if (pOA == null) {
                throw new AdapterNonExistent();
            }
            return pOA;
        }
    }

    public IdAssignmentPolicy create_id_assignment_policy(IdAssignmentPolicyValue idAssignmentPolicyValue) {
        return new IdAssignmentPolicyImpl(idAssignmentPolicyValue.value());
    }

    public IdUniquenessPolicy create_id_uniqueness_policy(IdUniquenessPolicyValue idUniquenessPolicyValue) {
        return new IdUniquenessPolicyImpl(idUniquenessPolicyValue.value());
    }

    public ImplicitActivationPolicy create_implicit_activation_policy(ImplicitActivationPolicyValue implicitActivationPolicyValue) {
        return new ImplicitActivationPolicyImpl(implicitActivationPolicyValue.value());
    }

    public LifespanPolicy create_lifespan_policy(LifespanPolicyValue lifespanPolicyValue) {
        return new LifespanPolicyImpl(lifespanPolicyValue.value());
    }

    public RequestProcessingPolicy create_request_processing_policy(RequestProcessingPolicyValue requestProcessingPolicyValue) {
        return new RequestProcessingPolicyImpl(requestProcessingPolicyValue.value());
    }

    public ServantRetentionPolicy create_servant_retention_policy(ServantRetentionPolicyValue servantRetentionPolicyValue) {
        return new ServantRetentionPolicyImpl(servantRetentionPolicyValue.value());
    }

    public ThreadPolicy create_thread_policy(ThreadPolicyValue threadPolicyValue) {
        return new ThreadPolicyImpl(threadPolicyValue.value());
    }

    public Policy create_policy(int n, Any any) throws PolicyError {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                throw new PolicyError("POA policies are only supported via poa functions", 1);
            }
        }
        return null;
    }

    public boolean equals(java.lang.Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof POAImpl)) {
            return false;
        }
        POAImpl pOAImpl = (POAImpl)((java.lang.Object)object);
        return this.name.equals(pOAImpl.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "POA[" + this.name + ", " + this.objectId + "]";
    }

    public String[] _ids() {
        return new String[]{POAHelper.id()};
    }

    protected static void p(String string) {
        System.out.println("<POAImpl> " + string);
    }
}

