/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.idl.poa;

import org.omg.CORBA_2_3.portable.ObjectImpl;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;
import weblogic.kernel.KernelStatus;
import weblogic.work.ShutdownCallback;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;
import weblogic.work.WorkManagerService;
import weblogic.work.WorkManagerServiceImpl;

class POAManagerImpl
extends ObjectImpl
implements POAManager {
    private State state = State.HOLDING;
    private final WorkManagerService wm;

    public String[] _ids() {
        return new String[]{POAHelper.id()};
    }

    public POAManagerImpl(String string) {
        this.wm = KernelStatus.isServer() ? WorkManagerServiceImpl.createService(string, "POA", "POA") : null;
    }

    public WorkManager getWorkManager() {
        if (KernelStatus.isServer()) {
            return this.wm.getDelegate();
        }
        return WorkManagerFactory.getInstance().getDefault();
    }

    public synchronized void activate() throws AdapterInactive {
        if (this.state.equals(State.INACTIVE)) {
            throw new AdapterInactive("activate()");
        }
        if (this.wm != null) {
            this.wm.start();
        }
        this.state = State.ACTIVE;
    }

    public synchronized void discard_requests(boolean bl) throws AdapterInactive {
        if (this.state.equals(State.INACTIVE)) {
            throw new AdapterInactive("discard_requests()");
        }
        this.state = State.DISCARDING;
    }

    public synchronized void hold_requests(boolean bl) throws AdapterInactive {
        if (this.state.equals(State.INACTIVE)) {
            throw new AdapterInactive("hold_requests()");
        }
        this.state = State.HOLDING;
    }

    public synchronized void deactivate(boolean bl, boolean bl2) throws AdapterInactive {
        if (this.state.equals(State.INACTIVE)) {
            throw new AdapterInactive("deactivate()");
        }
        if (this.wm != null) {
            this.wm.shutdown(new ShutdownCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void completed() {
                    POAManagerImpl pOAManagerImpl = POAManagerImpl.this;
                    synchronized (pOAManagerImpl) {
                        POAManagerImpl.this.state = State.INACTIVE;
                        ((Object)((Object)POAManagerImpl.this)).notify();
                    }
                }
            });
        }
        if (bl2 && this.wm != null) {
            while (this.state != State.INACTIVE) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            this.state = State.INACTIVE;
        }
    }

    public State get_state() {
        return this.state;
    }
}

