/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.idl.poa;

import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.Messaging.RequestEndTimePolicy;
import org.omg.TimeBase.UtcT;
import org.omg.TimeBase.UtcTHelper;
import weblogic.corba.idl.poa.PolicyImpl;
import weblogic.iiop.IIOPInputStream;
import weblogic.iiop.IIOPOutputStream;

public class RequestEndTimePolicyImpl
extends PolicyImpl
implements RequestEndTimePolicy {
    private UtcT endTime;
    public static final long UNITS_PER_MILLI = 10000L;
    private static final long UTCT_DELTA_MILLIS = 12219292800000L;

    public static final long java2Utc(long l) {
        return (l + 12219292800000L) * 10000L;
    }

    public static final long utc2Java(long l) {
        return l / 10000L - 12219292800000L;
    }

    public RequestEndTimePolicyImpl(long l) {
        super(28, 0);
        this.endTime = new UtcT(RequestEndTimePolicyImpl.java2Utc(l), 0, 0, 0);
    }

    public RequestEndTimePolicyImpl(UtcT utcT) {
        super(28, 0);
        this.endTime = new UtcT(utcT.time, utcT.inacclo, utcT.inacchi, utcT.tdf);
    }

    public RequestEndTimePolicyImpl(IIOPInputStream iIOPInputStream) {
        super(28, 0);
        this.read(iIOPInputStream);
    }

    public UtcT end_time() {
        return this.endTime;
    }

    public long endTime() {
        return RequestEndTimePolicyImpl.utc2Java(this.endTime.time);
    }

    public long relativeTimeoutMillis() {
        long l = RequestEndTimePolicyImpl.utc2Java(this.endTime.time) - System.currentTimeMillis();
        return l < 0L ? 0L : l;
    }

    protected void readEncapsulatedPolicy(IIOPInputStream iIOPInputStream) {
        this.endTime = UtcTHelper.read((InputStream)iIOPInputStream);
    }

    protected void writeEncapsulatedPolicy(IIOPOutputStream iIOPOutputStream) {
        UtcTHelper.write((OutputStream)iIOPOutputStream, this.endTime);
    }
}

