/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.iiop.http;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import weblogic.common.internal.VersionInfo;
import weblogic.corba.iiop.http.TunnelUtils;
import weblogic.iiop.Connection;
import weblogic.iiop.ConnectionKey;
import weblogic.iiop.ConnectionManager;
import weblogic.iiop.EndPoint;
import weblogic.iiop.EndPointImpl;
import weblogic.iiop.IIOPLogger;
import weblogic.kernel.KernelStatus;
import weblogic.protocol.AsyncOutgoingMessage;
import weblogic.protocol.ChannelImpl;
import weblogic.protocol.Protocol;
import weblogic.protocol.ServerChannel;
import weblogic.rmi.spi.Channel;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.servlet.internal.ProtocolHandlerHTTP;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.io.Chunk;
import weblogic.work.WorkManagerFactory;

public class HTTPClientConnection
extends Connection
implements Runnable {
    private static final boolean ASSERT = true;
    private static final boolean DEBUG = false;
    private static final DebugCategory debugTransport = Debug.getCategory((String)"weblogic.iiop.transport");
    private boolean closed;
    private String host;
    private int port;
    private final Protocol protocol;
    private ServerChannel networkChannel;
    private Channel channel;
    private String connectionID = null;
    private EndPoint endPoint = null;
    private ConnectionKey key = null;

    public final ServerChannel getChannel() {
        return this.networkChannel;
    }

    public Channel getRemoteChannel() {
        return this.channel;
    }

    private static String getTunellingURLExtension() {
        return "/a.tun";
    }

    private static Chunk readPacket(InputStream inputStream) throws IOException {
        Chunk chunk;
        Chunk chunk2 = chunk = Chunk.getChunk();
        int n = 0;
        while (true) {
            int n2;
            if (chunk2.end == Chunk.CHUNK_SIZE) {
                chunk2 = chunk2.next = Chunk.getChunk();
            }
            Debug.assertion(((n2 = Chunk.CHUNK_SIZE - chunk2.end) > 0 ? 1 : 0) != 0);
            int n3 = inputStream.read(chunk2.buf, chunk2.end, n2);
            if (n3 == -1) break;
            n += n3;
            chunk2.end += n3;
        }
        inputStream.close();
        Debug.assertion((n > 12 ? 1 : 0) != 0);
        return chunk;
    }

    public static Connection createConnection(InetAddress inetAddress, int n, ServerChannel serverChannel) throws IOException {
        HTTPClientConnection hTTPClientConnection = new HTTPClientConnection(serverChannel);
        hTTPClientConnection.connect(inetAddress, n);
        WorkManagerFactory.getInstance().getSystem().schedule((Runnable)hTTPClientConnection);
        return hTTPClientConnection;
    }

    HTTPClientConnection(ServerChannel serverChannel) {
        this.networkChannel = serverChannel;
        this.closed = true;
        this.protocol = ProtocolHandlerHTTP.PROTOCOL_HTTP;
    }

    URLConnection createURLConnection(URL uRL) throws IOException {
        return uRL.openConnection();
    }

    public final String toString() {
        return super.toString() + " - id: '" + this.connectionID + "', host: '" + this.host + "', port: '" + this.port + " closed: '" + this.closed + "'";
    }

    public final Protocol getProtocol() {
        return this.protocol;
    }

    public final InetAddress getLocalAddress() {
        return null;
    }

    public final int getLocalPort() {
        return -1;
    }

    final Socket getSocket() {
        return null;
    }

    private final String getRequestArgs() {
        return "?connectionID=" + this.connectionID + "&rand=" + TunnelUtils.getNextRandom();
    }

    private final void handleNullResponse(URLConnection uRLConnection) throws ProtocolException {
        if (debugTransport.isEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (true) {
                String string = uRLConnection.getHeaderFieldKey(n);
                String string2 = uRLConnection.getHeaderField(n);
                if (string == null && string2 == null) break;
                stringBuffer.append('\t');
                stringBuffer.append(n);
                stringBuffer.append(") ");
                stringBuffer.append(string);
                stringBuffer.append(": ");
                stringBuffer.append(string2);
                stringBuffer.append('\n');
                ++n;
            }
            IIOPLogger.logDebugTransport((String)("Result unspecified - tunneled connection: '" + uRLConnection + "', headers:\n" + stringBuffer));
        }
        throw new ProtocolException("Tunneling result unspecified - is the HTTP server at host: '" + this.host + "' and port: '" + this.port + "' a WebLogic Server?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void connect(InetAddress inetAddress, int n) throws IOException {
        if (!this.closed) {
            throw new ProtocolException("Already connected");
        }
        this.host = null;
        this.port = n;
        this.host = inetAddress.getHostName();
        String string = URLEncoder.encode(this.getProtocol().getProtocolName() + " dummy WLREQS " + VersionInfo.theOne().getReleaseVersion() + " dummy \n");
        URL uRL = new URL(this.getProtocol().getProtocolName(), this.host, n, KernelStatus.getTunellingURL((String)"/bea_wls_internal/iiop/ClientLogin") + HTTPClientConnection.getTunellingURLExtension() + "?wl-login=" + string + "&rand=" + TunnelUtils.getNextRandom() + "&" + "HL" + "=" + 12);
        URLConnection uRLConnection = null;
        try {
            uRLConnection = this.createURLConnection(uRL);
        }
        catch (IOException iOException) {
            IIOPLogger.logDebugTransport((String)iOException.getMessage());
            return;
        }
        uRLConnection.setUseCaches(false);
        InputStream inputStream = null;
        try {
            inputStream = uRLConnection.getInputStream();
            String string2 = uRLConnection.getHeaderField("WL-Result");
            if (string2 == null) {
                this.handleNullResponse(uRLConnection);
            }
            if (!string2.equals("OK")) {
                throw new ProtocolException("Tunneling result not OK, result: '" + string2 + "'");
            }
            String string3 = uRLConnection.getHeaderField("WL-Version");
            this.connectionID = uRLConnection.getHeaderField("Conn-Id");
            if (this.connectionID == null) {
                throw new ProtocolException("Tunneling could not ascertain a connection ID from the server");
            }
            TunnelUtils.readConnectionParams(new DataInputStream(inputStream));
            this.closed = false;
        }
        finally {
            TunnelUtils.drainStream(inputStream);
        }
        if (debugTransport.isEnabled()) {
            IIOPLogger.logDebugTransport((String)("tunneled connect() succesful to host: '" + this.host + "' port: '" + n + "' connectionID: '" + this.connectionID + "'"));
        }
        this.key = new ConnectionKey(inetAddress.getHostAddress(), n);
        this.channel = new ChannelImpl(this.host, n, this.protocol.getProtocolName());
    }

    public synchronized void run() {
        try {
            while (!this.closed) {
                this.receiveAndDispatch();
            }
            return;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            ConnectionManager.getConnectionManager().gotExceptionReceiving(this, throwable);
            this.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send(AsyncOutgoingMessage asyncOutgoingMessage) throws IOException {
        if (this.closed) {
            throw new IOException("Connection closed");
        }
        URL uRL = new URL(this.getProtocol().getProtocolName(), this.host, this.port, KernelStatus.getTunellingURL((String)"/bea_wls_internal/iiop/ClientSend") + HTTPClientConnection.getTunellingURLExtension() + this.getRequestArgs());
        URLConnection uRLConnection = this.createURLConnection(uRL);
        uRLConnection.setUseCaches(false);
        InputStream inputStream = null;
        try {
            uRLConnection.setDoOutput(true);
            OutputStream outputStream = uRLConnection.getOutputStream();
            asyncOutgoingMessage.writeTo(outputStream);
            outputStream.flush();
            inputStream = uRLConnection.getInputStream();
            String string = uRLConnection.getHeaderField("WL-Result");
            try {
                if (string == null) {
                    this.handleNullResponse(uRLConnection);
                }
                if (!string.equals("OK")) {
                    throw new ProtocolException("Tunneling result not OK, result: '" + string + "', id: '" + this.connectionID + "'");
                }
            }
            catch (ProtocolException protocolException) {
                if (debugTransport.isEnabled()) {
                    IIOPLogger.logDebugTransport((String)("Problem sending tunneled message: '" + asyncOutgoingMessage + protocolException.getMessage()));
                }
                throw protocolException;
            }
        }
        catch (Throwable throwable) {
            TunnelUtils.drainStream(inputStream);
            throw throwable;
        }
        TunnelUtils.drainStream(inputStream);
    }

    public final boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        if (this.isClosed()) {
            return;
        }
        HTTPClientConnection hTTPClientConnection = this;
        synchronized (hTTPClientConnection) {
            block6: {
                try {
                    this.close0();
                }
                catch (IOException iOException) {
                    if (!debugTransport.isEnabled()) break block6;
                    IIOPLogger.logDebugTransport((String)("Problem closing tunneled connection id: '" + this.connectionID + "'" + iOException.getMessage()));
                }
            }
        }
    }

    private final void close0() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        if (debugTransport.isEnabled()) {
            IIOPLogger.logDebugTransport((String)("Closing tunneled connection id: '" + this.connectionID + "'"));
        }
    }

    private final synchronized void receiveAndDispatch() throws IOException {
        if (this.closed) {
            return;
        }
        InputStream inputStream = null;
        String string = null;
        while (!this.closed) {
            URL uRL = new URL(this.getProtocol().getProtocolName(), this.host, this.port, KernelStatus.getTunellingURL((String)"/bea_wls_internal/iiop/ClientRecv") + HTTPClientConnection.getTunellingURLExtension() + this.getRequestArgs());
            URLConnection uRLConnection = this.createURLConnection(uRL);
            uRLConnection.setUseCaches(false);
            inputStream = uRLConnection.getInputStream();
            string = uRLConnection.getHeaderField("WL-Result");
            if (string == null) {
                this.handleNullResponse(uRLConnection);
            }
            if (string.equals("RETRY")) {
                inputStream.close();
                continue;
            }
            if (!string.equals("OK")) {
                throw new ProtocolException("Tunneling result not OK, result: '" + string + "', id: '" + this.connectionID + "'");
            }
            ConnectionManager.getConnectionManager().dispatch(this, HTTPClientConnection.readPacket(inputStream));
        }
        return;
    }

    public final EndPoint getEndPoint() {
        if (this.endPoint == null) {
            this.endPoint = new EndPointImpl(this, ConnectionManager.getConnectionManager());
        }
        return this.endPoint;
    }

    public final ConnectionKey getConnectionKey() {
        return this.key;
    }

    public final void setConnectionKey(ConnectionKey connectionKey) {
        this.key = connectionKey;
    }

    public AuthenticatedSubject getUser() {
        return null;
    }

    public void authenticate(UserInfo userInfo) {
    }

    public Object getTxContext() {
        return null;
    }

    public void setTxContext(Object object) {
    }

    protected final boolean isSecure() {
        return false;
    }

    private static final void p(String string) {
        System.out.println("<HTTPClientConnection>: " + string);
    }
}

