/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.iiop.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.security.AccessController;
import java.util.StringTokenizer;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.corba.iiop.http.Utils;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.iiop.Connection;
import weblogic.iiop.ConnectionKey;
import weblogic.iiop.ConnectionManager;
import weblogic.iiop.EndPoint;
import weblogic.iiop.EndPointImpl;
import weblogic.iiop.EndPointManager;
import weblogic.iiop.IIOPLogger;
import weblogic.management.configuration.ServerDebugMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.SocketRuntime;
import weblogic.protocol.AsyncOutgoingMessage;
import weblogic.protocol.ChannelImpl;
import weblogic.protocol.MessageReceiverStatistics;
import weblogic.protocol.MessageSenderStatistics;
import weblogic.protocol.ServerChannel;
import weblogic.rmi.spi.Channel;
import weblogic.security.acl.UserInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.channels.ServerChannelImpl;
import weblogic.server.channels.ServerConnectionRuntimeImpl;
import weblogic.server.channels.SocketRuntimeImpl;
import weblogic.servlet.FutureServletResponse;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.collections.CircularQueue;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.utils.io.Chunk;
import weblogic.work.WorkManagerFactory;

class ServerConnection
extends Connection
implements MessageSenderStatistics,
MessageReceiverStatistics {
    private static final boolean DEBUG = false;
    private static final boolean ASSERT = true;
    private static final DebugCategory debugTransport = Debug.getCategory((String)"weblogic.iiop.transport");
    private static final DebugLogger debugIIOPTunneling = DebugLogger.getDebugLogger((String)"DebugIIOPTunneling");
    private static ServerDebugMBean debugBean;
    private ServerChannel networkChannel;
    private SocketRuntime sockRuntime;
    private ConnectionKey key = null;
    private static final ConcurrentHashMap channelOpenSocksMap;
    private static long idCount;
    private final String sockID = ServerConnection.getNextID();
    private final CircularQueue queue = new CircularQueue();
    private FutureServletResponse pending;
    private HttpServletRequest pendingRequest;
    private long lastRecv;
    private boolean closed;
    private Channel channel;
    private long messagesSent = 0L;
    private long bytesSent = 0L;
    private final long connectTime = System.currentTimeMillis();
    private long messagesReceived = 0L;
    private long bytesReceived = 0L;

    private static void initialize(ServerChannel serverChannel) {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        debugBean = ManagementService.getRuntimeAccess(authenticatedSubject).getServer().getServerDebug();
        try {
            TunnelScavenger tunnelScavenger = new TunnelScavenger(serverChannel);
            TimerManager timerManager = TimerManagerFactory.getTimerManagerFactory().getTimerManager(ServerConnection.class.getName(), WorkManagerFactory.getInstance().getSystem());
            timerManager.scheduleAtFixedRate((TimerListener)tunnelScavenger, 0L, (long)(serverChannel.getTunnelingClientTimeoutSecs() * 1000));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IIOPLogger.logScavengeCreateFailure((Exception)illegalArgumentException);
        }
        catch (IllegalStateException illegalStateException) {
            IIOPLogger.logScavengeCreateFailure((Exception)illegalStateException);
        }
    }

    private static synchronized String getNextID() {
        return String.valueOf(idCount++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String acceptConnection(HttpServletRequest httpServletRequest, int n, HttpServletResponse httpServletResponse) throws ProtocolException {
        String string;
        StringTokenizer stringTokenizer;
        ServletRequestImpl servletRequestImpl = (ServletRequestImpl)httpServletRequest;
        ServerChannel serverChannel = servletRequestImpl.getConnection().getChannel();
        String string2 = httpServletRequest.getScheme();
        if (!serverChannel.isTunnelingEnabled()) {
            throw new ProtocolException("HTTP tunneling is disabled for channel " + serverChannel.getChannelName());
        }
        ServerConnection serverConnection = null;
        SocketRuntimeImpl socketRuntimeImpl = new SocketRuntimeImpl(servletRequestImpl.getConnection().getSocketRuntime());
        if (!"http".equalsIgnoreCase(string2) && !"https".equalsIgnoreCase(string2)) {
            throw new ProtocolException("Unknown protocol: '" + string2 + "'");
        }
        serverConnection = new ServerConnection(n, serverChannel, socketRuntimeImpl);
        String string3 = httpServletRequest.getHeader("WL-Client-Address");
        if (string3 != null) {
            stringTokenizer = new StringTokenizer(string3, ":");
            string = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            ConnectionKey connectionKey = new ConnectionKey(string, n2);
            serverConnection.setConnectionKey(connectionKey);
            EndPoint endPoint = EndPointManager.findEndPoint(connectionKey);
            if (endPoint != null) {
                ServerConnection serverConnection2 = (ServerConnection)endPoint.getConnection();
                String string4 = "Closing HTTP tunneling connection: '" + serverConnection2 + "' because  a new connection request: '" + serverConnection + " came in.";
                ConnectionManager.getConnectionManager().gotExceptionReceiving(serverConnection2, new IOException(string4));
            }
            try {
                EndPointManager.findOrCreateEndPoint(serverConnection);
            }
            catch (IOException iOException) {}
        } else {
            serverConnection.setConnectionKey(new ConnectionKey(servletRequestImpl.getConnection().getSocket().getInetAddress().getHostAddress(), Integer.parseInt(serverConnection.sockID)));
        }
        serverConnection.channel = new ChannelImpl(servletRequestImpl.getConnection().getSocket().getInetAddress().getHostAddress(), Integer.parseInt(serverConnection.sockID), string2);
        stringTokenizer = (ConcurrentHashMap)channelOpenSocksMap.get((Object)serverChannel);
        if (stringTokenizer == null) {
            string = channelOpenSocksMap;
            synchronized (string) {
                stringTokenizer = (ConcurrentHashMap)channelOpenSocksMap.get((Object)serverChannel);
                if (stringTokenizer == null) {
                    ServerConnection.initialize(serverChannel);
                    stringTokenizer = new ConcurrentHashMap();
                    channelOpenSocksMap.put((Object)serverChannel, (Object)stringTokenizer);
                }
            }
        }
        stringTokenizer.put(serverConnection.sockID, serverConnection);
        if (debugTransport.isEnabled() || debugIIOPTunneling.isDebugEnabled() || debugBean.getDebugTunnelingConnection()) {
            IIOPLogger.logDebugTransport((String)("Opened tunneled connection - id: '" + serverConnection.sockID + "', keyed on: " + serverConnection.getConnectionKey()));
        }
        return serverConnection.sockID;
    }

    static ServerConnection findByID(String string) {
        for (ConcurrentHashMap concurrentHashMap : channelOpenSocksMap.values()) {
            if (!concurrentHashMap.containsKey((Object)string)) continue;
            return (ServerConnection)concurrentHashMap.get((Object)string);
        }
        return null;
    }

    private Chunk readPacket(HttpServletRequest httpServletRequest) throws IOException {
        Chunk chunk;
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        Chunk chunk2 = chunk = Chunk.getChunk();
        int n = 0;
        chunk2.end = 0;
        chunk2.next = null;
        while (true) {
            int n2;
            int n3;
            if (chunk2.end == Chunk.CHUNK_SIZE) {
                chunk2 = chunk2.next = Chunk.getChunk();
                chunk2.end = 0;
                chunk2.next = null;
            }
            Debug.assertion(((n3 = Chunk.CHUNK_SIZE - chunk2.end) > 0 ? 1 : 0) != 0);
            try {
                n2 = servletInputStream.read(chunk2.buf, chunk2.end, n3);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (debugTransport.isEnabled() || debugIIOPTunneling.isDebugEnabled()) {
                    IIOPLogger.logDebugTransport((String)("Problem reading tunneled packet - nread: '" + n + "' content-length: '" + httpServletRequest.getContentLength() + "'" + interruptedIOException.getMessage()));
                }
                throw interruptedIOException;
            }
            if (n2 == -1) break;
            n += n2;
            chunk2.end += n2;
        }
        servletInputStream.close();
        this.bytesReceived += (long)n;
        if (n < 12) {
            throw new ProtocolException("Fewer than: '12' bytes read - nread: '" + n + "', content-length: '" + httpServletRequest.getContentLength() + "', method: '" + httpServletRequest.getMethod() + "', uri: '" + httpServletRequest.getRequestURI() + "', path info: '" + httpServletRequest.getPathInfo() + "', query params: '" + httpServletRequest.getQueryString() + "'");
        }
        return chunk;
    }

    private static int toInt(int n) {
        return n & 0xFF;
    }

    ServerConnection(int n, ServerChannel serverChannel, SocketRuntime socketRuntime) {
        this.networkChannel = serverChannel;
        this.closed = false;
        this.lastRecv = System.currentTimeMillis();
        this.sockRuntime = socketRuntime;
        ServerConnectionRuntimeImpl serverConnectionRuntimeImpl = new ServerConnectionRuntimeImpl(this, this, socketRuntime);
        if (serverChannel instanceof ServerChannelImpl && ((ServerChannelImpl)serverChannel).getRuntime() != null) {
            ((ServerChannelImpl)serverChannel).getRuntime().addServerConnectionRuntime(serverConnectionRuntimeImpl);
        }
    }

    public String toString() {
        return super.toString() + " - id: '" + this.sockID + "', closed: '" + this.closed + "', lastRecv: '" + this.lastRecv + "'";
    }

    private final void p(String string) {
        System.out.println("<ServerConnection> id: '" + this.sockID + "', closed: '" + this.closed + "', lastRecv: '" + this.lastRecv + "': " + string);
    }

    public final ServerChannel getChannel() {
        return this.networkChannel;
    }

    public final Channel getRemoteChannel() {
        return this.channel;
    }

    final int getQueueCount() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void checkIsDead() {
        int n = this.networkChannel.getTunnelingClientTimeoutSecs() * 1000;
        if (n == 0) {
            return;
        }
        long l = System.currentTimeMillis();
        long l2 = l - this.lastRecv;
        if ((long)n >= l2) {
            return;
        }
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)channelOpenSocksMap.get((Object)this.networkChannel);
        if (this.pending == null) {
            concurrentHashMap.remove((Object)this.sockID);
            this.closed = true;
            String string = "Timed out HTTP tunneling connection: '" + this + "' because it had been unavailable for: '" + l2 / 1000L + "' seconds, timeout of: '" + n / 1000 + "' seconds.";
            ConnectionManager.getConnectionManager().gotExceptionReceiving(this, new IOException(string));
            if (debugTransport.isEnabled() || debugIIOPTunneling.isDebugEnabled() || debugBean.getDebugTunnelingConnectionTimeout()) {
                IIOPLogger.logDebugTransport((String)string);
            }
            return;
        }
        try {
            if (debugTransport.isEnabled() || debugIIOPTunneling.isDebugEnabled() || debugBean.getDebugTunnelingConnectionTimeout()) {
                IIOPLogger.logDebugTransport((String)("Pinging HTTP tunneling connection: '" + this + "' because it had been idle for: '" + l2 / 1000L + "' seconds, timeout of: '" + n / 1000 + "' seconds."));
            }
            this.lastRecv = l;
            this.pending.setHeader("WL-Result", "RETRY");
            this.pending.getOutputStream().print("RETRY");
            this.pending.getOutputStream().flush();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                this.pending.send();
            }
            catch (IOException iOException) {}
            this.pendingRequest = null;
            this.pending = null;
        }
    }

    final synchronized AsyncOutgoingMessage getNextMessage() {
        this.lastRecv = System.currentTimeMillis();
        return (AsyncOutgoingMessage)this.queue.remove();
    }

    public final void connect(InetAddress inetAddress, int n) throws IOException {
        throw new ProtocolException("ServerConnection doesn't connect!");
    }

    final synchronized void registerPending(HttpServletRequest httpServletRequest, FutureServletResponse futureServletResponse) throws IOException {
        if (this.closed) {
            try {
                Utils.sendDeadResponse((HttpServletResponse)futureServletResponse);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.lastRecv = System.currentTimeMillis();
        if (this.pending != null && this.pendingRequest != null) {
            String string = this.pendingRequest.getParameter("connectionID");
            String string2 = this.pendingRequest.getParameter("rand");
            if (string != null && string2 != null && string.equals(httpServletRequest.getParameter("connectionID")) && string2.equals(httpServletRequest.getParameter("rand"))) {
                this.pendingRequest = null;
                this.pending = null;
            }
        }
        Debug.assertion((this.pending == null ? 1 : 0) != 0);
        this.pendingRequest = httpServletRequest;
        this.pending = futureServletResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void send(AsyncOutgoingMessage asyncOutgoingMessage) throws IOException {
        if (this.closed) {
            throw new IOException("ServerConnection closed");
        }
        if (this.pending == null) {
            asyncOutgoingMessage.enqueue();
            if (!this.queue.add((Object)asyncOutgoingMessage)) {
                this.close();
                throw new IOException();
            }
            return;
        }
        this.lastRecv = System.currentTimeMillis();
        ++this.messagesSent;
        this.bytesSent += (long)asyncOutgoingMessage.getLength();
        try {
            asyncOutgoingMessage.enqueue();
            Utils.sendResponse((HttpServletResponse)this.pending, asyncOutgoingMessage);
        }
        finally {
            try {
                this.pending.send();
            }
            finally {
                this.pendingRequest = null;
                this.pending = null;
            }
        }
    }

    final void dispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Socket is closed");
        }
        try {
            this.lastRecv = System.currentTimeMillis();
            ++this.messagesReceived;
            ConnectionManager.getConnectionManager().dispatch(this, this.readPacket(httpServletRequest));
        }
        catch (IOException iOException) {
            if (debugTransport.isEnabled() || debugIIOPTunneling.isDebugEnabled()) {
                IIOPLogger.logDebugTransport((String)("Problem dispatching tunneled message to: '" + this + "'"));
            }
            throw iOException;
        }
    }

    public final long getMessagesSentCount() {
        return this.messagesSent;
    }

    public final long getBytesSentCount() {
        return this.bytesSent;
    }

    public final long getMessagesReceivedCount() {
        return this.messagesReceived;
    }

    public final long getBytesReceivedCount() {
        return this.bytesReceived;
    }

    public final long getConnectTime() {
        return this.connectTime;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        if (this.isClosed()) {
            return;
        }
        ServerConnection serverConnection = this;
        synchronized (serverConnection) {
            this.closed = true;
            ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)channelOpenSocksMap.get((Object)this.networkChannel);
            concurrentHashMap.remove((Object)this.sockID);
            if (debugTransport.isEnabled() || debugIIOPTunneling.isDebugEnabled() || debugBean.getDebugTunnelingConnectionTimeout()) {
                IIOPLogger.logDebugTransport((String)("Closing tunneled socket: '" + this + "'" + new Throwable("Stack trace")));
            }
            if (this.pending != null) {
                try {
                    Utils.sendDeadResponse((HttpServletResponse)this.pending);
                    this.pending.getOutputStream().flush();
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        this.pending.send();
                    }
                    catch (IOException iOException) {}
                    this.pendingRequest = null;
                    this.pending = null;
                }
            }
            if (this.networkChannel instanceof ServerChannelImpl && ((ServerChannelImpl)this.networkChannel).getRuntime() != null) {
                ((ServerChannelImpl)this.networkChannel).getRuntime().removeServerConnectionRuntime(this.sockRuntime);
            }
        }
    }

    public final EndPoint getEndPoint() {
        return new EndPointImpl(this, ConnectionManager.getConnectionManager());
    }

    public final ConnectionKey getConnectionKey() {
        return this.key;
    }

    public final void setConnectionKey(ConnectionKey connectionKey) {
        this.key = connectionKey;
    }

    public AuthenticatedSubject getUser() {
        return null;
    }

    public void authenticate(UserInfo userInfo) {
    }

    public Object getTxContext() {
        return null;
    }

    public void setTxContext(Object object) {
    }

    protected final boolean isSecure() {
        return this.getChannel().supportsTLS();
    }

    static {
        channelOpenSocksMap = new ConcurrentHashMap();
        idCount = 0L;
    }

    private static final class TunnelScavenger
    implements TimerListener {
        ServerChannel networkChannel;
        ServerChannelImpl networkChannelimpl;

        TunnelScavenger(ServerChannel serverChannel) {
            this.networkChannel = serverChannel;
            if (serverChannel instanceof ServerChannelImpl) {
                this.networkChannelimpl = (ServerChannelImpl)serverChannel;
            }
        }

        public void timerExpired(Timer timer) {
            ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)channelOpenSocksMap.get((Object)this.networkChannel);
            for (ServerConnection serverConnection : concurrentHashMap.values()) {
                serverConnection.checkIsDead();
            }
            if (concurrentHashMap.isEmpty() && this.networkChannelimpl != null && this.networkChannelimpl.getRuntime() == null) {
                channelOpenSocksMap.remove((Object)this.networkChannel);
                this.networkChannel = null;
                this.networkChannelimpl = null;
                timer.cancel();
            }
        }
    }
}

