/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.iiop.http;

import java.io.IOException;
import java.net.ProtocolException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.common.internal.VersionInfo;
import weblogic.corba.iiop.http.ServerConnection;
import weblogic.corba.iiop.http.Utils;
import weblogic.protocol.LocalServerIdentity;
import weblogic.socket.Login;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.StringUtils;

public final class TunnelLoginServlet
extends HttpServlet {
    private static final DebugCategory debug = Debug.getCategory((String)"weblogic.iiop.http.tunnelLogin");

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String[] stringArray;
        String string = Utils.getQueryStringParameter(httpServletRequest, "wl-login");
        if (string == null) {
            this.rejectConnection(1, "No version information", httpServletResponse);
            return;
        }
        if (debug.isEnabled()) {
            stringArray = httpServletRequest.getHeaderNames();
            while (stringArray.hasMoreElements()) {
                System.out.println("<TunnelLogin>: " + httpServletRequest.getHeader((String)stringArray.nextElement()));
            }
        }
        stringArray = StringUtils.splitCompletely((String)string, (String)" \t");
        String string2 = null;
        if (stringArray.length == 1) {
            string2 = stringArray[0];
        } else if (stringArray.length > 3) {
            string2 = stringArray[3];
        } else {
            this.rejectConnection(1, "Malformed first line - perhaps an attempt to onnect to a plaintext port using SSL or vice versa?", httpServletResponse);
            return;
        }
        if (!VersionInfo.theOne().compatible(string2)) {
            this.rejectConnection(6, VersionInfo.theOne().rejectionReason(string2), httpServletResponse);
            return;
        }
        boolean bl = false;
        int n = 0;
        try {
            n = Integer.parseInt(Utils.getQueryStringParameter(httpServletRequest, "HL"));
        }
        catch (NumberFormatException numberFormatException) {
            this.rejectConnection(1, "Malformed first line", httpServletResponse);
        }
        String string3 = null;
        try {
            string3 = ServerConnection.acceptConnection(httpServletRequest, n, httpServletResponse);
        }
        catch (ProtocolException protocolException) {
            this.rejectConnection(1, StackTraceUtils.throwable2StackTrace((Throwable)protocolException), httpServletResponse);
            return;
        }
        Utils.addTunnelCookie(httpServletRequest, httpServletResponse);
        httpServletResponse.setHeader("Conn-Id", string3);
        httpServletResponse.setHeader("WL-Dest", Integer.toString(LocalServerIdentity.getIdentity().hashCode()));
        Utils.addClusterList(httpServletRequest, httpServletResponse);
        Utils.sendOKResponse(httpServletResponse);
    }

    private void rejectConnection(int n, String string, HttpServletResponse httpServletResponse) throws IOException {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        if (n >= Login.RET_CODES.length) {
            n = 7;
        }
        servletOutputStream.println(Login.RET_CODES[n] + ":" + string);
        this.log("Login rejected with code: '" + Login.RET_TEXT[n] + "', reason: " + string + "'");
    }
}

