/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.iiop.http;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.corba.iiop.http.ServerConnection;
import weblogic.corba.iiop.http.Utils;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public final class TunnelSendServlet
extends HttpServlet {
    private static final DebugCategory debug = Debug.getCategory((String)"weblogic.iiop.http.tunnelSend");

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        ServerConnection serverConnection = Utils.getConnectionFromID(httpServletRequest);
        if (debug.isEnabled()) {
            Enumeration enumeration = httpServletRequest.getHeaderNames();
            while (enumeration.hasMoreElements()) {
                System.out.println("<TunnelSend>: " + httpServletRequest.getHeader((String)enumeration.nextElement()));
            }
        }
        if (serverConnection == null || !Utils.requestIntended(httpServletRequest)) {
            if (debug.isEnabled()) {
                this.log("Null JVMConnection");
            }
            Utils.sendDeadResponse(httpServletResponse);
            return;
        }
        try {
            serverConnection.dispatch(httpServletRequest, httpServletResponse);
        }
        catch (IOException iOException) {
            try {
                if (debug.isEnabled()) {
                    this.log("Problem sending msg", iOException);
                }
                Utils.sendDeadResponse(httpServletResponse);
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return;
        }
        Utils.sendOKResponse(httpServletResponse);
    }
}

