/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.iiop.http;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.Hashtable;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import weblogic.cluster.ClusterMemberInfo;
import weblogic.cluster.ClusterServiceActivator;
import weblogic.cluster.ClusterServices;
import weblogic.common.internal.VersionInfo;
import weblogic.corba.iiop.http.ServerConnection;
import weblogic.iiop.MessageHeader;
import weblogic.management.provider.ManagementService;
import weblogic.protocol.AsyncOutgoingMessage;
import weblogic.protocol.LocalServerIdentity;
import weblogic.protocol.ServerChannel;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.ServerHelper;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.servlet.internal.ServletResponseImpl;

final class Utils {
    private static final String CONTENT_LENGTH = "Content-Length";
    private static Cookie tunnelCookie = null;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    private Utils() {
    }

    static final ServerConnection getConnectionFromID(HttpServletRequest httpServletRequest) throws IOException {
        String string = Utils.getQueryStringParameter(httpServletRequest, "connectionID");
        if (string == null) {
            return null;
        }
        ServerConnection serverConnection = ServerConnection.findByID(string);
        return serverConnection;
    }

    static final void sendDeadResponse(HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setHeader("WL-Result", "DEAD");
        httpServletResponse.getOutputStream().print("DEAD");
        httpServletResponse.getOutputStream().flush();
    }

    static final void sendOKResponse(HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setHeader("WL-Result", "OK");
        httpServletResponse.setHeader("WL-Version", VersionInfo.theOne().getMajor() + "." + VersionInfo.theOne().getMinor() + "." + VersionInfo.theOne().getServicePack() + "." + VersionInfo.theOne().getRollingPatch() + "." + VersionInfo.theOne().hasTemporaryPatch());
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        servletOutputStream.print("OK\n");
        servletOutputStream.print("HL:12\n\n");
    }

    static final void sendResponse(HttpServletResponse httpServletResponse, AsyncOutgoingMessage asyncOutgoingMessage) throws IOException {
        int n = asyncOutgoingMessage.getLength();
        httpServletResponse.setHeader(CONTENT_LENGTH, Integer.toString(n));
        httpServletResponse.setHeader("WL-Result", "OK");
        httpServletResponse.setHeader("WL-Type", Integer.toString(MessageHeader.getMsgType(asyncOutgoingMessage.getChunks().buf)));
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        asyncOutgoingMessage.writeTo((OutputStream)servletOutputStream);
        servletOutputStream.flush();
    }

    static final String getQueryStringParameter(HttpServletRequest httpServletRequest, String string) {
        String string2 = httpServletRequest.getQueryString();
        Hashtable hashtable = HttpUtils.parseQueryString((String)string2);
        String[] stringArray = (String[])hashtable.get(string);
        return stringArray == null ? null : stringArray[0];
    }

    static final boolean requestIntended(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("WL-Dest");
        return string == null || Integer.parseInt(string) == LocalServerIdentity.getIdentity().hashCode();
    }

    static final void addTunnelCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (tunnelCookie == null) {
            StringBuffer stringBuffer = new StringBuffer(52);
            for (int i = 0; i < 52; ++i) {
                stringBuffer.append("w");
            }
            stringBuffer.append("!").append(Integer.toString(LocalServerIdentity.getIdentity().hashCode()));
            tunnelCookie = new Cookie("JSESSIONID", stringBuffer.toString());
        }
        httpServletResponse.addCookie(tunnelCookie);
    }

    static final void addClusterList(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ClusterMemberInfo clusterMemberInfo2;
        ClusterServices clusterServices = ClusterServiceActivator.INSTANCE.getClusterService();
        if (ManagementService.getRuntimeAccess(kernelId).getServer().getCluster() == null || clusterServices == null) {
            return;
        }
        ServletRequestImpl servletRequestImpl = (ServletRequestImpl)httpServletRequest;
        ServletResponseImpl servletResponseImpl = (ServletResponseImpl)httpServletResponse;
        HttpServer httpServer = servletRequestImpl.getContext().getServer();
        ServerChannel serverChannel = servletRequestImpl.getServerChannel();
        httpServletResponse.addHeader("WL-Scheme", serverChannel.getProtocol().getProtocolName());
        StringBuffer stringBuffer = new StringBuffer();
        for (ClusterMemberInfo clusterMemberInfo2 : clusterServices.getRemoteMembers()) {
            String string = ServerHelper.createServerEntry(serverChannel.getChannelName(), clusterMemberInfo2.identity(), "!", false);
            if (string == null) continue;
            stringBuffer.append(string).append('|');
        }
        clusterMemberInfo2 = clusterServices.getLocalMember();
        stringBuffer.append(ServerHelper.createServerEntry(serverChannel.getChannelName(), clusterMemberInfo2.identity(), "!", false));
        httpServletResponse.addHeader("WL-List", stringBuffer.toString());
    }
}

