/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.j2ee.naming;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import weblogic.corba.client.transaction.TransactionHelperImpl;
import weblogic.corba.j2ee.naming.EndPointInfo;
import weblogic.corba.j2ee.naming.NameParser;
import weblogic.corba.j2ee.naming.ORBInfo;
import weblogic.corba.j2ee.naming.Utils;
import weblogic.corba.orb.ORBHelperImpl;
import weblogic.jndi.WLInitialContextFactory;
import weblogic.kernel.KernelStatus;
import weblogic.transaction.TransactionHelper;

public class ORBHelper {
    public static final String ORB_INITIAL_HOST = "org.omg.CORBA.ORBInitialHost";
    public static final String ORB_INITIAL_PORT = "org.omg.CORBA.ORBInitialPort";
    public static final String ORB_INITIAL_REF = "org.omg.CORBA.ORBInitRef";
    public static final String ORB_DEFAULT_INITIAL_REF = "org.omg.CORBA.ORBDefaultInitRef";
    public static final String ORB_CLASS_PROP = "org.omg.CORBA.ORBClass";
    public static final String ORB_NAMING_PROP = "java.naming.corba.orb";
    public static final String SUN_SOCKET_FACTORY = "com.sun.CORBA.legacy.connection.ORBSocketFactoryClass";
    public static final String SUN_SOCKET_FACTORY_OLD = "com.sun.CORBA.connection.ORBSocketFactoryClass";
    public static final String SUN_LISTEN_SOCKET = "com.sun.CORBA.connection.ORBListenSocket";
    public static final String SUN_WCHARSET = "com.sun.CORBA.codeset.wcharsets";
    public static final String SUN_FRAGMENT = "com.sun.CORBA.giop.ORBGIOP12BuffMgr";
    public static final String ORB_INITIALIZER = "org.omg.PortableInterceptor.ORBInitializerClass.";
    public static final String BI_DIR_ORBINIT = "weblogic.corba.client.iiop.BiDirORBInitializer";
    public static final String CLIENT_ORBINIT = "weblogic.corba.client.ClientORBInitializer";
    public static final String CLIENT_PACKAGE = "weblogic.corba.client.";
    public static final String CLIENT_PACKAGE_14 = "weblogic.corba.client14.";
    public static final String BI_DIR_SOCKET_FACTORY = "iiop.BiDirORBSocketFactory";
    public static final String BI_DIR_SSL_SOCKET_FACTORY = "iiop.BiDirSSLORBSocketFactory";
    public static final String SSL_SOCKET_FACTORY = "security.SSLORBSocketFactory";
    public static final String TUNNEL_SOCKET_FACTORY = "http.TunneledORBSocketFactory";
    public static final String TUNNEL_SSL_SOCKET_FACTORY = "http.TunneledSSLORBSocketFactory";
    public static final String CLUSTER_SOCKET_FACTORY = "cluster.ORBSocketFactory";
    public static final String NATIVE_TX_HELPER = "weblogic.corba.server.transaction.TransactionHelperImpl";
    public static final String ENABLE_SERVER_AFFINITY = "weblogic.jndi.enableServerAffinity";
    public static final String ORB_PROTOCOL = "weblogic.corba.orb.ORBProtocol";
    public static final String ORB_NAME = "weblogic.corba.orb.ORBName";
    public static final String INITIAL_CONTEXT_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    public static final String REQUEST_TIMEOUT = "weblogic.jndi.requestTimeout";
    public static final String RMI_TIMEOUT = "weblogic.rmi.clientTimeout";
    public static final String SUN_RPC_TRANSPORT_LOGGER = "javax.enterprise.resource.corba._DEFAULT_.rpc.transport";
    public static final String SUN_TCP_READ_TIMEOUTS_PROPERTY = "com.sun.CORBA.transport.ORBTCPReadTimeouts";
    private static final boolean DEBUG = false;
    private static final String FALSE_PROP = "false";
    private static ORBHelper singleton;
    private static boolean enableIIOPClient;
    private static boolean thinClient;
    private boolean dummyORBCreated = false;
    private String orbClassName;
    private static final boolean jdk14;
    private static final boolean enableBiDir;
    private HashMap orbs = new HashMap();
    private HashMap sslCtxCache = new HashMap();
    private ConcurrentHashMap timeoutCache = new ConcurrentHashMap();
    private HashMap urlCache = new HashMap();
    private ORBInfo currentinfo = null;

    private static final boolean getJDK14() {
        Class<String> clazz = String.class;
        try {
            clazz.getMethod("replace", CharSequence.class, CharSequence.class);
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            clazz.getMethod("replace", String.class, String.class);
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return true;
    }

    private static final boolean getBiDir() {
        try {
            return Boolean.getBoolean("weblogic.corba.client.bidir");
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean isThinClient() {
        return thinClient;
    }

    public static ORBHelper getORBHelper() {
        if (singleton == null) {
            if (thinClient) {
                new WLInitialContextFactory();
            } else {
                ORBHelper.createORBHelper();
            }
        }
        return singleton;
    }

    public static synchronized void createORBHelper() {
        if (singleton == null) {
            String string = "";
            string = KernelStatus.isApplet() ? FALSE_PROP : System.getProperty("weblogic.system.iiop.enableClient");
            if (!FALSE_PROP.equals(string)) {
                enableIIOPClient = true;
                singleton = new ORBHelperImpl();
            } else {
                singleton = new ORBHelper();
            }
        }
    }

    public static synchronized void setORBHelper(ORBHelper oRBHelper) {
        singleton = oRBHelper;
    }

    private static boolean getServerAffinity(Hashtable hashtable) {
        return hashtable == null ? false : Boolean.valueOf((String)hashtable.get(ENABLE_SERVER_AFFINITY));
    }

    public synchronized ORB getORB(String string, Hashtable hashtable) throws NamingException {
        NameParser.URLInfo uRLInfo = this.parseURL(string);
        boolean bl = ORBHelper.getServerAffinity(hashtable);
        ORBInfo oRBInfo = this.getCachedORB(bl ? uRLInfo.getKey() : uRLInfo.getNextKey(), hashtable);
        if (oRBInfo != null) {
            return oRBInfo.getORB();
        }
        ORB oRB = null;
        if (string != null) {
            EndPointInfo endPointInfo = uRLInfo.getAddress();
            oRB = this.createORB(hashtable, endPointInfo, uRLInfo.getProtocol(), uRLInfo.serviceName + "=" + uRLInfo.getURL());
            oRBInfo = this.cacheORBAndCreateURL(uRLInfo.getKey(), oRB, uRLInfo);
        } else {
            oRB = this.createORB(hashtable, null, null, null);
            oRBInfo = this.createORBInfo(oRB, null);
            this.setCurrent(oRBInfo);
        }
        return oRBInfo.getORB();
    }

    private synchronized ORBInfo getCachedORB(String string, Hashtable hashtable) {
        ORBInfo oRBInfo = null;
        if (string != null && (oRBInfo = (ORBInfo)this.orbs.get(string)) != null) {
            this.setCurrent(oRBInfo);
            return oRBInfo;
        }
        if (hashtable != null && hashtable.get(ORB_NAMING_PROP) != null) {
            oRBInfo = this.cacheORB(string, (ORB)hashtable.get(ORB_NAMING_PROP));
        }
        return oRBInfo;
    }

    private ORBInfo cacheORB(String string, ORB oRB) {
        ORBInfo oRBInfo = this.createORBInfo(oRB, string);
        this.orbs.put(string, oRBInfo);
        this.setCurrent(oRBInfo);
        return oRBInfo;
    }

    private ORBInfo cacheORBAndCreateURL(String string, ORB oRB, NameParser.URLInfo uRLInfo) {
        ORBInfo oRBInfo = this.cacheORB(string, oRB);
        oRBInfo.setClusterURL(uRLInfo.getClusterURL());
        return oRBInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ORB createORB(Hashtable hashtable, EndPointInfo endPointInfo, String string, String string2) {
        ORB oRB;
        String string3;
        Properties properties = new Properties();
        if (hashtable != null) {
            properties.putAll((Map<?, ?>)hashtable);
        }
        String string4 = string3 = jdk14 ? CLIENT_PACKAGE_14 : CLIENT_PACKAGE;
        if (properties.getProperty(ORB_CLASS_PROP) == null && this.getORBClass() != null) {
            properties.setProperty(ORB_CLASS_PROP, this.getORBClass());
        }
        if (endPointInfo != null) {
            if (endPointInfo.getPort() > 0) {
                properties.put(ORB_INITIAL_PORT, Integer.toString(endPointInfo.getPort()));
            }
            properties.put(ORB_PROTOCOL, string);
            properties.put(SUN_FRAGMENT, "GROW");
            if (hashtable != null && hashtable.containsKey(RMI_TIMEOUT)) {
                properties.put(SUN_TCP_READ_TIMEOUTS_PROPERTY, "100:" + hashtable.get(RMI_TIMEOUT) + ":300:20");
            }
            properties.put(SUN_WCHARSET, "0x05010001,0x00010109");
            if (string == "iiops") {
                properties.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.ClientORBInitializer", "true");
                properties.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.iiop.BiDirORBInitializer", "true");
                properties.put(SUN_SOCKET_FACTORY, string3 + BI_DIR_SSL_SOCKET_FACTORY);
                properties.put(SUN_SOCKET_FACTORY_OLD, string3 + BI_DIR_SSL_SOCKET_FACTORY);
            } else if (string == "http") {
                properties.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.ClientORBInitializer", "true");
                properties.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.iiop.BiDirORBInitializer", "true");
                properties.put(SUN_SOCKET_FACTORY, string3 + TUNNEL_SOCKET_FACTORY);
                properties.put(SUN_SOCKET_FACTORY_OLD, string3 + TUNNEL_SOCKET_FACTORY);
            } else if (string == "https") {
                properties.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.ClientORBInitializer", "true");
                properties.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.iiop.BiDirORBInitializer", "true");
                properties.put(SUN_SOCKET_FACTORY, string3 + TUNNEL_SSL_SOCKET_FACTORY);
                properties.put(SUN_SOCKET_FACTORY_OLD, string3 + TUNNEL_SSL_SOCKET_FACTORY);
            } else if (thinClient) {
                properties.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.ClientORBInitializer", "true");
                if (enableBiDir && string.length() > 0) {
                    properties.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.iiop.BiDirORBInitializer", "true");
                    properties.put(SUN_SOCKET_FACTORY, string3 + BI_DIR_SOCKET_FACTORY);
                    properties.put(SUN_SOCKET_FACTORY_OLD, string3 + BI_DIR_SOCKET_FACTORY);
                } else {
                    properties.put(SUN_SOCKET_FACTORY, string3 + CLUSTER_SOCKET_FACTORY);
                    properties.put(SUN_SOCKET_FACTORY_OLD, string3 + CLUSTER_SOCKET_FACTORY);
                }
            }
            properties.put(ORB_INITIAL_HOST, endPointInfo.getHost());
            properties.put(ORB_INITIAL_REF, string2);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ORBHelper.class.getClassLoader());
            oRB = ORB.init((String[])new String[0], (Properties)properties);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        if (hashtable != null) {
            java.lang.Object v = hashtable.get("java.naming.security.credentials");
            if (v != null && v instanceof SSLContext) {
                this.sslCtxCache.put(oRB, v);
            }
            if (hashtable.containsKey(REQUEST_TIMEOUT)) {
                this.timeoutCache.put(oRB, hashtable.get(REQUEST_TIMEOUT));
            }
        }
        return oRB;
    }

    public final SSLContext getSSLContext(ORB oRB) {
        return (SSLContext)this.sslCtxCache.get(oRB);
    }

    public int getORBTimeout(ORB oRB) {
        if (this.timeoutCache.containsKey(oRB)) {
            return ((Long)this.timeoutCache.get(oRB)).intValue();
        }
        return 0;
    }

    public String getORBClass() {
        return this.orbClassName;
    }

    public ORB getLocalORB() throws NamingException {
        Properties properties = new Properties();
        if (this.getORBClass() != null) {
            properties.setProperty(ORB_CLASS_PROP, this.getORBClass());
        }
        return ORB.init((String[])new String[0], (Properties)properties);
    }

    public ORBInfo getCurrent() {
        return this.currentinfo;
    }

    public void setCurrent(ORBInfo oRBInfo) {
        this.currentinfo = oRBInfo;
    }

    public ORBInfo createORBInfo(ORB oRB, String string) {
        return new ORBInfo(oRB, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getORBReference(String string, Hashtable hashtable, String string2) throws NamingException {
        String string3;
        ORBInfo oRBInfo;
        NameParser.URLInfo uRLInfo = this.parseURL(string);
        if (uRLInfo == null) {
            throw new InvalidNameException("url `" + string + "' is invalid");
        }
        boolean bl = ORBHelper.getServerAffinity(hashtable);
        for (int i = 0; i < uRLInfo.addressList.length && (oRBInfo = this.getCachedORB(string3 = uRLInfo.getKey(), hashtable)) != null; ++i) {
            try {
                Object object = oRBInfo.getORB().resolve_initial_references(string2);
                if (thinClient) {
                    object._non_existent();
                }
                if (!bl) {
                    uRLInfo.getNextAddress();
                }
                oRBInfo.setClusterURL(uRLInfo.getClusterURL());
                return object;
            }
            catch (InvalidName invalidName) {
                throw Utils.wrapNamingException((Exception)((java.lang.Object)invalidName), "Couldn't resolve initial reference: " + string2);
            }
            catch (SystemException systemException) {
                ORBHelper oRBHelper = this;
                synchronized (oRBHelper) {
                    this.orbs.remove(string3);
                    this.setCurrent(null);
                }
                if (thinClient) {
                    this.destroyORB(oRBInfo.getORB());
                }
                this.timeoutCache.remove(oRBInfo.getORB());
                if (!ORBHelper.isRecoverableORBFailure(systemException)) {
                    throw Utils.wrapNamingException((Exception)((java.lang.Object)systemException), "Couldn't resolve initial reference: " + string2);
                }
                uRLInfo.getNextAddress();
                continue;
            }
        }
        return this.getORBReferenceWithRetry(uRLInfo, hashtable, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getORBReferenceWithRetry(NameParser.URLInfo uRLInfo, Hashtable hashtable, String string) throws NamingException {
        ORB oRB = null;
        Object object = null;
        int n = 0;
        boolean bl = ORBHelper.getServerAffinity(hashtable);
        boolean bl2 = false;
        while (object == null) {
            java.lang.Object object2;
            java.lang.Object object3;
            String string2 = uRLInfo.getKey();
            if (!bl2) {
                object3 = uRLInfo.getAddress();
                java.lang.Object object4 = object2 = thinClient ? uRLInfo.getNeutralURL() : uRLInfo.getURL();
                if (thinClient && !this.dummyORBCreated) {
                    this.createDummyORB(hashtable, (EndPointInfo)object3);
                }
                oRB = this.createORB(hashtable, (EndPointInfo)object3, uRLInfo.getProtocol(), uRLInfo.serviceName + "=" + (String)object2);
            }
            try {
                object = oRB.resolve_initial_references(string);
                if (thinClient) {
                    object._non_existent();
                }
                if (!bl) {
                    uRLInfo.getNextAddress();
                }
                object3 = this;
                synchronized (object3) {
                    if (this.getCachedORB(string2, hashtable) == null) {
                        this.cacheORBAndCreateURL(string2, oRB, uRLInfo);
                    }
                }
            }
            catch (InvalidName invalidName) {
                throw Utils.wrapNamingException((Exception)((java.lang.Object)invalidName), "Couldn't resolve initial reference: " + string);
            }
            catch (SystemException systemException) {
                object = null;
                if (thinClient) {
                    this.destroyORB(oRB);
                }
                this.timeoutCache.remove(oRB);
                if (!bl2) {
                    if (!ORBHelper.isRecoverableORBFailure(systemException) || ++n >= uRLInfo.addressList.length) {
                        object2 = uRLInfo.addressList.length == 1 ? this.getRootCauseMessage(systemException) : "Couldn't connect to any host ";
                        throw Utils.wrapNamingException((Exception)((java.lang.Object)systemException), (String)object2);
                    }
                    uRLInfo.getNextAddress();
                    object2 = this.getCachedORB(uRLInfo.getKey(), hashtable);
                    if (object2 == null) continue;
                    oRB = ((ORBInfo)object2).getORB();
                    bl2 = true;
                    continue;
                }
                this.clearORBFromCache(uRLInfo.getKey());
                bl2 = false;
                if (ORBHelper.isRecoverableORBFailure(systemException)) continue;
                throw Utils.wrapNamingException((Exception)((java.lang.Object)systemException), "Couldn't resolve initial reference: " + string);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearORBFromCache(String string) {
        ORBHelper oRBHelper = this;
        synchronized (oRBHelper) {
            if (string != null) {
                this.orbs.remove(string);
            }
            this.setCurrent(null);
        }
    }

    private final synchronized NameParser.URLInfo parseURL(String string) throws InvalidNameException {
        NameParser.URLInfo uRLInfo = (NameParser.URLInfo)this.urlCache.get(string);
        if (uRLInfo == null) {
            uRLInfo = NameParser.parseURL(string);
            this.urlCache.put(string, uRLInfo);
        }
        return uRLInfo;
    }

    public void pushTransactionHelper() {
        if (enableIIOPClient) {
            TransactionHelper.pushTransactionHelper((TransactionHelper)ORBHelper.createTxHelper(NATIVE_TX_HELPER));
        } else {
            TransactionHelper.pushTransactionHelper((TransactionHelper)new TransactionHelperImpl());
        }
    }

    public void popTransactionHelper() {
        TransactionHelper.popTransactionHelper();
    }

    static boolean isRecoverableORBFailure(SystemException systemException) {
        return ORBHelper.isRecoverableORBFailure(systemException, true);
    }

    public static boolean isRecoverableORBFailure(SystemException systemException, boolean bl) {
        return (systemException instanceof COMM_FAILURE || systemException instanceof MARSHAL || systemException instanceof OBJECT_NOT_EXIST || systemException instanceof BAD_PARAM && systemException.minor == 1330446344) && (systemException.completed.value() == 1 || systemException.completed.value() == 2 && bl);
    }

    private static TransactionHelper createTxHelper(String string) {
        try {
            return (TransactionHelper)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error(classNotFoundException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new Error(instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error(illegalAccessException.toString());
        }
    }

    protected static void p(String string) {
        System.err.println("<ORBHelper> " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDummyORB(Hashtable hashtable, EndPointInfo endPointInfo) {
        java.lang.Object object = null;
        EndPointInfo endPointInfo2 = new EndPointInfo(" ", -1, endPointInfo.getMajorVersion(), endPointInfo.getMajorVersion());
        String string = "NameService=corbaloc::1.1@/NameService";
        ORBHelper oRBHelper = this;
        synchronized (oRBHelper) {
            if (!this.dummyORBCreated) {
                try {
                    object = this.createORB(null, endPointInfo2, "", string);
                    this.setORBLogLevel();
                    Object object2 = object.resolve_initial_references(string);
                    object2._non_existent();
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.orbClassName = object.getClass().getName();
                    this.dummyORBCreated = true;
                }
            }
        }
    }

    public void destroyORB(ORB oRB) {
        try {
            java.lang.Object object;
            java.lang.Object object2 = oRB.getClass().getMethod("getTransportManager", new Class[0]).invoke((java.lang.Object)oRB, new java.lang.Object[0]);
            try {
                object = object2.getClass().getMethod("getSelector", Integer.TYPE).invoke(object2, 0);
                object.getClass().getMethod("close", new Class[0]).invoke(object, new java.lang.Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = (Collection)object2.getClass().getMethod("getAcceptors", new Class[0]).invoke(object2, new java.lang.Object[0]);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                java.lang.Object e = iterator.next();
                try {
                    e.getClass().getMethod("close", new Class[0]).invoke(e, new java.lang.Object[0]);
                }
                catch (Exception exception) {}
            }
            oRB.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setORBLogLevel() {
        String string = System.getProperty("weblogic.corba.client.ORBLogLevel");
        if (string == null) {
            return;
        }
        Logger logger = LogManager.getLogManager().getLogger(SUN_RPC_TRANSPORT_LOGGER);
        if (logger != null) {
            Level level = null;
            try {
                level = Level.parse(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (level != null) {
                logger.setLevel(level);
            }
        }
    }

    private String getRootCauseMessage(Throwable throwable) {
        String string = "Couldn't connect to the specified host";
        Throwable throwable2 = throwable.getCause();
        if (throwable2 == null) {
            return string;
        }
        return string + " : " + throwable2.getMessage();
    }

    static {
        enableIIOPClient = false;
        thinClient = false;
        jdk14 = ORBHelper.getJDK14();
        enableBiDir = ORBHelper.getBiDir();
        try {
            String string = jdk14 ? CLIENT_PACKAGE_14 : CLIENT_PACKAGE;
            Class.forName(string + CLUSTER_SOCKET_FACTORY);
            Class.forName(INITIAL_CONTEXT_FACTORY);
            if (!KernelStatus.isServer() && KernelStatus.isThinIIOPClient()) {
                thinClient = true;
            } else {
                Class.forName("org.osgi.framework.Bundle");
                thinClient = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

