/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.orb;

import java.applet.Applet;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.NamingException;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.Current;
import org.omg.CORBA.DynAny;
import org.omg.CORBA.DynArray;
import org.omg.CORBA.DynEnum;
import org.omg.CORBA.DynSequence;
import org.omg.CORBA.DynStruct;
import org.omg.CORBA.DynUnion;
import org.omg.CORBA.Environment;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.ORBPackage.InconsistentTypeCode;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.Request;
import org.omg.CORBA.ServiceInformationHolder;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.UserException;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.WrongTransaction;
import org.omg.CORBA.portable.OutputStream;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.omg.TimeBase.TimeTHelper;
import org.omg.TimeBase.UtcTHelper;
import weblogic.corba.cos.transactions.InvocationPolicyImpl;
import weblogic.corba.cos.transactions.OTSPolicyImpl;
import weblogic.corba.idl.AnyImpl;
import weblogic.corba.idl.EnvironmentImpl;
import weblogic.corba.idl.ExceptionListImpl;
import weblogic.corba.idl.NVListImpl;
import weblogic.corba.idl.NamedValueImpl;
import weblogic.corba.idl.TypeCodeImpl;
import weblogic.corba.idl.poa.POAImpl;
import weblogic.corba.idl.poa.RelativeRequestTimeoutPolicyImpl;
import weblogic.corba.idl.poa.RelativeRoundtripTimeoutPolicyImpl;
import weblogic.corba.idl.poa.ReplyEndTimePolicyImpl;
import weblogic.corba.idl.poa.RequestEndTimePolicyImpl;
import weblogic.corba.j2ee.naming.NameParser;
import weblogic.corba.j2ee.naming.Utils;
import weblogic.corba.utils.RepositoryId;
import weblogic.iiop.IIOPClient;
import weblogic.iiop.IIOPClientService;
import weblogic.iiop.IIOPOutputStream;
import weblogic.iiop.IIOPReplacer;
import weblogic.iiop.IOR;
import weblogic.iiop.IORManager;
import weblogic.iiop.InitialReferences;
import weblogic.rmi.extensions.server.StubReference;
import weblogic.rmi.internal.OIDManager;
import weblogic.rmi.internal.ServerReference;

public class ORB
extends org.omg.CORBA_2_3.ORB {
    private String host;
    private String name;
    private int port = -1;
    private Hashtable initialRefs = new Hashtable();
    private ArrayList deferred = new ArrayList();
    private String defaultInitialRef;
    private String protocol;
    private String channelName;
    private long timeout = 0L;
    private static final boolean DEBUG = false;
    private static final String ROOT_POA = "RootPOA";
    private POA rootPOA;

    public ORB() {
        if (!IIOPClient.isEnabled()) {
            IIOPClient.initialize();
        }
    }

    private ORB(boolean bl) {
        this();
        this.set_parameters(new String[0], null);
    }

    public static final ORB getInstance() {
        return SingletonMaker.ORB;
    }

    public void set_delegate(java.lang.Object object) {
        try {
            ((POAImpl)this.getRootPOA()).activate_object((Servant)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void set_parameters(String[] stringArray, Properties properties) {
        String string;
        this.initialRefs.put(ROOT_POA, ROOT_POA);
        if (properties != null) {
            try {
                this.host = properties.getProperty("org.omg.CORBA.ORBInitialHost");
                this.protocol = properties.getProperty("weblogic.corba.orb.ORBProtocol", "iiop");
                this.name = properties.getProperty("weblogic.corba.orb.ORBName", Long.toHexString(((java.lang.Object)((java.lang.Object)this)).hashCode()));
                this.channelName = properties.getProperty("weblogic.jndi.provider.channel");
                this.port = Integer.parseInt(properties.getProperty("org.omg.CORBA.ORBInitialPort", "-1"));
                this.timeout = Long.parseLong(properties.getProperty("weblogic.jndi.requestTimeout", "0"));
                String string2 = properties.getProperty("org.omg.CORBA.ORBInitRef");
                if (string2 != null) {
                    int n = string2.indexOf(61);
                    String string3 = string2.substring(0, n);
                    string = string2.substring(n + 1);
                    this.initialRefs.put(string3, string);
                }
                this.defaultInitialRef = properties.getProperty("org.omg.CORBA.ORBDefaultInitRef");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new BAD_PARAM(indexOutOfBoundsException.getMessage(), 1330446343, CompletionStatus.COMPLETED_NO);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BAD_PARAM(numberFormatException.getMessage(), 1330446343, CompletionStatus.COMPLETED_NO);
            }
        } else {
            this.name = Long.toHexString(((java.lang.Object)((java.lang.Object)this)).hashCode());
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-ORBDefaultInitRef")) {
                    this.defaultInitialRef = stringArray[++i];
                    continue;
                }
                if (!stringArray[i].equals("-ORBInitRef")) continue;
                String string4 = stringArray[++i];
                int n = string4.indexOf(61);
                string = string4.substring(0, n);
                String string5 = string4.substring(n + 1);
                this.initialRefs.put(string, string5);
            }
        }
    }

    protected void set_parameters(Applet applet, Properties properties) {
        this.set_parameters((String[])null, properties);
    }

    public Object resolve_initial_references(String string) throws InvalidName {
        java.lang.Object v = this.initialRefs.get(string);
        if (v == ROOT_POA) {
            return this.getRootPOA();
        }
        Object object = null;
        if (v instanceof Object) {
            object = (Object)v;
        } else if (v instanceof String) {
            object = this.string_to_object((String)v);
            this.cacheInitialReference(string, object);
        } else if (this.defaultInitialRef != null) {
            object = this.string_to_object(this.defaultInitialRef + "/" + string);
            this.cacheInitialReference(string, object);
        } else if (this.host != null && this.port >= 0) {
            try {
                IOR iOR = IORManager.createIOR(this.protocol, this.host, this.port, string, 1, 2);
                iOR = string.equals("NameService") ? IORManager.locateNameService(iOR, this.timeout) : IORManager.locateInitialReference(iOR, this.channelName, this.timeout);
                object = (Object)IIOPReplacer.resolveObject(iOR);
                this.cacheInitialReference(string, object);
            }
            catch (IOException iOException) {
                throw new InvalidName();
            }
        } else {
            object = InitialReferences.getInitialReferenceObject(string);
        }
        if (object == null) {
            throw new InvalidName();
        }
        return object;
    }

    private void cacheInitialReference(String string, Object object) {
        if (!string.equals("NameService") || !IIOPClientService.reconnectOnBootstrap) {
            this.initialRefs.put(string, object);
        }
    }

    public String[] list_initial_services() {
        return InitialReferences.getServiceList();
    }

    public String object_to_string(Object object) {
        try {
            java.lang.Object object2 = IIOPReplacer.getIIOPReplacer().replaceObject(object);
            if (object2 instanceof IOR) {
                return ((IOR)object2).stringify();
            }
            return null;
        }
        catch (IOException iOException) {
            throw new BAD_PARAM(iOException.getMessage(), 1330446346, CompletionStatus.COMPLETED_NO);
        }
    }

    public Object string_to_object(String string) {
        try {
            if (string.startsWith("IOR:")) {
                java.lang.Object object;
                IOR iOR = IOR.destringify(string);
                if ("iiops".equals(this.protocol)) {
                    iOR.getProfile().makeSecure();
                }
                if (!((object = IIOPReplacer.resolveObject(iOR)) instanceof Object)) {
                    object = IIOPReplacer.makeInvocationHandler(iOR);
                }
                return (Object)object;
            }
            if (NameParser.isGIOPProtocol(string)) {
                Object object = IORManager.createInitialReference(string, this.timeout);
                String string2 = NameParser.getNameString(string);
                if (string2.length() > 0) {
                    return Utils.narrowContext(object).resolve(Utils.stringToNameComponent(string2));
                }
                return object;
            }
            throw new NamingException("Bad stringified object reference: " + string);
        }
        catch (NamingException namingException) {
            throw Utils.unwrapNamingException((SystemException)new BAD_PARAM(namingException.getMessage(), 1330446343, CompletionStatus.COMPLETED_NO), namingException);
        }
        catch (UserException userException) {
            throw Utils.initCORBAExceptionWithCause((SystemException)new BAD_PARAM(userException.getMessage(), 1330446343, CompletionStatus.COMPLETED_NO), userException);
        }
        catch (IOException iOException) {
            throw Utils.initCORBAExceptionWithCause((SystemException)new BAD_PARAM(iOException.getMessage(), 1330446346, CompletionStatus.COMPLETED_NO), iOException);
        }
    }

    public void connect(Object object) {
        try {
            StubReference stubReference = OIDManager.getInstance().getReplacement((java.lang.Object)object);
        }
        catch (ClassCastException classCastException) {
            throw new BAD_PARAM("Couldn't connect Object to the ORB", 1330446346, CompletionStatus.COMPLETED_NO);
        }
        catch (RemoteException remoteException) {
            throw (BAD_PARAM)new BAD_PARAM(remoteException.getMessage(), 1330446346, CompletionStatus.COMPLETED_NO).initCause((Throwable)remoteException);
        }
    }

    public void disconnect(Object object) {
        ServerReference serverReference = OIDManager.getInstance().getServerReference((java.lang.Object)object);
        if (serverReference != null) {
            OIDManager.getInstance().removeServerReference(serverReference);
        }
    }

    public void destroy() {
    }

    public NVList create_list(int n) {
        return new NVListImpl(n);
    }

    public NVList create_operation_list(Object object) {
        throw new NO_IMPLEMENT();
    }

    public NamedValue create_named_value(String string, Any any, int n) {
        return new NamedValueImpl(string, any, n);
    }

    public ExceptionList create_exception_list() {
        return new ExceptionListImpl();
    }

    public ContextList create_context_list() {
        throw new NO_IMPLEMENT();
    }

    public Context get_default_context() {
        throw new NO_IMPLEMENT();
    }

    public Environment create_environment() {
        return new EnvironmentImpl();
    }

    public OutputStream create_output_stream() {
        return new IIOPOutputStream((org.omg.CORBA.ORB)this);
    }

    public void send_multiple_requests_oneway(Request[] requestArray) {
        for (int i = 0; i < requestArray.length; ++i) {
            requestArray[i].send_oneway();
        }
    }

    public void send_multiple_requests_deferred(Request[] requestArray) {
        for (int i = 0; i < requestArray.length; ++i) {
            requestArray[i].send_deferred();
            this.deferred.add(requestArray[i]);
        }
    }

    public synchronized boolean poll_next_response() {
        Iterator iterator = this.deferred.iterator();
        while (iterator.hasNext()) {
            if (!((Request)iterator.next()).poll_response()) continue;
            return true;
        }
        return false;
    }

    public synchronized Request get_next_response() throws WrongTransaction {
        Iterator iterator = this.deferred.iterator();
        while (iterator.hasNext()) {
            Request request = (Request)iterator.next();
            if (!request.poll_response()) continue;
            iterator.remove();
            request.get_response();
            return request;
        }
        throw new BAD_INV_ORDER("No ready response");
    }

    public void run() {
    }

    public void shutdown(boolean bl) {
    }

    public boolean work_pending() {
        throw new NO_IMPLEMENT();
    }

    public void perform_work() {
        throw new NO_IMPLEMENT();
    }

    public TypeCode get_primitive_tc(TCKind tCKind) {
        return TypeCodeImpl.get_primitive_tc(tCKind);
    }

    public TypeCode create_struct_tc(String string, String string2, StructMember[] structMemberArray) {
        return TypeCodeImpl.create_struct_tc(15, string, string2, structMemberArray);
    }

    public TypeCode create_union_tc(String string, String string2, TypeCode typeCode, UnionMember[] unionMemberArray) {
        return TypeCodeImpl.create_union_tc(string, string2, typeCode, unionMemberArray);
    }

    public TypeCode create_enum_tc(String string, String string2, String[] stringArray) {
        return TypeCodeImpl.create_enum_tc(string, string2, stringArray);
    }

    public TypeCode create_alias_tc(String string, String string2, TypeCode typeCode) {
        return new TypeCodeImpl(21, new RepositoryId(string), string2, typeCode);
    }

    public TypeCode create_exception_tc(String string, String string2, StructMember[] structMemberArray) {
        return TypeCodeImpl.create_struct_tc(22, string, string2, structMemberArray);
    }

    public TypeCode create_interface_tc(String string, String string2) {
        return new TypeCodeImpl(14, new RepositoryId(string), string2);
    }

    public TypeCode create_string_tc(int n) {
        return TypeCodeImpl.create_string_tc(n);
    }

    public TypeCode create_wstring_tc(int n) {
        return TypeCodeImpl.create_wstring_tc(n);
    }

    public TypeCode create_sequence_tc(int n, TypeCode typeCode) {
        return TypeCodeImpl.create_sequence_tc(n, typeCode);
    }

    public TypeCode create_recursive_sequence_tc(int n, int n2) {
        throw new NO_IMPLEMENT();
    }

    public TypeCode create_array_tc(int n, TypeCode typeCode) {
        return TypeCodeImpl.create_array_tc(n, typeCode);
    }

    public TypeCode create_native_tc(String string, String string2) {
        return new TypeCodeImpl(31, new RepositoryId(string), string2);
    }

    public TypeCode create_abstract_interface_tc(String string, String string2) {
        return new TypeCodeImpl(32, new RepositoryId(string), string2);
    }

    public TypeCode create_fixed_tc(short s, short s2) {
        return TypeCodeImpl.create_fixed_tc(s, s2);
    }

    public TypeCode create_value_tc(String string, String string2, short s, TypeCode typeCode, ValueMember[] valueMemberArray) {
        return TypeCodeImpl.create_value_tc(string, string2, s, typeCode, valueMemberArray);
    }

    public TypeCode create_recursive_tc(String string) {
        return TypeCodeImpl.get_primitive_tc(1);
    }

    public TypeCode create_value_box_tc(String string, String string2, TypeCode typeCode) {
        return new TypeCodeImpl(30, new RepositoryId(string), string2, typeCode);
    }

    public Any create_any() {
        return new AnyImpl();
    }

    public Policy create_policy(int n, Any any) throws PolicyError {
        Policy policy = ((POAImpl)this.getRootPOA()).create_policy(n, any);
        if (policy != null) {
            return policy;
        }
        switch (n) {
            case 32: {
                return new RelativeRoundtripTimeoutPolicyImpl(TimeTHelper.extract(any));
            }
            case 31: {
                return new RelativeRequestTimeoutPolicyImpl(TimeTHelper.extract(any));
            }
            case 28: {
                return new RequestEndTimePolicyImpl(UtcTHelper.extract(any));
            }
            case 30: {
                return new ReplyEndTimePolicyImpl(UtcTHelper.extract(any));
            }
            case 56: {
                return new OTSPolicyImpl(any.extract_ushort());
            }
            case 55: {
                return new InvocationPolicyImpl(any.extract_ushort());
            }
        }
        throw new PolicyError("create_policy()", 1);
    }

    public Current get_current() {
        throw new NO_IMPLEMENT();
    }

    public boolean get_service_information(short s, ServiceInformationHolder serviceInformationHolder) {
        throw new NO_IMPLEMENT();
    }

    public DynAny create_dyn_any(Any any) {
        throw new NO_IMPLEMENT();
    }

    public DynAny create_basic_dyn_any(TypeCode typeCode) throws InconsistentTypeCode {
        throw new NO_IMPLEMENT();
    }

    public DynStruct create_dyn_struct(TypeCode typeCode) throws InconsistentTypeCode {
        throw new NO_IMPLEMENT();
    }

    public DynSequence create_dyn_sequence(TypeCode typeCode) throws InconsistentTypeCode {
        throw new NO_IMPLEMENT();
    }

    public DynArray create_dyn_array(TypeCode typeCode) throws InconsistentTypeCode {
        throw new NO_IMPLEMENT();
    }

    public DynUnion create_dyn_union(TypeCode typeCode) throws InconsistentTypeCode {
        throw new NO_IMPLEMENT();
    }

    public DynEnum create_dyn_enum(TypeCode typeCode) throws InconsistentTypeCode {
        throw new NO_IMPLEMENT();
    }

    protected static void p(String string) {
        System.out.println("<ORB> " + string);
    }

    private static final POA createRootPOA(String string) {
        try {
            if (string == null) {
                return new POAImpl(ROOT_POA).export();
            }
            return new POAImpl(string + "/" + ROOT_POA).export();
        }
        catch (IOException iOException) {
            throw (BAD_PARAM)new BAD_PARAM(iOException.getMessage(), 1330446346, CompletionStatus.COMPLETED_NO).initCause((Throwable)iOException);
        }
    }

    private final synchronized POA getRootPOA() {
        if (this.rootPOA == null) {
            this.rootPOA = ORB.createRootPOA(this.name);
            this.initialRefs.put(ROOT_POA, this.rootPOA);
        }
        return this.rootPOA;
    }

    private static final class SingletonMaker {
        private static final ORB ORB = new ORB(true);

        private SingletonMaker() {
        }
    }
}

