/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.rmic;

import weblogic.corba.rmic.IDLField;
import weblogic.corba.rmic.IDLOptions;
import weblogic.iiop.IDLUtils;
import weblogic.iiop.Utils;

public final class IDLAttribute
extends IDLField {
    public static final int READONLY = 1;
    public static final int READWRITE = 2;
    public static final int CONST = 4;
    public static final int WRITEONLY = 8;
    int m_modifier;

    public IDLAttribute(String string, int n, Object object, Class clazz) {
        super(null, null);
        this.m_mangledName = string;
        this.m_modifier = n;
        this.m_value = object;
        this.m_type = clazz;
    }

    public boolean isReadOnly() {
        return 1 == this.m_modifier;
    }

    public void setModifier(int n) {
        this.m_modifier = n;
    }

    public int getModifier() {
        return this.m_modifier;
    }

    public String getName() {
        return this.m_mangledName;
    }

    public String toIDL() {
        String string;
        try {
            string = IDLUtils.getIDLType(this.m_type);
        }
        catch (Exception exception) {
            return "// error generating the type for " + this.m_mangledName;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (IDLUtils.isValueType(this.m_type) && IDLOptions.getNoValueTypes() || Utils.isAbstractInterface(this.m_type) && IDLOptions.getNoAbstract() || IDLOptions.getOrbix() && string.endsWith(this.m_mangledName)) {
            stringBuffer.append("// ");
        }
        if (this.isReadOnly()) {
            stringBuffer.append("readonly ");
        }
        stringBuffer.append("attribute ");
        stringBuffer.append(string).append(" ").append(this.m_mangledName);
        if (null != this.m_value) {
            stringBuffer.append(" = ");
            String string2 = this.m_value.toString();
            if (String.class.equals(this.m_value.getClass())) {
                string2 = '\"' + string2 + '\"';
            }
            stringBuffer.append(string2);
        }
        stringBuffer.append(";\n");
        return stringBuffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

