/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.rmic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import weblogic.corba.rmic.IDLOptions;
import weblogic.iiop.IDLUtils;

public class IDLField
implements Cloneable {
    protected String m_mangledName = null;
    protected Class m_type = null;
    protected boolean m_isConst = false;
    protected Object m_value = null;
    boolean m_isPublic = false;
    Field m_field = null;
    Class m_class = null;

    public IDLField(Class clazz, Field field) {
        this.init(clazz, field);
    }

    void init(Class clazz, Field field) {
        this.m_class = clazz;
        this.m_field = field;
        if (null != this.m_field) {
            int n = this.m_field.getModifiers();
            if (Modifier.isPublic(n)) {
                this.m_isPublic = true;
            }
            this.m_isConst = Modifier.isPublic(n) && Modifier.isStatic(n) && Modifier.isFinal(n);
            this.m_mangledName = IDLUtils.mangleAttributeName(this.m_class, field);
            if (this.m_isConst) {
                try {
                    this.m_value = field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            this.m_type = field.getType();
        }
    }

    public Field getField() {
        return this.m_field;
    }

    public Object getValue() {
        return this.m_value;
    }

    public Class getType() {
        return this.m_type;
    }

    public String getMangledName() {
        return this.m_mangledName;
    }

    public void setMangledName(String string) {
        this.m_mangledName = string;
    }

    public boolean isConst() {
        return this.m_isConst;
    }

    public boolean isPublic() {
        return this.m_isPublic;
    }

    public boolean isPrimitive() {
        return this.m_type.isPrimitive();
    }

    public String getName() {
        return this.m_field.getName();
    }

    public String toIDL() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            string = IDLUtils.getIDLType(this.m_type);
        }
        catch (Exception exception) {
            return "// error generating the type for " + this.m_mangledName;
        }
        if (IDLOptions.getOrbix() && string.endsWith(this.m_mangledName)) {
            stringBuffer.append("// ");
        }
        if (this.isConst()) {
            stringBuffer.append("const ");
        } else if (this.isPublic()) {
            stringBuffer.append("public ");
        } else {
            stringBuffer.append("private ");
        }
        stringBuffer.append(string).append(" ").append(this.m_mangledName);
        if (null != this.m_value && IDLUtils.isValueType(this.m_value.getClass())) {
            stringBuffer.append(" = ");
            String string2 = this.m_value.toString();
            if (String.class.equals(this.m_value.getClass())) {
                string2 = '\"' + string2 + '\"';
            } else if (Character.class.equals(this.m_value.getClass())) {
                Character c = (Character)this.m_value;
                char c2 = c.charValue();
                int n = Character.getNumericValue(c2) & 0xFFFF;
                string2 = "'\\u" + Integer.toHexString(n) + "'";
            }
            stringBuffer.append(string2);
        }
        stringBuffer.append(";\n");
        return stringBuffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

