/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.rmic;

import java.io.File;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import weblogic.corba.rmic.IDLGeneratorOptions;
import weblogic.corba.rmic.IDLOptions;
import weblogic.corba.rmic.IDLType;
import weblogic.corba.rmic.IDLTypeRemote;
import weblogic.corba.rmic.Structure;
import weblogic.corba.rmic.StructureTokenizer;
import weblogic.iiop.IDLUtils;
import weblogic.rmi.utils.Utilities;
import weblogic.utils.Getopt2;
import weblogic.utils.compiler.CodeGenerationException;
import weblogic.utils.compiler.CodeGenerator;

public class IDLGenerator
extends CodeGenerator
implements IDLGeneratorOptions {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    static boolean m_idlOverwrite = false;
    static String m_idlDirectory = null;
    static boolean m_idlVerbose = false;
    static String m_idlFile = null;
    static String m_idlMethodSignatures = null;
    static Output m_currentOutput = null;

    public IDLGenerator(Getopt2 getopt2) {
        super(getopt2);
        IDLGenerator.addIDLGeneratorOptions(getopt2);
    }

    public static void addIDLGeneratorOptions(Getopt2 getopt2) {
        getopt2.addFlag("idl", "Generate idl for remote interfaces");
        getopt2.addFlag("idlOverwrite", "Always overwrite existing IDL files");
        getopt2.addFlag("idlVerbose", "Display verbose information for IDL generation");
        getopt2.addFlag("idlStrict", "Generate IDL according to the OMG standard");
        getopt2.addFlag("idlFactories", "Generate factory methods for valuetypes");
        getopt2.addFlag("idlNoValueTypes", "Do not generate valuetypes and methods/attributes that contain them.");
        getopt2.addFlag("idlNoAbstractInterfaces", "Do not generate abstract interfaces and methods/attributes that contain them.");
        getopt2.addFlag("idlCompatibility", "Substitute structs for value types to generate CORBA 2.2 compatible IDL.");
        getopt2.markPrivate("idlCompatibility");
        getopt2.addOption("idlMethodSignatures", "", "Specify the method signatures used to trigger idl code generation.");
        getopt2.addFlag("idlVisibroker", "Generate IDL somewhat compatible with Visibroker 4.5 C++");
        getopt2.addFlag("idlOrbix", "Generate IDL somewhat compatible with Orbix 2000 2.0 C++");
        getopt2.addOption("idlDirectory", "directory", "Specify the directory where IDL files will be created (default : current directory)");
    }

    public String impl_class_type() {
        return m_currentOutput.getIDLType().getClassName();
    }

    public String forward_references_iterator() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            IDLType iDLType = m_currentOutput.getIDLType();
            Hashtable hashtable = new Hashtable();
            iDLType.getReferences(hashtable);
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                Object v = enumeration.nextElement();
                IDLType iDLType2 = (IDLType)v;
                Class clazz = iDLType2.getJavaClass();
                if (clazz.isAssignableFrom(iDLType.getJavaClass())) {
                    stringBuffer.append(IDLUtils.generateInclude(iDLType2.getDirectory(), clazz));
                    continue;
                }
                stringBuffer.append(iDLType2.getForwardDeclaration());
            }
        }
        catch (CodeGenerationException codeGenerationException) {
            stringBuffer.append("/*\n" + codeGenerationException.toString() + "\n*/\n");
        }
        if (this.getIDLVerbose()) {
            stringBuffer.append("\n// Generated from " + m_currentOutput.getIDLType() + "\n");
        }
        return stringBuffer.toString();
    }

    public String guard_name() {
        IDLType iDLType = m_currentOutput.getIDLType();
        return iDLType.getGuardName("");
    }

    public String main_declaration() {
        StringBuffer stringBuffer = new StringBuffer("");
        IDLType iDLType = m_currentOutput.getIDLType();
        Class clazz = iDLType.getJavaClass();
        try {
            boolean bl = iDLType.isRequired();
            if (!bl) {
                stringBuffer.append("// valuetypes or abstract interfaces are excluded\n");
                stringBuffer.append("/*\n");
            }
            stringBuffer.append(IDLUtils.openModule(clazz));
            stringBuffer.append(iDLType.getOpeningDeclaration());
            stringBuffer.append(iDLType.getOpenBrace());
            stringBuffer.append(iDLType.generateAttributes());
            stringBuffer.append(iDLType.generateMethods());
            stringBuffer.append(iDLType.generateExtraLines());
            stringBuffer.append("\n" + iDLType.getPragmaID() + "\n");
            stringBuffer.append(iDLType.getCloseBrace());
            stringBuffer.append(IDLUtils.closeModule(clazz));
            if (!bl) {
                stringBuffer.append("*/\n");
                stringBuffer.append("// valuetypes or abstract interfaces are excluded\n");
            }
        }
        catch (CodeGenerationException codeGenerationException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public String include_iterator() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            IDLType iDLType = m_currentOutput.getIDLType();
            Hashtable hashtable = new Hashtable();
            iDLType.getReferences(hashtable);
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                Object v = enumeration.nextElement();
                IDLType iDLType2 = (IDLType)v;
                if (!iDLType2.isRequired() || iDLType2.isAssignableFrom(iDLType)) continue;
                stringBuffer.append(iDLType2.getIncludeDeclaration());
            }
        }
        catch (CodeGenerationException codeGenerationException) {
            stringBuffer.append("/*\n" + codeGenerationException.toString() + "\n*/\n");
        }
        return stringBuffer.toString();
    }

    public String before_main_declaration() throws CodeGenerationException {
        IDLType iDLType = m_currentOutput.getIDLType();
        return iDLType.beforeMainDeclaration();
    }

    public String after_main_declaration() throws CodeGenerationException {
        IDLType iDLType = m_currentOutput.getIDLType();
        return iDLType.afterMainDeclaration();
    }

    protected void extractOptionValues(Getopt2 getopt2) {
        m_idlOverwrite = getopt2.hasOption("idlOverwrite");
        m_idlDirectory = getopt2.getOption("idlDirectory", null);
        if (null == m_idlDirectory) {
            m_idlDirectory = super.getRootDirectoryName();
        } else {
            this.setRootDirectoryName(m_idlDirectory);
        }
        m_idlVerbose = getopt2.hasOption("idlVerbose");
        m_idlFile = getopt2.getOption("idlFile", null);
        m_idlMethodSignatures = getopt2.getOption("idlMethodSignatures", null);
        IDLOptions.setIDLStrict(getopt2.hasOption("idlStrict"));
        IDLOptions.setFactories(getopt2.hasOption("idlFactories"));
        IDLOptions.setNoValueTypes(getopt2.hasOption("idlNoValueTypes"));
        IDLOptions.setNoAbstract(getopt2.hasOption("idlNoAbstractInterfaces"));
        IDLOptions.setCompatibility(getopt2.hasOption("idlCompatibility"));
        IDLOptions.setVisibroker(getopt2.hasOption("idlVisibroker"));
        IDLOptions.setOrbix(getopt2.hasOption("idlOrbix"));
    }

    public String getIDLFile() {
        return m_idlFile;
    }

    String getIDLDirectory() {
        if (m_idlDirectory != null) {
            return m_idlDirectory.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        }
        return null;
    }

    public String getRootDirectoryName() {
        return this.getIDLDirectory();
    }

    boolean getIDLOverwrite() {
        return m_idlOverwrite;
    }

    boolean getIDLVerbose() {
        return m_idlVerbose;
    }

    boolean getIDLStrict() {
        return IDLOptions.getIDLStrict();
    }

    String getIDLMethodSignatures() {
        return m_idlMethodSignatures;
    }

    public Enumeration outputs(Object[] objectArray) throws Exception {
        String[] stringArray = (String[])objectArray;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Hashtable hashtable2 = new Hashtable();
        Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
        IDLType.resetUsedTypes();
        this.processOverrides();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Enumeration enumeration;
            Class clazz = Utilities.classForName((String)stringArray[i]);
            Class clazz2 = IDLUtils.getRemoteInterface(clazz);
            if (clazz2 != null) {
                enumeration = new IDLTypeRemote(clazz2, null);
                hashtable.put(((IDLType)((Object)enumeration)).getFileName(), enumeration);
                object = IDLUtils.getClasses(clazz2, false, true);
                for (int j = 0; j < ((Class[])object).length; ++j) {
                    IDLType.createType(object[j], clazz2);
                }
            } else {
                IDLType.createType(clazz, null);
            }
            enumeration = IDLType.getUsedTypes().elements();
            while (enumeration.hasMoreElements()) {
                object = (Class[])enumeration.nextElement();
                if (!((IDLType)object).isRequired()) continue;
                hashtable.put(((IDLType)object).getFileName(), object);
            }
            while (!hashtable.isEmpty()) {
                this.generateIDLFiles(hashtable);
                hashtable3.putAll(hashtable);
                hashtable.clear();
                enumeration = IDLType.getUsedTypes().elements();
                while (enumeration.hasMoreElements()) {
                    object = (IDLType)enumeration.nextElement();
                    if (hashtable3.containsKey(((IDLType)object).getFileName()) || !((IDLType)object).isRequired()) continue;
                    hashtable.put(((IDLType)object).getFileName(), object);
                }
            }
        }
        return hashtable2.elements();
    }

    void processOverrides() throws Exception {
        IDLType.clearOverrides();
        if (this.getIDLMethodSignatures() == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.getIDLMethodSignatures(), ";", false);
        StringBuffer stringBuffer = new StringBuffer("(idlMethodSignatures");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("(").append(stringTokenizer.nextToken()).append("generate true)");
        }
        stringBuffer.append(")");
        String string = stringBuffer.toString();
        StructureTokenizer structureTokenizer = new StructureTokenizer(new StringReader(stringBuffer.toString()));
        this.createOverrides(structureTokenizer.parseStructure());
    }

    void createOverrides(Structure structure) {
        Hashtable hashtable = structure.elements;
        Enumeration enumeration = hashtable.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = null;
            Hashtable hashtable2 = (Hashtable)hashtable.get(string);
            Enumeration enumeration2 = hashtable2.keys();
            int n2 = 0;
            while (enumeration2.hasMoreElements()) {
                Object k = enumeration2.nextElement();
                if (k instanceof String) {
                    String string3;
                    String string4 = (String)k;
                    if (string4.compareToIgnoreCase("generate") != 0 || (string3 = (String)hashtable2.get(string4)).compareToIgnoreCase("true") == 0) {
                        // empty if block
                    }
                    string2 = string4;
                }
                ++n2;
            }
            IDLType.registerOverride(string, string2);
            ++n;
        }
    }

    public void generateIDLFiles(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            boolean bl;
            IDLType iDLType = (IDLType)enumeration.nextElement();
            String string = this.getIDLDirectory();
            String string2 = iDLType.getFileName();
            if (null != string) {
                string2 = string + File.separatorChar + string2;
            }
            if (!(bl = IDLUtils.isARemote(iDLType.getJavaClass()) | this.getIDLOverwrite()) && !(object = new File(string2)).exists()) {
                bl = true;
            }
            if (bl) {
                if (this.getIDLVerbose()) {
                    System.out.println("Generating " + string2 + " for type " + iDLType);
                }
                object = new Output(iDLType.getFileName(), "idl.j", iDLType.getPackageName(), iDLType);
                try {
                    this.prepare((CodeGenerator.Output)object);
                    this.generateCode((CodeGenerator.Output)object);
                    this.cleanup();
                }
                catch (Exception exception) {}
                continue;
            }
            if (!this.getIDLVerbose()) continue;
            System.out.println("Skipping " + string2);
        }
    }

    protected void prepare(CodeGenerator.Output output) throws Exception {
        m_currentOutput = (Output)output;
        super.prepare(output);
    }

    public static IDLType getCurrentType() {
        return m_currentOutput.getIDLType();
    }

    private static class Output
    extends CodeGenerator.Output {
        private IDLType m_type;

        Output(String string, String string2, String string3, IDLType iDLType) {
            super(string, string2, string3);
            this.m_type = iDLType;
        }

        public IDLType getIDLType() {
            return this.m_type;
        }
    }
}

